/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.receipt.element.BonReceptionSQLElement;
import org.openconcerto.erp.core.supplychain.receipt.ui.BonReceptionItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;

public class BonReceptionSQLComponent
extends TransfertBaseSQLComponent {
    private BonReceptionItemTable tableBonItem;
    private ElementComboBox selectCommande;
    private ElementComboBox fournisseur;
    private JUniqueTextField textNumeroUnique;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final DeviseField textTotalHT = new DeviseField();
    private final DeviseField textTotalTVA = new DeviseField();
    private final DeviseField textTotalTTC = new DeviseField();
    private final JTextField textPoidsTotal = new JTextField(6);
    private final JTextField textReference = new JTextField(25);

    public BonReceptionSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("BON_RECEPTION"));
    }

    @Override
    protected SQLRowValues createDefaults() {
        this.tableBonItem.getModel().clearRows();
        return super.createDefaults();
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = new JPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textTotalHT.setOpaque(false);
        this.textTotalTVA.setOpaque(false);
        this.textTotalTTC.setOpaque(false);
        this.selectCommande = new ElementComboBox();
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        JDate date = new JDate(true);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)((Object)date), c);
        ++c.gridy;
        c.gridx = 0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.fill = 2;
        DefaultGridBagConstraints.lockMinimumSize(this.textReference);
        this.add((Component)this.textReference, c);
        JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
        labelFournisseur.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)labelFournisseur, c);
        this.fournisseur = new ElementComboBox();
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fournisseur, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
        ElementComboBox boxDevise = new ElementComboBox();
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)boxDevise, c);
        this.addView(boxDevise, "ID_DEVISE");
        this.tableBonItem = new BonReceptionItemTable();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.tableBonItem, c);
        c.anchor = 13;
        this.reconfigure(this.textTotalHT);
        this.reconfigure(this.textTotalTVA);
        this.reconfigure(this.textTotalTTC);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.fill = 0;
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        if (b.booleanValue()) {
            JPanel panelPoids = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
            c2.fill = 0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("TOTAL_POIDS")), c2);
            DefaultGridBagConstraints.lockMinimumSize(this.textPoidsTotal);
            this.textPoidsTotal.setEnabled(false);
            this.textPoidsTotal.setHorizontalAlignment(4);
            this.textPoidsTotal.setDisabledTextColor(Color.BLACK);
            ++c2.gridx;
            c2.weightx = 1.0;
            c2.fill = 2;
            panelPoids.add((Component)this.textPoidsTotal, c2);
            this.add((Component)panelPoids, c);
        }
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 2;
        DefaultGridBagConstraints cTotalPan = new DefaultGridBagConstraints();
        JPanel panelTotalHT = new JPanel();
        panelTotalHT.setLayout(new GridBagLayout());
        cTotalPan.gridx = 0;
        cTotalPan.weightx = 0.0;
        cTotalPan.fill = 2;
        cTotalPan.anchor = 17;
        JLabelBold labelTotalHT = new JLabelBold(this.getLabelFor("TOTAL_HT"));
        panelTotalHT.add((Component)labelTotalHT, cTotalPan);
        cTotalPan.anchor = 13;
        ++cTotalPan.gridx;
        cTotalPan.weightx = 1.0;
        this.textTotalHT.setFont(labelTotalHT.getFont());
        DefaultGridBagConstraints.lockMinimumSize(this.textTotalHT);
        panelTotalHT.add((Component)this.textTotalHT, cTotalPan);
        this.add((Component)panelTotalHT, c);
        JPanel panelTotalTVA = new JPanel();
        panelTotalTVA.setLayout(new GridBagLayout());
        cTotalPan.gridx = 0;
        cTotalPan.weightx = 0.0;
        cTotalPan.anchor = 17;
        cTotalPan.fill = 2;
        panelTotalTVA.add((Component)new JLabelBold(this.getLabelFor("TOTAL_TVA")), cTotalPan);
        cTotalPan.anchor = 13;
        ++cTotalPan.gridx;
        cTotalPan.weightx = 1.0;
        DefaultGridBagConstraints.lockMinimumSize(this.textTotalTVA);
        panelTotalTVA.add((Component)this.textTotalTVA, cTotalPan);
        ++c.gridy;
        c.fill = 2;
        this.add((Component)panelTotalTVA, c);
        JPanel panelTotalTTC = new JPanel();
        panelTotalTTC.setLayout(new GridBagLayout());
        cTotalPan.gridx = 0;
        cTotalPan.anchor = 17;
        cTotalPan.gridwidth = 0;
        cTotalPan.fill = 1;
        cTotalPan.weightx = 1.0;
        panelTotalTTC.add((Component)new JSeparator(), cTotalPan);
        cTotalPan.gridwidth = 1;
        cTotalPan.fill = 0;
        cTotalPan.weightx = 0.0;
        ++cTotalPan.gridy;
        panelTotalTTC.add((Component)new JLabelBold(this.getLabelFor("TOTAL_TTC")), cTotalPan);
        cTotalPan.anchor = 13;
        ++cTotalPan.gridx;
        this.textTotalTTC.setFont(labelTotalHT.getFont());
        DefaultGridBagConstraints.lockMinimumSize(this.textTotalTTC);
        panelTotalTTC.add((Component)this.textTotalTTC, cTotalPan);
        ++c.gridy;
        this.add((Component)panelTotalTTC, c);
        c.anchor = 17;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        TitledSeparator sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        ITextArea textInfos = new ITextArea(4, 4);
        JScrollPane scrollPane = new JScrollPane(textInfos);
        textInfos.setBorder(null);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)textInfos, c);
        this.addRequiredSQLObject((JComponent)((Object)date), "DATE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject(this.textReference, "NOM");
        this.addSQLObject(this.selectCommande, "ID_COMMANDE");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addSQLObject(this.textPoidsTotal, "TOTAL_POIDS");
        this.addRequiredSQLObject(this.textTotalHT, "TOTAL_HT");
        this.addRequiredSQLObject(this.textTotalTVA, "TOTAL_TVA");
        this.addRequiredSQLObject(this.textTotalTTC, "TOTAL_TTC");
        this.addRequiredSQLObject(this.fournisseur, "ID_FOURNISSEUR");
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(BonReceptionSQLElement.class));
        this.tableBonItem.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int columnIndexHT = BonReceptionSQLComponent.this.tableBonItem.getModel().getColumnIndexForElement(BonReceptionSQLComponent.this.tableBonItem.getPrixTotalHTElement());
                int columnIndexTTC = BonReceptionSQLComponent.this.tableBonItem.getModel().getColumnIndexForElement(BonReceptionSQLComponent.this.tableBonItem.getPrixTotalTTCElement());
                int columnIndexPoids = BonReceptionSQLComponent.this.tableBonItem.getModel().getColumnIndexForElement(BonReceptionSQLComponent.this.tableBonItem.getPoidsTotalElement());
                if (e.getColumn() == -1 || e.getColumn() == columnIndexHT || e.getColumn() == columnIndexTTC) {
                    BonReceptionSQLComponent.this.updateTotal();
                }
                if (e.getColumn() == -1 || e.getColumn() == columnIndexPoids) {
                    BonReceptionSQLComponent.this.textPoidsTotal.setText(String.valueOf((double)Math.round(BonReceptionSQLComponent.this.tableBonItem.getPoidsTotal() * 1000.0f) / 1000.0));
                }
            }
        });
        DefaultGridBagConstraints.lockMinimumSize(this.fournisseur);
    }

    private void reconfigure(JTextField field) {
        field.setEnabled(false);
        field.setHorizontalAlignment(4);
        field.setDisabledTextColor(Color.BLACK);
        field.setBorder(null);
    }

    @Override
    public int insert(SQLRow order) {
        int idBon = this.getSelectedID();
        if (this.textNumeroUnique.checkValidation()) {
            idBon = super.insert(order);
            this.tableBonItem.updateField("ID_BON_RECEPTION", idBon);
            if (NumerotationAutoSQLElement.getNextNumero(BonReceptionSQLElement.class).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt("BON_R_START");
                rowVals.put("BON_R_START", new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            this.calculPHaPondere(idBon);
            this.updateStock(idBon);
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idBon;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.textNumeroUnique.setIdSelected(r.getID());
        }
        super.select(r);
        if (r != null) {
            this.tableBonItem.insertFrom("ID_BON_RECEPTION", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.textNumeroUnique.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
        SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
        sel.addSelect(eltMvtStock.getTable().getField("ID"));
        Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
        Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
        sel.setWhere(w.and(w2));
        List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                try {
                    eltMvtStock.archive(((Number)tmp[0]).intValue());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        super.update();
        this.tableBonItem.updateField("ID_BON_RECEPTION", this.getSelectedID());
        this.updateStock(this.getSelectedID());
    }

    private void updateTotal() {
        RowValuesTableModel model = this.tableBonItem.getModel();
        long totalHT = 0L;
        long totalTTC = 0L;
        int columnIndexHT = model.getColumnIndexForElement(this.tableBonItem.getPrixTotalHTElement());
        int columnIndexTTC = model.getColumnIndexForElement(this.tableBonItem.getPrixTotalTTCElement());
        int i = 0;
        while (i < model.getRowCount()) {
            Number nHT = (Number)model.getValueAt(i, columnIndexHT);
            totalHT += nHT.longValue();
            Number nTTC = (Number)model.getValueAt(i, columnIndexTTC);
            totalTTC += nTTC.longValue();
            ++i;
        }
        this.textTotalHT.setText(GestionDevise.currencyToString(totalHT));
        this.textTotalTVA.setText(GestionDevise.currencyToString(totalTTC - totalHT));
        this.textTotalTTC.setText(GestionDevise.currencyToString(totalTTC));
    }

    private void calculPHaPondere(int id) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
        SQLRow row = this.getTable().getRow(id);
        SQLTable sqlTableBonElt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("BON_RECEPTION_ELEMENT");
        Collection elts = row.getReferentRows(sqlTableBonElt);
        for (SQLRow rowEltBon : elts) {
            SQLRowValues rowVals = rowEltBon.createUpdateRow();
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowVals, false);
            if (idArticle <= 1) continue;
            SQLRow rowArticle = eltArticle.getTable().getRow(idArticle);
            Long prixHA = (Long)rowArticle.getObject("PRIX_METRIQUE_HA_1");
            int idStock = rowArticle.getInt("ID_STOCK");
            SQLRow rowStock = eltStock.getTable().getRow(idStock);
            int qteStock = rowStock.getInt("QTE_REEL");
            if (prixHA == null || qteStock <= 0) continue;
            int qteRecue = rowEltBon.getInt("QTE");
            Long prixHACmd = (Long)rowEltBon.getObject("PRIX_METRIQUE_HA_1");
            if (qteRecue <= 0 || prixHACmd == null) continue;
            long prixHaPond = ((long)qteRecue * prixHACmd + (long)qteStock * prixHA) / (long)(qteRecue + qteStock);
            SQLRowValues rowValsArticle = rowArticle.createEmptyUpdateRow();
            rowValsArticle.put("PRIX_METRIQUE_HA_1", prixHaPond);
            try {
                rowValsArticle.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateStock(int id) {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLTable sqlTableBonElt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("BON_RECEPTION_ELEMENT");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLRow row = this.getTable().getRow(id);
        Collection elts = row.getReferentRows(sqlTableBonElt);
        for (SQLRow rowElt : elts) {
            SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
            for (SQLField field : eltArticle.getTable().getFields()) {
                if (!rowElt.getTable().getFieldsName().contains(field.getName())) continue;
                rowArticle.put(field.getName(), rowElt.getObject(field.getName()));
            }
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLRowValues rowVals = new SQLRowValues(eltMvtStock.getTable());
            rowVals.put("QTE", rowElt.getInt("QTE"));
            rowVals.put("NOM", "Bon de r\u00e9ception N\u00b0" + row.getString("NUMERO"));
            rowVals.put("IDSOURCE", id);
            rowVals.put("SOURCE", this.getTable().getName());
            rowVals.put("ID_ARTICLE", idArticle);
            rowVals.put("DATE", row.getObject("DATE"));
            try {
                SQLRow rowInsert = rowVals.insert();
                MouvementStockSQLElement.updateStock(Arrays.asList(rowInsert.getID()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

