/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.order.component.SaisieAchatSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;

public class CommandeSQLElement
extends ComptaSQLConfElement {
    public CommandeSQLElement() {
        super("COMMANDE", "une commande fournisseur", "commandes fournisseur");
        RowAction.PredicateRowAction factureAction = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers saisie achat"){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeSQLElement.this.transfertFacture(IListe.get(e).getSelectedRow().getID());
            }
        }, false);
        factureAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(factureAction);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("T_HT");
        l.add("T_TTC");
        l.add("EN_COURS");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        return l;
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>();
        set.add("COMMANDE_ELEMENT");
        return set;
    }

    @Override
    protected List<String> getPrivateFields() {
        if (this.getTable().getFieldsName().contains("ID_ADRESSE")) {
            ArrayList<String> l = new ArrayList<String>();
            l.add("ID_ADRESSE");
            return l;
        }
        return super.getPrivateFields();
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeSQLComponent();
    }

    public void transfertFacture(int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_ACHAT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieAchatSQLComponent comp = (SaisieAchatSQLComponent)editFactureFrame.getSQLComponent();
        comp.loadCommande(commandeID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
    }
}

