/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.supplychain.order.element.CommandeSQLElement;
import org.openconcerto.erp.core.supplychain.order.ui.CommandeItemTable;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;

public class CommandeSQLComponent
extends TransfertBaseSQLComponent {
    private CommandeItemTable table = new CommandeItemTable();
    private JUniqueTextField numeroUniqueCommande;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final JCheckBox checkImpression = new JCheckBox("Imprimer");
    private final JCheckBox checkVisu = new JCheckBox("Visualiser");
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox fourn = new ElementComboBox();

    public CommandeSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("COMMANDE"));
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        this.numeroUniqueCommande = new JUniqueTextField(16);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueCommande);
        this.add((Component)this.numeroUniqueCommande, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)labelDate, c);
        JDate dateCommande = new JDate(true);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)((Object)dateCommande), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fourn, c);
        if (!this.getTable().getFieldsName().contains("LIVRER")) {
            JCheckBox boxEnCours = new JCheckBox(this.getLabelFor("EN_COURS"));
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)boxEnCours, c);
            this.addRequiredSQLObject(boxEnCours, "EN_COURS");
        }
        if (this.getTable().contains("ID_CONTACT_FOURNISSEUR")) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_CONTACT_FOURNISSEUR"), 4), c);
            c.gridx = -1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            final ElementComboBox boxContactFournisseur = new ElementComboBox();
            final SQLElement contactElement = Configuration.getInstance().getDirectory().getElement("CONTACT_FOURNISSEUR");
            boxContactFournisseur.init(contactElement, new ComboSQLRequest(contactElement.getComboRequest()));
            this.add((Component)boxContactFournisseur, c);
            this.addView(boxContactFournisseur, "ID_CONTACT_FOURNISSEUR", (Object)"required");
            this.fourn.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (CommandeSQLComponent.this.fourn.getSelectedRow() != null) {
                        boxContactFournisseur.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_FOURNISSEUR"), "=", CommandeSQLComponent.this.fourn.getSelectedRow().getID()));
                    } else {
                        boxContactFournisseur.getRequest().setWhere(null);
                    }
                }
            });
        }
        if (this.getTable().getFieldsName().contains("ID_ADRESSE")) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE")), c);
            ++c.gridx;
            c.gridwidth = 0;
            ++c.gridy;
            this.addView("ID_ADRESSE");
            final DefaultElementSQLObject comp = (DefaultElementSQLObject)this.getView("ID_ADRESSE").getComp();
            if (this.getTable().getFieldsName().contains("LIVRAISON_F")) {
                final JCheckBox boxLivr = new JCheckBox("Livr\u00e9 par le fournisseur");
                this.add((Component)boxLivr, c);
                this.addSQLObject(boxLivr, "LIVRAISON_F");
                boxLivr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (boxLivr.isSelected() && !comp.isCreated()) {
                            comp.setCreated(true);
                            if (CommandeSQLComponent.this.getTable().contains("ID_AFFAIRE")) {
                                SQLRowValues rowVals = CommandeSQLComponent.this.getLivraisonAdr(((ElementComboBox)CommandeSQLComponent.this.getView("ID_AFFAIRE").getComp()).getSelectedRow());
                                comp.setValue(rowVals);
                            }
                        } else if (!boxLivr.isSelected()) {
                            comp.setCreated(false);
                        }
                    }
                });
            }
            ++c.gridy;
            this.add((Component)comp, c);
            this.add(this.getView("ID_ADRESSE").getComp(), c);
        }
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = new JPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        final ElementComboBox boxDevise = new ElementComboBox();
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
            c.gridx = -1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            this.add((Component)boxDevise, c);
            this.addView(boxDevise, "ID_DEVISE");
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 13;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        JTextField textNom = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textNom, c);
        String field = "ID_COMMERCIAL";
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)new JLabel(this.getLabelFor(field), 4), c);
        ElementComboBox commSel = new ElementComboBox(false, 25);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)commSel, c);
        this.addRequiredSQLObject(commSel, field);
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.add((Component)this.table, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            boxDevise.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CommandeSQLComponent.this.table.setDevise(boxDevise.getSelectedRow());
                }
            });
        }
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.getBottomPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.anchor = 17;
        JPanel panelOO = new JPanel(new FlowLayout(2));
        panelOO.add((Component)this.checkImpression, c);
        panelOO.add((Component)this.checkVisu, c);
        c.gridwidth = 0;
        this.add((Component)panelOO, c);
        this.addRequiredSQLObject(this.fourn, "ID_FOURNISSEUR");
        this.addSQLObject(textNom, "NOM");
        this.addRequiredSQLObject((JComponent)((Object)dateCommande), "DATE");
        this.addRequiredSQLObject(this.numeroUniqueCommande, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class));
        DefaultGridBagConstraints.lockMinimumSize(this.fourn);
        DefaultGridBagConstraints.lockMinimumSize(commSel);
    }

    protected SQLRowValues getLivraisonAdr(SQLRow rowAffaire) {
        if (rowAffaire != null) {
            SQLRow rowClient = rowAffaire.getForeignRow("ID_CLIENT");
            SQLRow rowAdrL = rowClient.getForeignRow("ID_ADRESSE_L");
            if (rowAdrL == null || rowAdrL.isUndefined()) {
                rowAdrL = rowClient.getForeignRow("ID_ADRESSE");
            }
            SQLRowValues rowVals = rowAdrL.asRowValues();
            rowVals.clearPrimaryKeys();
            return rowVals;
        }
        return new SQLRowValues(this.getTable().getTable("ADRESSE"));
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        panel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, c);
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        final JTextField textPoidsTotal = new JTextField(8);
        JTextField poids = new JTextField();
        if (b.booleanValue()) {
            JPanel panelPoids = new JPanel();
            panelPoids.add((Component)new JLabel(this.getLabelFor("T_POIDS")), c);
            textPoidsTotal.setEnabled(false);
            textPoidsTotal.setHorizontalAlignment(4);
            textPoidsTotal.setDisabledTextColor(Color.BLACK);
            panelPoids.add((Component)textPoidsTotal, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
            this.addSQLObject(textPoidsTotal, "T_POIDS");
        } else {
            this.addSQLObject(poids, "T_POIDS");
        }
        DeviseField textPortHT = new DeviseField();
        if (this.getTable().contains("PORT_HT")) {
            this.addRequiredSQLObject(textPortHT, "PORT_HT");
            JPanel panelPoids = new JPanel();
            panelPoids.add((Component)new JLabel(this.getLabelFor("PORT_HT")), c);
            textPortHT.setHorizontalAlignment(4);
            panelPoids.add((Component)textPortHT, c);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
        }
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        fieldHT.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addRequiredSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        final TotalPanel totalTTC = new TotalPanel(this.table.getRowValuesTable(), this.table.getPrixTotalHTElement(), this.table.getPrixTotalTTCElement(), this.table.getHaElement(), this.table.getQteElement(), fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, this.table.getPrixServiceElement(), fieldDevise, this.table.getTableElementTotalDevise(), poids, this.table.getPoidsTotalElement());
        ++c.gridx;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 1;
        c.weighty = 0.0;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        panel.add((Component)totalTTC, c);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(CommandeSQLComponent.this.table.getPoidsTotal()));
            }
        });
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        return panel;
    }

    @Override
    public int insert(SQLRow order) {
        int idCommande = this.getSelectedID();
        if (this.numeroUniqueCommande.checkValidation()) {
            idCommande = super.insert(order);
            this.table.updateField("ID_COMMANDE", idCommande);
            this.table.createArticle(idCommande, this.getElement());
            CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(idCommande));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.checkVisu.isSelected(), this.checkImpression.isSelected(), true);
            if (NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class).equalsIgnoreCase(this.numeroUniqueCommande.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(CommandeSQLElement.class));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(CommandeSQLElement.class), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idCommande;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.numeroUniqueCommande.setIdSelected(r.getID());
        }
        super.select(r);
        if (r != null) {
            this.table.insertFrom("ID_COMMANDE", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueCommande.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_COMMANDE", this.getSelectedID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(this.getSelectedID()));
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.checkVisu.isSelected(), this.checkImpression.isSelected(), true);
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        rowVals.put("EN_COURS", Boolean.TRUE);
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_DEVISE", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_TTC", 0L);
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(CommandeSQLElement.class));
        return rowVals;
    }

    public CommandeItemTable getRowValuesTable() {
        return this.table;
    }
}

