/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.credit.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.SocieteCommonSQLElement;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.sales.credit.element.AvoirClientSQLElement;
import org.openconcerto.erp.core.sales.credit.ui.AvoirItemTable;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.generationDoc.gestcomm.AvoirClientXmlSheet;
import org.openconcerto.erp.generationEcritures.GenerationMvtAvoirClient;
import org.openconcerto.erp.model.ISQLCompteSelector;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidState;

public class AvoirClientSQLComponent
extends TransfertBaseSQLComponent
implements ActionListener {
    private JTextField textNom;
    private JDate date;
    private JUniqueTextField textNumero;
    private JCheckBox checkImpr;
    private JCheckBox checkVisu;
    private AbstractArticleItemTable table;
    private JCheckBox boxAdeduire = new JCheckBox(this.getLabelFor("A_DEDUIRE"));
    private ElementSQLObject eltModeRegl;
    private final SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
    private final SQLElement clientElt = Configuration.getInstance().getDirectory().getElement(this.tableClient);
    private final ElementComboBox comboClient = new ElementComboBox();
    private ElementComboBox comboPole = new ElementComboBox();
    private ElementComboBox comboCommercial = new ElementComboBox();
    private ElementComboBox comboVerificateur = new ElementComboBox();
    private final ElementComboBox comboAdresse = new ElementComboBox();
    private final ElementComboBox comboBanque = new ElementComboBox();
    private JLabel labelCompteServ;
    private ISQLCompteSelector compteSelService;
    private static final SQLTable TABLE_PREFS_COMPTE = Configuration.getInstance().getBase().getTable("PREFS_COMPTE");
    private static final SQLRow ROW_PREFS_COMPTE = TABLE_PREFS_COMPTE.getRow(2);
    private SQLRowValues defaultContactRowValues;
    private JCheckBox checkCompteServiceAuto;
    private PropertyChangeListener listenerModeReglDefaut = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            int idCli = AvoirClientSQLComponent.this.comboClient.getSelectedId();
            if (idCli > 1) {
                SQLRow rowCli = AvoirClientSQLComponent.this.tableClient.getRow(idCli);
                SQLElement sqleltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
                int idModeRegl = rowCli.getInt("ID_MODE_REGLEMENT");
                if (idModeRegl > 1 && AvoirClientSQLComponent.this.eltModeRegl.isCreated() && AvoirClientSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    SQLRow rowModeRegl = sqleltModeRegl.getTable().getRow(idModeRegl);
                    SQLRowValues rowValsModeRegl = rowModeRegl.createUpdateRow();
                    rowValsModeRegl.clearPrimaryKeys();
                    AvoirClientSQLComponent.this.eltModeRegl.setValue(rowValsModeRegl);
                }
            }
        }
    };
    private final ElementComboBox boxTarif = new ElementComboBox();
    private PropertyChangeListener changeClientListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (AvoirClientSQLComponent.this.comboClient.getValue() != null) {
                Integer id = AvoirClientSQLComponent.this.comboClient.getValue();
                AvoirClientSQLComponent.this.defaultContactRowValues.put("ID_CLIENT", id);
                if (id > 1) {
                    SQLRow row = AvoirClientSQLComponent.this.clientElt.getTable().getRow(id);
                    if (AvoirClientSQLComponent.this.comboClient.getElement().getTable().getFieldsName().contains("ID_TARIF")) {
                        SQLRow foreignRow = row.getForeignRow("ID_TARIF");
                        if (!(foreignRow.isUndefined() || AvoirClientSQLComponent.this.boxTarif.getSelectedRow() != null && AvoirClientSQLComponent.this.boxTarif.getSelectedId() == ((SQLRowAccessor)foreignRow).getID() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") != 0)) {
                            AvoirClientSQLComponent.this.boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        } else {
                            AvoirClientSQLComponent.this.boxTarif.setValue(((SQLRowAccessor)foreignRow).getID());
                        }
                    }
                    Where w = new Where((FieldRef)SaisieVenteFactureSQLComponent.TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE"));
                    w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE_L")));
                    w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.TABLE_ADRESSE.getKey(), "=", row.getInt("ID_ADRESSE_F")));
                    List<SQLRow> list = row.getReferentRows(SaisieVenteFactureSQLComponent.TABLE_ADRESSE.getField("ID_CLIENT"));
                    for (SQLRow row2 : list) {
                        w = w.or(new Where((FieldRef)SaisieVenteFactureSQLComponent.TABLE_ADRESSE.getKey(), "=", row2.getID()));
                    }
                    AvoirClientSQLComponent.this.comboAdresse.getRequest().setWhere(w);
                } else {
                    AvoirClientSQLComponent.this.comboAdresse.getRequest().setWhere(null);
                }
            }
        }
    };

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues vals = new SQLRowValues(this.getTable());
        vals.put("A_DEDUIRE", Boolean.TRUE);
        this.eltModeRegl.setEditable(false);
        this.eltModeRegl.setCreated(false);
        int idCompteVenteService = ROW_PREFS_COMPTE.getInt("ID_COMPTE_PCE_VENTE_SERVICE");
        if (idCompteVenteService <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        vals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(AvoirClientSQLElement.class, new Date()));
        vals.put("MONTANT_TTC", 0L);
        vals.put("MONTANT_SERVICE", 0L);
        vals.put("MONTANT_HT", 0L);
        vals.put("MONTANT_TVA", 0L);
        vals.put("ID_COMPTE_PCE_SERVICE", idCompteVenteService);
        return vals;
    }

    public AvoirClientSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT"));
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = new JPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textNom = new JTextField();
        this.date = new JDate(true);
        this.date.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AvoirClientSQLComponent.this.fireValidChange();
            }
        });
        this.comboClient.addValueListener(this.listenerModeReglDefaut);
        this.comboClient.addValueListener(this.changeClientListener);
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        c.weightx = 1.0;
        c.fill = 0;
        ++c.gridx;
        this.textNumero = new JUniqueTextField(16);
        DefaultGridBagConstraints.lockMinimumSize(this.textNumero);
        this.add((Component)this.textNumero, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Date", 4), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        this.add((Component)((Object)this.date), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        ++c.gridx;
        this.add((Component)this.textNom, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("ID_COMMERCIAL"), 4), c);
        ++c.gridx;
        c.fill = 0;
        this.comboCommercial = new ElementComboBox();
        this.comboCommercial.setMinimumSize(this.comboCommercial.getPreferredSize());
        this.add((Component)this.comboCommercial, c);
        this.addSQLObject(this.comboCommercial, "ID_COMMERCIAL");
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("MOTIF"), 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        JTextField textMotif = new JTextField();
        this.add((Component)textMotif, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.comboClient, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        c.gridwidth = 1;
        this.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE"), 4), c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        this.add((Component)this.comboAdresse, c);
        ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        JLabel labelContact = new JLabel(this.getLabelFor("ID_CONTACT"), 4);
        this.add((Component)labelContact, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 0;
        ElementComboBox selectContact = new ElementComboBox();
        this.add((Component)selectContact, c);
        this.addView(selectContact, "ID_CONTACT");
        this.defaultContactRowValues = new SQLRowValues(selectContact.getRequest().getPrimaryTable());
        selectContact.getAddComp().setDefaults(this.defaultContactRowValues);
        this.checkCompteServiceAuto = new JCheckBox(this.getLabelFor("COMPTE_SERVICE_AUTO"));
        this.addSQLObject(this.checkCompteServiceAuto, "COMPTE_SERVICE_AUTO");
        this.compteSelService = new ISQLCompteSelector();
        this.labelCompteServ = new JLabel("Compte Service");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelCompteServ.setHorizontalAlignment(4);
        this.add((Component)this.labelCompteServ, c);
        ++c.gridx;
        c.gridwidth = 0;
        this.add((Component)this.compteSelService, c);
        this.addRequiredSQLObject(this.compteSelService, "ID_COMPTE_PCE_SERVICE");
        String valServ = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServ = Boolean.valueOf(valServ);
        if (!bServ.booleanValue()) {
            this.labelCompteServ.setVisible(false);
            this.compteSelService.setVisible(false);
        }
        this.checkCompteServiceAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvoirClientSQLComponent.this.setCompteServiceVisible(!AvoirClientSQLComponent.this.checkCompteServiceAuto.isSelected());
            }
        });
        if (this.getTable().getFieldsName().contains("ID_TARIF")) {
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            this.add((Component)new JLabel("Tarif \u00e0 appliquer"), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.add((Component)this.boxTarif, c);
            this.addView(this.boxTarif, "ID_TARIF");
            this.boxTarif.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AvoirClientSQLComponent.this.table.setTarif(AvoirClientSQLComponent.this.boxTarif.getSelectedRow(), false);
                }
            });
        }
        this.table = new AvoirItemTable();
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weighty = 1.0;
        this.add((Component)this.table, c);
        this.addView(this.table.getRowValuesTable(), "");
        JPanel panelBottom = this.getBottomPanel();
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)panelBottom, c);
        c.gridheight = 1;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 0.0;
        c.gridwidth = 4;
        ITextArea infos = new ITextArea(4, 4);
        infos.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(infos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)scrollPane, c);
        JPanel panelGestDoc = new JPanel();
        this.checkImpr = new JCheckBox("Imprimer");
        this.checkVisu = new JCheckBox("Visualiser");
        panelGestDoc.add(this.checkImpr);
        panelGestDoc.add(this.checkVisu);
        c.fill = 0;
        ++c.gridy;
        c.anchor = 13;
        this.add((Component)panelGestDoc, c);
        this.addSQLObject(this.textNom, "NOM");
        this.addSQLObject(this.boxAdeduire, "A_DEDUIRE");
        this.addSQLObject(textMotif, "MOTIF");
        this.addSQLObject(this.comboAdresse, "ID_ADRESSE");
        this.addRequiredSQLObject(this.textNumero, "NUMERO");
        this.addRequiredSQLObject((JComponent)((Object)this.date), "DATE");
        this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
        this.boxAdeduire.addActionListener(this);
        DefaultGridBagConstraints.lockMinimumSize(this.comboClient);
        DefaultGridBagConstraints.lockMinimumSize(this.comboAdresse);
        DefaultGridBagConstraints.lockMinimumSize(this.comboBanque);
        DefaultGridBagConstraints.lockMinimumSize(this.comboCommercial);
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.anchor = 18;
        c.weightx = 1.0;
        this.boxAdeduire.setOpaque(false);
        this.boxAdeduire.setMinimumSize(new Dimension(430, this.boxAdeduire.getPreferredSize().height));
        this.boxAdeduire.setPreferredSize(new Dimension(430, this.boxAdeduire.getPreferredSize().height));
        panel.add((Component)this.boxAdeduire, c);
        this.addView("ID_MODE_REGLEMENT", "notdecorated;noseparator");
        this.eltModeRegl = (ElementSQLObject)this.getView("ID_MODE_REGLEMENT");
        ++c.gridy;
        c.fill = 0;
        c.weighty = 1.0;
        this.eltModeRegl.setOpaque(false);
        panel.add((Component)this.eltModeRegl, c);
        JPanel panelPortEtRemise = new JPanel();
        panelPortEtRemise.setOpaque(false);
        panelPortEtRemise.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cFrais = new DefaultGridBagConstraints();
        DeviseField textPortHT = new DeviseField(5);
        DeviseField textRemiseHT = new DeviseField(5);
        cFrais.gridheight = 1;
        cFrais.fill = 3;
        cFrais.weighty = 1.0;
        cFrais.gridx = 1;
        JLabel labelPortHT = new JLabel(this.getLabelFor("PORT_HT"));
        labelPortHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        panelPortEtRemise.add((Component)labelPortHT, cFrais);
        ++cFrais.gridx;
        DefaultGridBagConstraints.lockMinimumSize(textPortHT);
        panelPortEtRemise.add((Component)textPortHT, cFrais);
        JLabel labelRemiseHT = new JLabel(this.getLabelFor("REMISE_HT"));
        labelRemiseHT.setHorizontalAlignment(4);
        ++cFrais.gridy;
        cFrais.gridx = 1;
        panelPortEtRemise.add((Component)labelRemiseHT, cFrais);
        ++cFrais.gridx;
        DefaultGridBagConstraints.lockMinimumSize(textRemiseHT);
        panelPortEtRemise.add((Component)textRemiseHT, cFrais);
        ++cFrais.gridy;
        ++c.gridx;
        c.gridy = 0;
        c.gridheight = 2;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)panelPortEtRemise, c);
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        this.addSQLObject(textPortHT, "PORT_HT");
        DeviseField fieldDevise = new DeviseField();
        if (this.getTable().getFieldsName().contains("T_DEVISE")) {
            this.addSQLObject(fieldDevise, "T_DEVISE");
        }
        this.addSQLObject(textRemiseHT, "REMISE_HT");
        this.addRequiredSQLObject(fieldHT, "MONTANT_HT");
        this.addRequiredSQLObject(fieldTVA, "MONTANT_TVA");
        this.addRequiredSQLObject(fieldTTC, "MONTANT_TTC");
        this.addRequiredSQLObject(fieldService, "MONTANT_SERVICE");
        JTextField poids = new JTextField();
        if (this.getTable().getFieldsName().contains("T_POIDS")) {
            this.addSQLObject(poids, "T_POIDS");
        }
        final TotalPanel totalTTC = new TotalPanel(this.table.getRowValuesTable(), this.table.getPrixTotalHTElement(), this.table.getPrixTotalTTCElement(), this.table.getHaElement(), this.table.getQteElement(), fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, this.table.getPrixServiceElement(), fieldDevise, this.table.getTableElementTotalDevise(), poids, this.table.getPoidsTotalElement());
        totalTTC.setOpaque(false);
        ++c.gridx;
        c.gridy = 0;
        c.gridheight = 2;
        c.fill = 1;
        panel.add((Component)totalTTC, c);
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        return panel;
    }

    @Override
    public synchronized ValidState getValidState() {
        Date value = this.date.getValue();
        ValidState selfState = value != null && value.after(SocieteCommonSQLElement.getDateDebutExercice()) ? ValidState.getTrueInstance() : ValidState.createCached(false, "La date est incorrecte, cette p\u00e9riode est clotur\u00e9e.");
        return super.getValidState().and(selfState);
    }

    private void setCompteServiceVisible(boolean b) {
        this.compteSelService.setVisible(b);
        this.labelCompteServ.setVisible(b);
    }

    @Override
    public int insert(SQLRow order) {
        int id = this.getSelectedID();
        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
        if (this.textNumero.checkValidation()) {
            id = super.insert(order);
            this.table.updateField("ID_AVOIR_CLIENT", id);
            SQLRow row = this.getTable().getRow(id);
            if (NumerotationAutoSQLElement.getNextNumero(AvoirClientSQLElement.class, row.getDate("DATE").getTime()).equalsIgnoreCase(this.textNumero.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(tableNum);
                int val = tableNum.getRow(2).getInt("AVOIR_START");
                rowVals.put("AVOIR_START", (Object)(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            SQLRowValues rowVals2 = row.createUpdateRow();
            Long l = rowVals2.getLong("MONTANT_SOLDE");
            Long l2 = rowVals2.getLong("MONTANT_TTC");
            rowVals2.put("MONTANT_RESTANT", l2 - l);
            try {
                rowVals2.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.updateStock(id);
            GenerationMvtAvoirClient gen = new GenerationMvtAvoirClient(id);
            gen.genereMouvement();
            this.createAvoirClient(row);
        } else {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro d'avoir existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return id;
    }

    private void createAvoirClient(SQLRow row) {
        AvoirClientXmlSheet bSheet = new AvoirClientXmlSheet(row);
        try {
            bSheet.createDocumentAsynchronous();
            bSheet.showPrintAndExportAsynchronous(this.checkVisu.isSelected(), this.checkImpr.isSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er l'avoir", e);
        }
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r != null) {
            this.textNumero.setIdSelected(r.getID());
        }
        this.comboClient.rmValueListener(this.listenerModeReglDefaut);
        this.comboClient.rmValueListener(this.changeClientListener);
        if (r != null) {
            this.table.insertFrom("ID_AVOIR_CLIENT", r.getID());
            SQLRowValues rVals = r.asRowValues();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        } else {
            super.select(r);
        }
        this.comboClient.addValueListener(this.listenerModeReglDefaut);
        this.comboClient.addValueListener(this.changeClientListener);
    }

    @Override
    public void update() {
        SQLRow row;
        if (this.textNumero.checkValidation()) {
            super.update();
            this.table.updateField("ID_AVOIR_CLIENT", this.getSelectedID());
            row = this.getTable().getRow(this.getSelectedID());
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect(eltMvtStock.getTable().getBase());
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l != null) {
                int i = 0;
                while (i < l.size()) {
                    Object[] tmp = (Object[])l.get(i);
                    try {
                        eltMvtStock.archive(((Number)tmp[0]).intValue());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            SQLRowValues rowVals2 = this.getTable().getRow(this.getSelectedID()).createUpdateRow();
            Long l2 = rowVals2.getLong("MONTANT_SOLDE");
            Long l3 = rowVals2.getLong("MONTANT_TTC");
            rowVals2.put("MONTANT_RESTANT", l3 - l2);
            try {
                rowVals2.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro d'avoir existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        this.updateStock(this.getSelectedID());
        int idMvt = row.getInt("ID_MOUVEMENT");
        System.err.println("Archivage des fils");
        EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
        eltEcr.archiveMouvementProfondeur(idMvt, false);
        GenerationMvtAvoirClient gen = new GenerationMvtAvoirClient(this.getSelectedID(), idMvt);
        gen.genereMouvement();
        this.createAvoirClient(row);
    }

    private void updateStock(int id) {
        SQLElement eltArticleAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT_ELEMENT");
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLRow rowAvoir = this.getTable().getRow(id);
        SQLSelect selEltAvoir = new SQLSelect(eltArticleAvoir.getTable().getBase());
        selEltAvoir.addSelect(eltArticleAvoir.getTable().getField("ID"));
        selEltAvoir.setWhere(new Where((FieldRef)eltArticleAvoir.getTable().getField("ID_AVOIR_CLIENT"), "=", id));
        List lEltAvoir = (List)eltArticleAvoir.getTable().getBase().getDataSource().execute(selEltAvoir.asString(), new ArrayListHandler());
        if (lEltAvoir != null) {
            int i = 0;
            while (i < lEltAvoir.size()) {
                Object[] tmp = (Object[])lEltAvoir.get(i);
                int idEltFact = ((Number)tmp[0]).intValue();
                SQLRow rowEltAvoir = eltArticleAvoir.getTable().getRow(idEltFact);
                SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
                for (SQLField field : eltArticle.getTable().getFields()) {
                    if (!rowEltAvoir.getTable().getFieldsName().contains(field.getName())) continue;
                    rowArticle.put(field.getName(), rowEltAvoir.getObject(field.getName()));
                }
                int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
                SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
                SQLRowValues rowVals = new SQLRowValues(eltMvtStock.getTable());
                rowVals.put("QTE", rowEltAvoir.getInt("QTE"));
                rowVals.put("NOM", "Avoir client N\u00b0" + rowAvoir.getString("NUMERO"));
                rowVals.put("IDSOURCE", id);
                rowVals.put("SOURCE", this.getTable().getName());
                rowVals.put("ID_ARTICLE", idArticle);
                rowVals.put("DATE", rowAvoir.getObject("DATE"));
                try {
                    SQLRow row = rowVals.insert();
                    MouvementStockSQLElement.updateStock(Arrays.asList(row.getID()));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.boxAdeduire && this.eltModeRegl != null) {
            this.eltModeRegl.setEditable(!this.boxAdeduire.isSelected());
            this.eltModeRegl.setCreated(!this.boxAdeduire.isSelected());
        }
    }
}

