/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class PlanComptableGModel
extends AbstractTableModel {
    private Vector titres = new Vector();
    private Vector comptes = new Vector();
    private Map mapCompte = new HashMap();

    public PlanComptableGModel(ClasseCompte classeDuCompte, int typePlan) {
        this(classeDuCompte, typePlan, "COMPTE_PCG");
    }

    protected PlanComptableGModel(ClasseCompte classeDuCompte, String table) {
        this(classeDuCompte, 0, table);
    }

    private PlanComptableGModel(final ClasseCompte classeDuCompte, final int typePlan, final String table) {
        new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                Where w2;
                SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLTable compteTable = base.getTable(table);
                SQLSelect selCompte = new SQLSelect(base);
                selCompte.addSelect(compteTable.getField("ID"));
                selCompte.addSelect(compteTable.getField("NUMERO"));
                selCompte.addSelect(compteTable.getField("NOM"));
                selCompte.addSelect(compteTable.getField("INFOS"));
                String function = "REGEXP";
                String match = classeDuCompte.getTypeNumeroCompte();
                if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
                    function = "~";
                }
                Where w1 = new Where((FieldRef)compteTable.getField("NUMERO"), function, (Object)match);
                if (typePlan == 0) {
                    w2 = null;
                } else if (typePlan == 1) {
                    w2 = new Where((FieldRef)compteTable.getField("ID_TYPE_COMPTE_PCG_BASE"), "!=", 1);
                } else if (typePlan == 2) {
                    w2 = new Where((FieldRef)compteTable.getField("ID_TYPE_COMPTE_PCG_AB"), "!=", 1);
                } else {
                    throw new IllegalArgumentException("Type de PCG inconnu : " + typePlan);
                }
                if (w2 != null) {
                    w1 = w1.and(w2);
                }
                selCompte.setWhere(w1);
                selCompte.addRawOrder("\"" + table + "\".\"NUMERO\"");
                String reqCompte = selCompte.asString();
                Object obCompte = base.getDataSource().execute(reqCompte, new ArrayListHandler());
                List myListCompte = (List)obCompte;
                if (myListCompte != null) {
                    int size = myListCompte.size();
                    int i = 0;
                    while (i < size) {
                        Object[] objTmp = (Object[])myListCompte.get(i);
                        PlanComptableGModel.this.mapCompte.put(new Integer(Integer.parseInt(objTmp[0].toString())), new Integer(PlanComptableGModel.this.comptes.size()));
                        PlanComptableGModel.this.comptes.add(new Compte(Integer.parseInt(objTmp[0].toString()), objTmp[1].toString(), objTmp[2].toString(), objTmp[3].toString()));
                        ++i;
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                PlanComptableGModel.this.fireTableDataChanged();
            }
        }.execute();
        this.titres.add("Compte");
        this.titres.add("Libell\u00e9");
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    @Override
    public int getRowCount() {
        return this.comptes.size();
    }

    @Override
    public int getColumnCount() {
        return this.titres.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.titres.get(col).toString();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ((Compte)this.comptes.get(rowIndex)).getNumero();
        }
        if (columnIndex == 1) {
            return ((Compte)this.comptes.get(rowIndex)).getNom();
        }
        return null;
    }

    public int getId(int row) {
        return ((Compte)this.comptes.get(row)).getId();
    }

    public Vector getComptes() {
        return this.comptes;
    }
}

