/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.erp.core.common.ui.MargeTableCellRenderer;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.ExceptionHandler;

public abstract class AbstractVenteArticleItemTable
extends AbstractArticleItemTable {
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private SQLTable tableArticleTarif = Configuration.getInstance().getBase().getTable("ARTICLE_TARIF");
    private SQLTable tableTarif = Configuration.getInstance().getBase().getTable("TARIF");
    SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");

    public AbstractVenteArticleItemTable() {
    }

    public AbstractVenteArticleItemTable(List<JButton> buttons) {
        super(buttons);
    }

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            SQLTableElement tableElementCodeDouane = new SQLTableElement(e.getTable().getField("CODE_DOUANIER"));
            list.add(tableElementCodeDouane);
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            SQLTableElement tableElementPays = new SQLTableElement(e.getTable().getField("ID_PAYS"));
            list.add(tableElementPays);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            SQLTableElement prebilan = new SQLTableElement(e.getTable().getField("PREBILAN"), Long.class, new DeviseCellEditor());
            prebilan.setRenderer(new DeviseNiceTableCellRenderer());
            list.add(prebilan);
        }
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), Long.class, new DeviseCellEditor());
        tableElement_PrixMetrique1_AchatHT.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), Long.class, new DeviseCellEditor());
            list.add(eltUnitDevise);
        }
        final DeviseCellEditor editorPVHT = new DeviseCellEditor();
        editorPVHT.setConvertToTTCEnable(true);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_VT_1"), Long.class, editorPVHT){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                ArrayList<Integer> l = new ArrayList<Integer>();
                l.add(3);
                l.add(6);
                l.add(2);
                l.add(4);
                l.add(5);
                return new ArticleRowValuesRenderer(l);
            }
        };
        list.add(tableElement_PrixMetrique1_VenteHT);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractVenteArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        this.qte.setPreferredSize(20);
        list.add(this.qte);
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), Long.class, new DeviseCellEditor());
        this.ha.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.ha);
        SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(e.getTable().getField("PV_HT"), Long.class, new DeviseCellEditor());
        tableElement_PrixVente_HT.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(tableElement_PrixVente_HT);
        SQLTableElement tableElement_Taxe = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        tableElement_Taxe.setPreferredSize(20);
        list.add(tableElement_Taxe);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class);
        tableElementPoids.setPreferredSize(20);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class);
        list.add(this.tableElementPoidsTotal);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleService", false)) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), Long.class, new DeviseCellEditor());
        if (e.getTable().getFieldsName().contains("POURCENT_ACOMPTE")) {
            SQLTableElement tableElementAcompte = new SQLTableElement(e.getTable().getField("POURCENT_ACOMPTE"));
            list.add(tableElementAcompte);
            tableElementAcompte.addModificationListener(this.totalHT);
        }
        SQLTableElement tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
        list.add(tableElementRemise);
        SQLTableElement tableElementRG = null;
        if (e.getTable().getFieldsName().contains("POURCENT_RG")) {
            tableElementRG = new SQLTableElement(e.getTable().getField("POURCENT_RG"));
            list.add(tableElementRG);
        }
        SQLTableElement totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), Long.class, new DeviseCellEditor());
        totalHA.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(totalHA);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), Long.class, new DeviseCellEditor());
            this.tableElementTotalDevise.setRenderer(new DeviseNiceTableCellRenderer());
            list.add(this.tableElementTotalDevise);
        }
        if (e.getTable().getFieldsName().contains("MARGE_HT")) {
            SQLTableElement marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), Long.class, new DeviseCellEditor());
            marge.setRenderer(new MargeTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    double lA;
                    Long vt = row.getLong("T_PV_HT");
                    Long ha = row.getLong("T_PA_HT");
                    Object o = row.getObject("POURCENT_ACOMPTE");
                    double d = lA = o == null ? 100.0 : ((BigDecimal)o).doubleValue();
                    if (lA >= 0.0 && lA != 100.0) {
                        ha = Math.round((double)ha.longValue() * (lA / 100.0));
                        vt = Math.round((double)vt.longValue() * (lA / 100.0));
                    }
                    Long r = vt - ha;
                    return r;
                }
            });
        }
        this.totalHT.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), Long.class, new DeviseCellEditor());
        this.tableElementTotalTTC.setRenderer(new DeviseNiceTableCellRenderer());
        list.add(this.tableElementTotalTTC);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"));
        this.table = new RowValuesTable(this.model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        ArrayList<String> completionField = new ArrayList<String>();
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("CODE_DOUANIER");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_PAYS");
        }
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("ID_DEVISE");
        }
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        AutoCompletionManager m = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        for (String string : completionField) {
            m.fill(string, string);
        }
        m.setWhere(new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field);
                if (res == null) {
                    return super.getValueFrom(row, field);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setWhere(new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        this.qte.addModificationListener(this.totalHT);
        this.qte.addModificationListener(totalHA);
        if (tableElementRG != null) {
            tableElementRG.addModificationListener(this.totalHT);
        }
        tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.ha.addModificationListener(totalHA);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                double lremise;
                Object o2 = row.getObject("POURCENT_REMISE");
                double d = lremise = o2 == null ? 0.0 : ((BigDecimal)o2).doubleValue();
                if (row.getTable().getFieldsName().contains("POURCENT_RG")) {
                    Object o3 = row.getObject("POURCENT_RG");
                    lremise += o3 == null ? 0.0 : ((BigDecimal)o3).doubleValue();
                }
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                Number f = (Number)row.getObject("PV_HT");
                long r = f.longValue() * (long)qte;
                if (row.getTable().getFieldsName().contains("POURCENT_ACOMPTE")) {
                    double lA;
                    Object o = row.getObject("POURCENT_ACOMPTE");
                    double d2 = lA = o == null ? 0.0 : ((BigDecimal)o).doubleValue();
                    if (lA >= 0.0 && lA != 100.0) {
                        r = Math.round((double)r * (lA / 100.0));
                    }
                }
                if (lremise > 0.0 && lremise != 100.0) {
                    r = Math.round((double)r * (100.0 - lremise) / 100.0);
                }
                return r;
            }
        });
        totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                Number f = (Number)row.getObject("PA_HT");
                long r = f.longValue() * (long)qte;
                return r;
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            this.qte.addModificationListener(this.tableElementTotalDevise);
            eltUnitDevise.addModificationListener(this.tableElementTotalDevise);
            tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    Object o2 = row.getObject("POURCENT_REMISE");
                    double lremise = o2 == null ? 0.0 : ((BigDecimal)o2).doubleValue();
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    Number f = (Number)row.getObject("PV_U_DEVISE");
                    long r = f.longValue() * (long)qte;
                    if (lremise > 0.0 && lremise != 100.0) {
                        r = Math.round((double)r * (100.0 - lremise) / 100.0);
                    }
                    return r;
                }
            });
        }
        this.totalHT.addModificationListener(this.tableElementTotalTTC);
        tableElement_Taxe.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Number f = (Number)row.getObject("T_PV_HT");
                int idTaux = Integer.parseInt(row.getObject("ID_TAXE").toString());
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    System.err.println("Taxe par d\u00e9faut non valide");
                    Thread.dumpStack();
                    Integer i = TaxeCache.getCache().getFirstTaxe();
                    if (i == null) {
                        ExceptionHandler.handle("Aucune taxe d\u00e9finie!");
                    } else {
                        row.put("ID_TAXE", i);
                        resultTaux = TaxeCache.getCache().getTauxFromId(i);
                    }
                }
                PrixHT pHT = new PrixHT(f.longValue());
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(resultTaux.floatValue());
                Long r = pHT.calculLongTTC(taux / 100.0f);
                return r;
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                Number f = (Number)row.getObject("POIDS");
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                return new Float(f.floatValue() * (float)qte);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row) {
                    if (!row.getForeign("ID_DEVISE").isUndefined()) {
                        BigDecimal t = (BigDecimal)row.getForeign("ID_DEVISE").getObject("TAUX");
                        BigDecimal bigDecimal = new BigDecimal(row.getLong("PV_U_DEVISE"));
                        return t.equals(BigDecimal.ZERO) ? row.getObject("PRIX_METRIQUE_VT_1") : Long.valueOf(bigDecimal.multiply(t).longValue());
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
            });
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return ((Number)row.getObject("PRIX_METRIQUE_VT_1")).longValue();
                }
                long prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                return prixVTFromDetails;
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row) {
                if (row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return ((Number)row.getObject("PRIX_METRIQUE_HA_1")).longValue();
                }
                long prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails;
            }
        });
        this.table.readState();
        this.setColumnVisible(this.model.getColumnForField("T_PA_HT"), true);
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_1"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_2"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("VALEUR_METRIQUE_3"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("PV_HT"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("PA_HT"), modeAvance);
        this.setColumnVisible(this.model.getColumnForField("ID_MODE_VENTE_ARTICLE"), modeAvance);
        boolean showPoids = DefaultNXProps.getInstance().getBooleanValue("ArticleShowPoids", false);
        this.setColumnVisible(this.model.getColumnForField("POIDS"), showPoids);
        this.setColumnVisible(this.model.getColumnForField("T_POIDS"), showPoids);
        this.setColumnVisible(this.model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", false));
        this.setColumnVisible(this.model.getColumnForField("POURCENT_ACOMPTE"), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(this.model.getColumnForField(string), visibilityMap.get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(this.model.getColumnForField(string), mapCustom.get(string));
            }
        }
        this.table.writeState();
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return null;
    }

    private Object tarifCompletion(SQLRowAccessor row, String field) {
        if (this.getTarif() != null && this.getTarif().getID() > this.tableTarif.getUndefinedID()) {
            Collection<? extends SQLRowAccessor> rows = row.getReferentRows(this.tableArticleTarif);
            SQLRowAccessor rowTarif = null;
            for (SQLRowAccessor sQLRowAccessor : rows) {
                if (sQLRowAccessor.getInt("ID_TARIF") != this.getTarif().getID()) continue;
                rowTarif = sQLRowAccessor;
            }
            if (rowTarif == null) {
                if (!this.getTarif().getForeign("ID_DEVISE").isUndefined()) {
                    if (field.equalsIgnoreCase("ID_DEVISE")) {
                        return this.getTarif().getObject("ID_DEVISE");
                    }
                    if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                        BigDecimal bigDecimal = (BigDecimal)this.getTarif().getForeign("ID_DEVISE").getObject("TAUX");
                        return bigDecimal.multiply(new BigDecimal(row.getLong("PRIX_METRIQUE_VT_1"))).longValue();
                    }
                }
                return null;
            }
            if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                if (rowTarif.getInt("ID_DEVISE") == 1) {
                    return rowTarif.getObject(field);
                }
                BigDecimal bigDecimal = (BigDecimal)rowTarif.getForeign("ID_DEVISE").getObject("TAUX");
                return bigDecimal.multiply(new BigDecimal(rowTarif.getLong(field))).longValue();
            }
            if (field.equalsIgnoreCase("ID_DEVISE")) {
                return rowTarif.getObject("ID_DEVISE");
            }
            if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                return rowTarif.getObject("PRIX_METRIQUE_VT_1");
            }
            if (field.equalsIgnoreCase("ID_TAXE") && rowTarif.getInt("ID_TAXE") != 1) {
                return rowTarif.getObject("ID_TAXE");
            }
        }
        return null;
    }

    @Override
    public void setTarif(SQLRowAccessor rowValuesTarif, boolean ask) {
        if (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.getID() != this.getTarif().getID()) {
            super.setTarif(rowValuesTarif, ask);
            if (ask && JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client?") == 0) {
                int nbRows = this.table.getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                    SQLRowValues rowValsArticle = new SQLRowValues(this.tableArticle);
                    for (SQLField field : this.tableArticle.getFields()) {
                        if (!rowVals.getTable().getFieldsName().contains(field.getName())) continue;
                        rowValsArticle.put(field.getName(), rowVals.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowValsArticle, true);
                    SQLRow rowArticle = this.tableArticle.getRow(idArticle);
                    Collection rows = rowArticle.getReferentRows(this.tableArticleTarif);
                    boolean tarifFind = false;
                    if (this.getTarif() != null) {
                        for (SQLRowAccessor rowValsTarif : rows) {
                            if (rowValsTarif.getInt("ID_TARIF") != this.getTarif().getID()) continue;
                            if (rowValsTarif.getForeign("ID_DEVISE").isUndefined()) {
                                if (!rowValsTarif.getForeign("ID_TAXE").isUndefined()) {
                                    this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_TAXE"), i, "ID_TAXE");
                                }
                                this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                            } else {
                                if (!rowValsTarif.getForeign("ID_TAXE").isUndefined()) {
                                    this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_TAXE"), i, "ID_TAXE");
                                }
                                this.getRowValuesTable().getRowValuesTableModel().putValue(rowValsTarif.getObject("ID_DEVISE"), i, "ID_DEVISE");
                                this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowArticle, "PV_U_DEVISE"), i, "PV_U_DEVISE");
                                this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowArticle, "PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                            }
                            tarifFind = true;
                            break;
                        }
                    }
                    if (!tarifFind) {
                        this.getRowValuesTable().getRowValuesTableModel().putValue(rowArticle.getObject("PRIX_METRIQUE_VT_1"), i, "PRIX_METRIQUE_VT_1");
                    }
                    ++i;
                }
            }
        }
    }
}

