/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.convertor.ValueConvertor;

public abstract class ComptaSQLConfElement
extends SQLElement {
    private static DBRoot baseSociete;
    protected static final TableCellRenderer CURRENCY_RENDERER;

    static {
        CURRENCY_RENDERER = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component res = super.getTableCellRendererComponent(table, GestionDevise.currencyToString((BigDecimal)value), isSelected, hasFocus, row, column);
                TableCellRendererUtils.setColors(res, table, isSelected);
                ((JLabel)res).setHorizontalAlignment(4);
                return res;
            }
        };
    }

    private static DBRoot getBaseSociete() {
        if (baseSociete == null) {
            baseSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete();
        }
        return baseSociete;
    }

    public ComptaSQLConfElement(String tableName, String singular, String plural) {
        this(tableName, singular, plural, null);
    }

    public ComptaSQLConfElement(String tableName, String singular, String plural, String id) {
        super(singular, plural, ComptaSQLConfElement.getBaseSociete().findTable(tableName, true), id);
    }

    @Override
    protected String createCode() {
        return this.createCodeFromPackage();
    }

    protected String createCodeFromPackage() {
        String canonicalName = this.getClass().getName();
        if (canonicalName.contains("erp.core") && canonicalName.contains(".element")) {
            int i = canonicalName.indexOf("erp.core") + 9;
            int j = canonicalName.indexOf(".element");
            canonicalName = canonicalName.substring(i, j);
        }
        return canonicalName;
    }

    @Override
    protected void _initTableSource(SQLTableModelSourceOnline res) {
        super._initTableSource(res);
        for (SQLTableModelColumn col : res.getColumns()) {
            if (col.getValueClass() != Long.class && col.getValueClass() != BigInteger.class) continue;
            col.setConverter(new ValueConvertor<Number, BigDecimal>(){

                @Override
                public BigDecimal convert(Number o) {
                    return new BigDecimal(o.longValue()).movePointLeft(2);
                }

                @Override
                public Number unconvert(BigDecimal o) {
                    return o.movePointRight(2);
                }
            }, BigDecimal.class);
            col.setRenderer(CURRENCY_RENDERER);
        }
    }
}

