/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;

public abstract class StructureSource<E extends Exception> {
    private final Set<String> toRefresh;
    private final SQLBase base;
    private boolean preVerify;
    private Map<String, SQLSchema> newStructure;
    private final Map<String, SQLSchema> externalStruct;

    public StructureSource(SQLBase b, Set<String> toRefresh) {
        this(b, toRefresh, null);
    }

    public StructureSource(SQLBase b, Set<String> toRefresh, Map<String, SQLSchema> externalStruct) {
        this.base = b;
        this.toRefresh = toRefresh;
        this.preVerify = false;
        this.newStructure = null;
        this.externalStruct = externalStruct == null ? Collections.emptyMap() : externalStruct;
    }

    public void init() throws PrechangeException {
        try {
            this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, E>(){

                @Override
                public Object handle(SQLDataSource ds) throws Exception {
                    StructureSource.this.getNames(ds.getConnection());
                    return null;
                }
            });
            if (this.preVerify) {
                this.newStructure = this.createTables();
                this.fillTables(this.newStructure.keySet());
            }
        }
        catch (Exception e) {
            throw new PrechangeException(e);
        }
    }

    final Map<String, SQLSchema> getNewStructure() {
        return this.newStructure;
    }

    private final Map<String, SQLSchema> createTables() {
        HashMap<String, SQLSchema> res = new HashMap<String, SQLSchema>();
        Set<String> newSchemas = this.getSchemas();
        for (String schemaName : newSchemas) {
            SQLSchema schema = new SQLSchema(this.getBase(), schemaName);
            res.put(schemaName, schema);
        }
        Set<SQLName> newTableNames = this.getTablesNames();
        for (SQLName tableName : newTableNames) {
            SQLSchema s = (SQLSchema)res.get(tableName.getItemLenient(-2));
            s.addTable(tableName.getName());
        }
        return res;
    }

    protected abstract void getNames(Connection var1) throws E;

    public final SQLBase getBase() {
        return this.base;
    }

    protected final Set<String> getJDBCSchemas(DatabaseMetaData metaData) throws SQLException {
        HashSet<String> res = new HashSet<String>((List)SQLDataSource.COLUMN_LIST_HANDLER.handle(metaData.getSchemas()));
        if (res.isEmpty() && !this.getBase().getServer().getSQLSystem().getLevels().contains(HierarchyLevel.SQLSCHEMA)) {
            res.add(null);
        }
        return res;
    }

    public final void setPreVerify(boolean preVerify) {
        this.preVerify = preVerify;
    }

    public final boolean isInTotalScope(String schemaName) {
        return this.getBase().getDBSystemRoot().createNode(this.getBase(), schemaName) && (this.toRefresh == null || this.toRefresh.contains(schemaName));
    }

    protected final void filterOutOfScope(Collection<String> schemas) {
        Iterator<String> iter = schemas.iterator();
        while (iter.hasNext()) {
            String schema = iter.next();
            if (this.isInTotalScope(schema) && !this.externalStruct.containsKey(schema)) continue;
            iter.remove();
        }
    }

    public final Set<String> getSchemasToRefresh() {
        return CollectionUtils.inter(this.getBase().getChildrenNames(), this.toRefresh);
    }

    public final Set<SQLName> getTablesToRefresh() {
        if (this.toRefresh == null) {
            return this.getBase().getAllTableNames();
        }
        HashSet<SQLName> res = new HashSet<SQLName>();
        for (String schemaName : this.getSchemasToRefresh()) {
            SQLSchema schema = this.getBase().getSchema(schemaName);
            for (SQLTable t : schema.getTables()) {
                res.add(t.getSQLName(schema));
            }
        }
        return res;
    }

    public abstract Set<String> getSchemas();

    public abstract Set<SQLName> getTablesNames();

    public final Set<String> getTotalSchemas() {
        return CollectionUtils.union(this.getSchemas(), this.externalStruct.keySet());
    }

    public final Set<SQLName> getTotalTablesNames() {
        HashSet<SQLName> res = new HashSet<SQLName>(this.getTablesNames());
        for (SQLSchema schema : this.externalStruct.values()) {
            for (SQLTable t : schema.getTables()) {
                res.add(t.getSQLName(schema));
            }
        }
        return res;
    }

    public final void fillTables() throws E {
        if (!this.preVerify) {
            this.fillTables(this.getSchemas());
        } else {
            this.mutateTo(this.newStructure);
        }
        this.mutateTo(this.externalStruct);
    }

    private final void mutateTo(Map<String, SQLSchema> m) {
        for (String schemaName : m.keySet()) {
            SQLSchema s = this.getBase().getSchema(schemaName);
            SQLSchema newSchema = m.get(s.getName());
            s.mutateTo(newSchema);
        }
    }

    protected final SQLSchema getNewSchema(String name) {
        if (!this.preVerify) {
            return this.getBase().getSchema(name);
        }
        return this.newStructure.get(name);
    }

    protected final SQLTable getNewTable(String schemaName, String name) {
        SQLSchema newSchema = this.getNewSchema(schemaName);
        if (newSchema == null) {
            return null;
        }
        return newSchema.getTable(name);
    }

    protected abstract void fillTables(Set<String> var1) throws E;

    public abstract void save();

    public static final class PrechangeException
    extends RuntimeException {
        public PrechangeException(Throwable cause) {
            super(cause);
        }

        public PrechangeException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

