/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.StructureSource;
import org.openconcerto.sql.model.SystemQueryExecutor;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class JDBCStructureSource
extends StructureSource<SQLException> {
    private final Set<String> schemas = new HashSet<String>();
    private final CollectionMap<SQLName, String> tableNames = new CollectionMap(new ArrayList(2));

    public JDBCStructureSource(SQLBase b, Set<String> scope, Map<String, SQLSchema> newStruct) {
        super(b, scope, newStruct);
        this.setPreVerify(false);
    }

    @Override
    protected void getNames(Connection conn) throws SQLException {
        DatabaseMetaData metaData = conn.getMetaData();
        CollectionMap tableNames = new CollectionMap(new ArrayList(2));
        Set<String> schemas = this.getJDBCSchemas(metaData);
        this.filterOutOfScope(schemas);
        for (String s : new HashSet<String>(schemas)) {
            ResultSet rs = metaData.getTables(this.getBase().getMDName(), s, "%", new String[]{"TABLE", "SYSTEM TABLE", "VIEW"});
            while (rs.next()) {
                String tableType = rs.getString("TABLE_TYPE");
                String schemaName = rs.getString("TABLE_SCHEM");
                if (tableType.equals("SYSTEM TABLE")) {
                    schemas.remove(schemaName);
                    continue;
                }
                String tableName = rs.getString("TABLE_NAME");
                tableNames.putAll(new SQLName(schemaName, tableName), Arrays.asList(rs.getString("TABLE_TYPE"), rs.getString("REMARKS")));
            }
        }
        Iterator<SQLName> iter = this.getTablesNames().iterator();
        while (iter.hasNext()) {
            SQLName tableName = iter.next();
            if (schemas.contains(tableName.getItemLenient(-2))) continue;
            iter.remove();
        }
        this.schemas.clear();
        this.schemas.addAll(schemas);
        this.tableNames.clear();
        this.tableNames.putAll((Map)tableNames);
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    public Set<SQLName> getTablesNames() {
        return this.tableNames.keySet();
    }

    @Override
    protected void fillTables(final Set<String> newSchemas) throws SQLException {
        this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                JDBCStructureSource.this._fillTables(newSchemas, ds.getConnection());
                return null;
            }
        });
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void _fillTables(Set<String> newSchemas, Connection conn) throws SQLException {
        block14: {
            metaData = conn.getMetaData();
            for (String s : newSchemas) {
                rs = metaData.getColumns(this.getBase().getMDName(), s, "%", null);
                tablesWithColumns = new HashSet<SQLName>();
                hasNext = rs.next();
                while (hasNext) {
                    schemaName = rs.getString("TABLE_SCHEM");
                    tableName = rs.getString("TABLE_NAME");
                    tablesWithColumns.add(new SQLName(new String[]{schemaName, tableName}));
                    if (newSchemas.contains(schemaName)) {
                        schema = this.getNewSchema(schemaName);
                        moved = schema.refreshTable(metaData, rs);
                    } else {
                        moved = null;
                    }
                    v0 = hasNext = moved == null ? rs.next() : moved.booleanValue();
                }
                schema = this.getNewSchema(s);
                for (Object t : schema.getTableNames()) {
                    if (tablesWithColumns.contains(new SQLName(new String[]{s, t}))) continue;
                    schema.getTable((String)t).emptyFields();
                }
            }
            for (SQLName tName : this.getTablesNames()) {
                t = this.getNewSchema(tName.getItemLenient(-2)).getTable(tName.getName());
                l = (List)this.tableNames.getNonNull(tName);
                t.setType((String)l.get(0));
                t.setComment((String)l.get(1));
            }
            system = this.getBase().getServer().getSQLSystem();
            proceduresBySchema = new CollectionMap<K, V>();
            for (String s : newSchemas) {
                rsProc = metaData.getProcedures(this.getBase().getMDName(), s, "%");
                while (rsProc.next()) {
                    map = BasicRowProcessor.instance().toMap(rsProc);
                    schemaName = (String)map.get("PROCEDURE_SCHEM");
                    if (!newSchemas.contains(schemaName)) continue;
                    procName = (String)map.get("PROCEDURE_NAME");
                    proceduresBySchema.put(schemaName, procName);
                    this.getNewSchema(schemaName).addProcedure(procName);
                }
            }
            if (proceduresBySchema.size() > 0 && (sel = system.getSyntax().getFunctionQuery(this.getBase(), proceduresBySchema.keySet())) != null) {
                for (E o : (List)this.getBase().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false))) {
                    m = (Map)o;
                    newSchema = this.getNewSchema((String)m.get("schema"));
                    if (newSchema == null) continue;
                    newSchema.setProcedureSource((String)m.get("name"), (String)m.get("src"));
                }
            }
            if (newSchemas.size() > 0) {
                tableFinder = new ITransformer<Tuple2<String, String>, SQLTable>(){

                    @Override
                    public SQLTable transformChecked(Tuple2<String, String> input) {
                        return JDBCStructureSource.this.getNewTable(input.get0(), input.get1());
                    }
                };
                new TriggerQueryExecutor(tableFinder).apply(this.getBase(), newSchemas);
                new ColumnsQueryExecutor(tableFinder).apply(this.getBase(), newSchemas);
                try {
                    new ConstraintsExecutor(tableFinder).apply(this.getBase(), newSchemas);
                    break block14;
                }
                catch (SystemQueryExecutor.QueryExn e1) {
                    e1.printStackTrace();
                    ** for (tName : this.getTablesNames())
                }
lbl-1000:
                // 1 sources

                {
                    t = this.getNewSchema(tName.getItemLenient(-2)).getTable(tName.getName());
                    t.addConstraint((Map<String, Object>)null);
                    continue;
                }
            }
        }
    }

    @Override
    public void save() {
        for (String schema : this.getSchemas()) {
            this.getBase().save(schema);
        }
    }

    static final class ColumnsQueryExecutor
    extends SystemQueryExecutor {
        public ColumnsQueryExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected String getQuery(SQLBase b, Set<String> newSchemas, Set<String> arg2) {
            return b.getServer().getSQLSystem().getSyntax().getColumnsQuery(b, newSchemas, arg2);
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.getField((String)m.get("COLUMN_NAME")).setColsFromInfoSchema(m);
        }
    }

    static final class ConstraintsExecutor
    extends SystemQueryExecutor {
        public ConstraintsExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected Object getQuery(SQLBase b, Set<String> newSchemas, Set<String> arg2) {
            try {
                return b.getServer().getSQLSystem().getSyntax().getConstraints(b, newSchemas, arg2);
            }
            catch (Exception e) {
                return e;
            }
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.addConstraint(m);
        }
    }

    static final class TriggerQueryExecutor
    extends SystemQueryExecutor {
        public TriggerQueryExecutor(ITransformer<Tuple2<String, String>, SQLTable> tableFinder) {
            super(tableFinder);
        }

        @Override
        protected Object getQuery(SQLBase b, Set<String> newSchemas, Set<String> arg2) {
            try {
                return b.getServer().getSQLSystem().getSyntax().getTriggerQuery(b, newSchemas, arg2);
            }
            catch (SQLException e) {
                return e;
            }
        }

        @Override
        protected void apply(SQLTable newTable, Map m) {
            newTable.addTrigger(m);
        }
    }
}

