/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLItem;
import org.openconcerto.sql.model.SQLTable;

public class AliasedTable
implements SQLItem {
    private final SQLTable t;
    private final String alias;

    public AliasedTable(SQLTable t, String alias) {
        if (t == null) {
            throw new NullPointerException("f is null");
        }
        this.t = t;
        this.alias = alias == null ? t.getName() : alias;
    }

    public final SQLTable getTable() {
        return this.t;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final AliasedField getField(String fieldName) {
        return new AliasedField(this.getTable().getField(fieldName), this.getAlias());
    }

    public AliasedField getKey() {
        return this.getField(this.getTable().getKey().getName());
    }

    public String getDeclaration() {
        String tableName = this.getTable().getSQLName().quote();
        String qAlias = SQLBase.quoteIdentifier(this.getAlias());
        return String.valueOf(tableName) + (qAlias.equals(tableName) ? "" : " " + qAlias);
    }

    @Override
    public final String getSQL() {
        return this.getDeclaration();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " <" + this.getDeclaration() + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AliasedTable) {
            AliasedTable o = (AliasedTable)obj;
            return this.getAlias().equals(o.getAlias()) && this.getTable().equals(o.getTable());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getAlias().hashCode() + this.getTable().hashCode();
    }
}

