/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;

public class AddFK
extends Changer<DBRoot> {
    public AddFK(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(DBRoot root) throws SQLException {
        this.getStream().print(root + "... ");
        Set<SQLTable> tables = root.getDescs(SQLTable.class);
        if (this.getSystemRoot().getServer().getSQLSystem() == SQLSystem.MYSQL) {
            this.toInno(tables);
        }
        for (SQLTable t : tables) {
            Set<Link> foreignLinks = t.getDBSystemRoot().getGraph().getForeignLinks(t);
            if (foreignLinks.size() <= 0) continue;
            HashSet<List<String>> indexes = new HashSet<List<String>>();
            for (SQLTable.Index i : t.getIndexes()) {
                indexes.add(i.getCols());
            }
            for (Link link : foreignLinks) {
                String s;
                if (link.getName() == null) {
                    s = this.getAddFK(link);
                    System.err.println(s);
                    this.getDS().execute(s);
                } else {
                    System.err.println("pas besoin pour " + link);
                }
                if (!indexes.contains(link.getCols())) {
                    s = this.getSyntax().getCreateIndex("_fki", ((SQLTable)link.getSource()).getSQLName(), link.getCols());
                    System.err.println(s);
                    this.getDS().execute(s);
                    continue;
                }
                System.err.println("pas besoin d'index pour " + link);
            }
        }
    }

    private void toInno(Set<SQLTable> tables) {
        for (SQLTable t : tables) {
            if (this.getDS().execute1("show table status like '" + t.getName() + "'").get("Engine").equals("InnoDB")) continue;
            this.getDS().execute("ALTER TABLE " + t.getName() + " ENGINE = InnoDB;");
        }
    }
}

