/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.InProgressFrame;
import org.openconcerto.erp.core.common.component.SocieteCommonSQLElement;
import org.openconcerto.erp.core.common.element.AdresseCommonSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ExerciceCommonSQLElement;
import org.openconcerto.erp.core.sales.price.element.DeviseSQLElement;
import org.openconcerto.erp.generationDoc.element.TypeModeleSQLElement;
import org.openconcerto.erp.rights.ComptaTotalUserRight;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.DesktopEnvironment;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StringInputStream;

public final class ComptaPropsConfiguration
extends ComptaBasePropsConfiguration {
    public static final ProductInfo productInfo = ProductInfo.getInstance();
    public static final String APP_NAME = productInfo.getName();
    private String version = "";
    private final boolean inWebstart;
    private final boolean isServerless;
    private boolean isOnCloud;

    static File getConfFile() {
        return ComptaPropsConfiguration.getConfFile(APP_NAME);
    }

    public static ComptaPropsConfiguration create(boolean nullAllowed) {
        return ComptaPropsConfiguration.create(nullAllowed, ComptaPropsConfiguration.getConfFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ComptaPropsConfiguration create(boolean nullAllowed, File confFile) {
        block8: {
            System.out.println("Loading configuration from:" + (confFile == null ? "null" : confFile.getAbsolutePath()));
            boolean inWebStart = Gestion.inWebStart();
            Properties defaults = new Properties();
            defaults.setProperty("base.root", "Common");
            try {
                Properties props;
                if (confFile.exists() && !inWebStart) {
                    props = ComptaPropsConfiguration.create(new FileInputStream(confFile), defaults);
                    return new ComptaPropsConfiguration(props, inWebStart);
                }
                InputStream stream = ComptaPropsConfiguration.class.getResourceAsStream("main.properties");
                if (stream != null) {
                    props = ComptaPropsConfiguration.create(stream, defaults);
                    return new ComptaPropsConfiguration(props, inWebStart);
                }
                if (!nullAllowed) break block8;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ExceptionHandler.die("Impossible de lire le fichier de configuration.", e);
                        }
                    });
                    return null;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    return null;
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
                return null;
            }
        }
        throw new IOException("found neither " + confFile + " nor embedded " + "main.properties");
    }

    ComptaPropsConfiguration(Properties props, boolean inWebstart) {
        super(props, productInfo);
        String token;
        this.inWebstart = inWebstart;
        this.setProperty("wd", String.valueOf(DesktopEnvironment.getDE().getDocumentsFolder().getAbsolutePath()) + File.separator + this.getAppName());
        if (this.getProperty("version.date") != null) {
            this.version = this.getProperty("version.date");
        }
        if ((token = this.getProperty("token")) != null) {
            this.isServerless = false;
            this.isOnCloud = true;
            InProgressFrame progress = new InProgressFrame();
            progress.show("Connexion s\u00e9curis\u00e9e au cloud en cours");
            String result = NetUtils.getHTTPContent("https://cloud.openconcerto.org/getAuthInfo?token=" + token, false);
            if (result != null && !result.contains("ERROR")) {
                Properties cProperty = new Properties();
                try {
                    cProperty.loadFromXML(new StringInputStream(result));
                    this.setProperty("server.wan.only", "true");
                    this.setProperty("server.wan.port", "22");
                    this.setProperty("server.wan.addr", cProperty.getProperty("ssh.server"));
                    this.setProperty("server.wan.user", cProperty.getProperty("ssh.login"));
                    this.setProperty("server.wan.password", cProperty.getProperty("ssh.pass"));
                    this.setProperty("server.ip", "127.0.0.1:5432");
                    this.setProperty("server.driver", "postgresql");
                    this.setProperty("server.login", cProperty.getProperty("db.login"));
                    this.setProperty("server.password", cProperty.getProperty("db.pass"));
                    this.setProperty("systemRoot", cProperty.getProperty("db.name"));
                    props.put("storage.server", cProperty.getProperty("storage.server"));
                    progress.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(new JFrame(), "Impossible r\u00e9cup\u00e9rer les informations de connexion");
                    System.exit(1);
                }
            } else if (result != null && result.contains("not paid")) {
                JOptionPane.showMessageDialog(new JFrame(), "Compte Cloud non cr\u00e9dit\u00e9");
                System.exit(1);
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "Connexion impossible au Cloud");
                System.exit(1);
            }
        } else {
            this.setProperty("server.login", "openconcerto");
            this.setProperty("server.password", "openconcerto");
            this.isServerless = this.getProperty("server.ip", "").contains("${data.dir}");
            if (this.isServerless) {
                this.setProperty("server.ip", this.getProperty("server.ip").replace("${data.dir}", this.getDataDir().getPath()));
            }
        }
        this.setupLogging("logs");
        UserRightsManager.getInstance().register(new ComptaTotalUserRight());
    }

    @Override
    public void destroy() {
        this.tearDownLogging(true);
        super.destroy();
    }

    public final boolean isServerless() {
        return this.isServerless;
    }

    @Override
    protected String getAppIDSuffix() {
        if (this.inWebstart()) {
            return String.valueOf(super.getAppIDSuffix()) + "-webstart";
        }
        return super.getAppIDSuffix();
    }

    @Override
    public File getConfDir() {
        return Gestion.MAC_OS_X ? new File(String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/" + this.getAppID()) : super.getConfDir();
    }

    private boolean inWebstart() {
        return this.inWebstart;
    }

    public File getDataDir() {
        return new File(this.getConfDir(), "DBData");
    }

    private final void createDB() {
        block7: {
            if (!this.isServerless()) {
                return;
            }
            SQLServer tmpServer = super.createServer();
            try {
                DBSystemRoot sysRoot = tmpServer.getSystemRoot(this.getSystemRootName());
                if (sysRoot.contains(this.getRootName())) break block7;
                String createScript = null;
                try {
                    createScript = this.getResource("/webstart/create.sql");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (createScript == null) {
                    throw new IllegalStateException("Couldn't find database creation script");
                }
                SQLDataSource ds = sysRoot.getDataSource();
                ds.execute("RUNSCRIPT from '" + createScript + "' ;");
            }
            finally {
                tmpServer.destroy();
            }
        }
    }

    @Override
    protected DBSystemRoot createSystemRoot() {
        this.createDB();
        return super.createSystemRoot();
    }

    @Override
    protected SQLElementDirectory createDirectory() {
        SQLElementDirectory dir = super.createDirectory();
        dir.addSQLElement(new AdresseCommonSQLElement());
        dir.addSQLElement(new ExerciceCommonSQLElement());
        dir.addSQLElement(DeviseSQLElement.class);
        dir.addSQLElement(TypeModeleSQLElement.class);
        dir.addSQLElement(new SocieteCommonSQLElement());
        return dir;
    }

    @Override
    protected DateFormat getLogDateFormat() {
        return new SimpleDateFormat("yyyy-MM/dd_HH-mm EEEE");
    }

    @Override
    protected SQLServer createServer() {
        InProgressFrame progress = new InProgressFrame();
        progress.show("Connexion \u00e0 votre base de donn\u00e9es en cours");
        SQLServer server = super.createServer();
        progress.dispose();
        return server;
    }
}

