/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.h2.Driver;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.JdbcUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;

public class TcpServer
implements Service {
    private static final Map<Integer, TcpServer> SERVERS = Collections.synchronizedMap(new HashMap());
    private int port;
    private boolean trace;
    private boolean ssl;
    private boolean stop;
    private ServerSocket serverSocket;
    private Set<TcpServerThread> running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private boolean allowOthers;
    private boolean isDaemon;
    private boolean ifExists;
    private Connection managementDb;
    private PreparedStatement managementDbAdd;
    private PreparedStatement managementDbRemove;
    private String managementPassword = "";
    private Thread listenerThread;
    private int nextThreadId;
    private String key;
    private String keyDatabase;

    public static String getManagementDbName(int n) {
        return "mem:management_db_" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initManagementDb() throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        properties.setProperty("user", "sa");
        properties.setProperty("password", this.managementPassword);
        this.managementDb = connection = Driver.load().connect("jdbc:h2:" + TcpServer.getManagementDbName(this.port), properties);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.execute("CREATE ALIAS IF NOT EXISTS STOP_SERVER FOR \"" + TcpServer.class.getName() + ".stopServer\"");
            statement.execute("CREATE TABLE IF NOT EXISTS SESSIONS(ID INT PRIMARY KEY, URL VARCHAR, USER VARCHAR, CONNECTED TIMESTAMP)");
            this.managementDbAdd = connection.prepareStatement("INSERT INTO SESSIONS VALUES(?, ?, ?, NOW())");
            this.managementDbRemove = connection.prepareStatement("DELETE FROM SESSIONS WHERE ID=?");
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        SERVERS.put(this.port, this);
    }

    synchronized void addConnection(int n, String string, String string2) {
        try {
            this.managementDbAdd.setInt(1, n);
            this.managementDbAdd.setString(2, string);
            this.managementDbAdd.setString(3, string2);
            this.managementDbAdd.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    synchronized void removeConnection(int n) {
        try {
            this.managementDbRemove.setInt(1, n);
            this.managementDbRemove.execute();
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }

    private synchronized void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException sQLException) {
                TraceSystem.traceThrowable(sQLException);
            }
            this.managementDb = null;
        }
    }

    public void init(String ... stringArray) {
        this.port = 9092;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-trace".equals(string)) {
                this.trace = true;
                continue;
            }
            if ("-tcpSSL".equals(string)) {
                this.ssl = true;
                continue;
            }
            if ("-tcpPort".equals(string)) {
                this.port = Integer.decode(stringArray[++i]);
                continue;
            }
            if ("-tcpPassword".equals(string)) {
                this.managementPassword = stringArray[++i];
                continue;
            }
            if ("-baseDir".equals(string)) {
                this.baseDir = stringArray[++i];
                continue;
            }
            if ("-key".equals(string)) {
                this.key = stringArray[++i];
                this.keyDatabase = stringArray[++i];
                continue;
            }
            if ("-tcpAllowOthers".equals(string)) {
                this.allowOthers = true;
                continue;
            }
            if ("-tcpDaemon".equals(string)) {
                this.isDaemon = true;
                continue;
            }
            if (!"-ifExists".equals(string)) continue;
            this.ifExists = true;
        }
        Driver.load();
    }

    public String getURL() {
        return (this.ssl ? "ssl" : "tcp") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    public int getPort() {
        return this.port;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        try {
            return NetUtils.isLocalAddress(socket);
        }
        catch (UnknownHostException unknownHostException) {
            this.traceError(unknownHostException);
            return false;
        }
    }

    public synchronized void start() throws SQLException {
        this.stop = false;
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        this.port = this.serverSocket.getLocalPort();
        this.initManagementDb();
    }

    public void listen() {
        block3: {
            this.listenerThread = Thread.currentThread();
            String string = this.listenerThread.getName();
            try {
                while (!this.stop) {
                    Socket socket = this.serverSocket.accept();
                    TcpServerThread tcpServerThread = new TcpServerThread(socket, this, this.nextThreadId++);
                    this.running.add(tcpServerThread);
                    Thread thread = new Thread(tcpServerThread);
                    thread.setDaemon(this.isDaemon);
                    thread.setName(string + " thread");
                    tcpServerThread.setThread(thread);
                    thread.start();
                }
                this.serverSocket = NetUtils.closeSilently(this.serverSocket);
            }
            catch (Exception exception) {
                if (this.stop) break block3;
                TraceSystem.traceThrowable(exception);
            }
        }
        this.stopManagementDb();
    }

    public synchronized boolean isRunning(boolean bl) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, this.ssl);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public void stop() {
        SERVERS.remove(this.port);
        if (!this.stop) {
            this.stopManagementDb();
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    TraceSystem.traceThrowable(iOException);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            if (this.listenerThread != null) {
                try {
                    this.listenerThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    TraceSystem.traceThrowable(interruptedException);
                }
            }
        }
        for (TcpServerThread tcpServerThread : New.arrayList(this.running)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.close();
            try {
                tcpServerThread.getThread().join(100L);
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
    }

    void remove(TcpServerThread tcpServerThread) {
        this.running.remove(tcpServerThread);
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    public String getName() {
        return "H2 TCP Server";
    }

    boolean getIfExists() {
        return this.ifExists;
    }

    void cancelStatement(String string, int n) throws SQLException {
        for (TcpServerThread tcpServerThread : New.arrayList(this.running)) {
            if (tcpServerThread == null) continue;
            tcpServerThread.cancelStatement(string, n);
        }
    }

    public String checkKeyAndGetDatabaseName(String string) throws SQLException {
        if (this.key == null) {
            return string;
        }
        if (this.key.equals(string)) {
            return this.keyDatabase;
        }
        throw DbException.get(8004);
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }
}

