/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.utils.cc.IPredicate;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JDOMUtils {
    public static final XMLOutputter OUTPUTTER;
    private static final SAXBuilder BUILDER;

    static {
        Format rawFormat = Format.getRawFormat();
        rawFormat.setLineSeparator("\n");
        OUTPUTTER = new XMLOutputter(rawFormat);
        BUILDER = new SAXBuilder();
        BUILDER.setValidation(false);
    }

    public static Element parseElementString(String xml, Namespace[] namespaces) throws JDOMException {
        return (Element)JDOMUtils.parseString(xml.trim(), namespaces).get(0);
    }

    public static List parseString(String xml, Namespace[] namespaces) throws JDOMException {
        String dummy = "<dummy";
        int i = 0;
        while (i < namespaces.length) {
            Namespace ns = namespaces[i];
            dummy = String.valueOf(dummy) + " xmlns:" + ns.getPrefix() + "=\"" + ns.getURI() + "\"";
            ++i;
        }
        xml = String.valueOf(dummy) + ">" + xml + "</dummy>";
        return JDOMUtils.parseStringDocument(xml).getRootElement().removeContent();
    }

    public static Element parseString(String xml) throws JDOMException {
        return JDOMUtils.parseElementString(xml, new Namespace[0]);
    }

    public static synchronized Document parseStringDocument(String xml) throws JDOMException {
        return JDOMUtils.parseStringDocument(xml, BUILDER);
    }

    public static Document parseStringDocument(String xml, SAXBuilder builder) throws JDOMException {
        Document doc = null;
        try {
            doc = builder.build(new StringReader(xml));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String output(Element xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static String output(Document xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static Element getAncestor(Element element, final String name, final Namespace ns) {
        return JDOMUtils.getAncestor(element, new IPredicate<Element>(){

            @Override
            public boolean evaluateChecked(Element elem) {
                return elem.getName().equals(name) && elem.getNamespace().equals(ns);
            }
        });
    }

    public static Element getAncestor(Element element, IPredicate<Element> pred) {
        Element current = element;
        while (current != null) {
            if (pred.evaluateChecked(current)) {
                return current;
            }
            current = current.getParentElement();
        }
        return null;
    }

    public static void addNamespaces(Element elem, Collection<Namespace> c) {
        if (c instanceof RandomAccess && c instanceof List) {
            List list = (List)c;
            int stop = c.size() - 1;
            int i = 0;
            while (i < stop) {
                Namespace ns = (Namespace)list.get(i);
                if (elem.getNamespace(ns.getPrefix()) == null) {
                    elem.addNamespaceDeclaration(ns);
                }
                ++i;
            }
        } else {
            for (Namespace ns : c) {
                if (elem.getNamespace(ns.getPrefix()) != null) continue;
                elem.addNamespaceDeclaration(ns);
            }
        }
    }

    public static void addNamespaces(Element elem, Namespace ... l) {
        Namespace[] namespaceArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Namespace ns = namespaceArray[n2];
            if (elem.getNamespace(ns.getPrefix()) == null) {
                elem.addNamespaceDeclaration(ns);
            }
            ++n2;
        }
    }

    public Element mkElem(Element current, String path) {
        String[] items = path.split("/");
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            String[] qname = item.split(":");
            Element elem = qname.length == 1 ? new Element(item) : new Element(qname[1], current.getNamespace(qname[0]));
            current.addContent(elem);
            current = elem;
            ++i;
        }
        return current;
    }

    public static void insertAfter(Element insertAfter, Collection<? extends Content> toAdd) {
        JDOMUtils.insertSiblings(insertAfter, toAdd, true);
    }

    public static void insertBefore(Element insertBefore, Collection<? extends Content> toAdd) {
        JDOMUtils.insertSiblings(insertBefore, toAdd, false);
    }

    public static void insertSiblings(Element sibling, Collection<? extends Content> toAdd, boolean after) {
        Element parentElement = sibling.getParentElement();
        int index = parentElement.indexOf(sibling);
        parentElement.addContent(after ? index + 1 : index, toAdd);
    }

    public static boolean equals(Element elem1, Element elem2) {
        if (elem1 == null && elem2 == null) {
            return true;
        }
        if (elem1 == null || elem2 == null) {
            return false;
        }
        return elem1.getName().equals(elem2.getName()) && elem1.getNamespace().equals(elem2.getNamespace());
    }

    static SAXException validate(Document doc, Schema schema, ErrorHandler errorHandler) {
        ByteArrayInputStream ins;
        try {
            ins = new ByteArrayInputStream(JDOMUtils.output(doc).getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("unicode not found ", e);
        }
        Validator validator = schema.newValidator();
        if (errorHandler != null) {
            validator.setErrorHandler(errorHandler);
        }
        try {
            validator.validate(new StreamSource(ins));
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the document", e);
        }
        catch (SAXException e) {
            return e;
        }
    }

    static void validateDTD(Document doc, SAXBuilder b, ErrorHandler errorHandler) throws JDOMException {
        ErrorHandler origEH = b.getErrorHandler();
        boolean origValidation = b.getValidation();
        try {
            b.setErrorHandler(errorHandler);
            b.setValidation(true);
            JDOMUtils.parseStringDocument(JDOMUtils.output(doc), b);
        }
        finally {
            b.setErrorHandler(origEH);
            b.setValidation(origValidation);
        }
    }
}

