/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.List;
import org.openconcerto.utils.CollectionUtils;

public class CollectionChangeEvent
extends PropertyChangeEvent {
    public static CollectionChangeEvent create(Object src, String propName, Collection oldVal, Collection newVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        return new CollectionChangeEvent(src, propName, oldVal, newVal);
    }

    protected CollectionChangeEvent(Object source, String propertyName, Collection oldValue, Collection newValue) {
        super(source, propertyName, oldValue, newValue);
    }

    public Collection getItemsAdded() {
        return org.apache.commons.collections.CollectionUtils.subtract((Collection)this.getNewValue(), (Collection)this.getOldValue());
    }

    public Collection getItemsRemoved() {
        return org.apache.commons.collections.CollectionUtils.subtract((Collection)this.getOldValue(), (Collection)this.getNewValue());
    }

    public Collection getItemsNotChanged() {
        return org.apache.commons.collections.CollectionUtils.intersection((Collection)this.getNewValue(), (Collection)this.getOldValue());
    }

    public boolean isOnlyAddition() {
        return this.getItemsRemoved().size() == 0;
    }

    public boolean isOnlyRemoval() {
        return this.getItemsAdded().size() == 0;
    }

    public List<Integer> getIndexesAdded() {
        if (!this.isOnlyAddition()) {
            throw new IllegalStateException("items were also removed");
        }
        return this.getIndexesChanged();
    }

    public List<Integer> getIndexesRemoved() {
        if (!this.isOnlyRemoval()) {
            throw new IllegalStateException("items were also added");
        }
        return this.getIndexesChanged();
    }

    public List<int[]> getIntervalsAdded() {
        return CollectionUtils.aggregate(this.getIndexesAdded());
    }

    public List<int[]> getIntervalsRemoved() {
        return CollectionUtils.aggregate(this.getIndexesRemoved());
    }

    private List<Integer> getIndexesChanged() {
        if (!(this.getNewValue() instanceof List)) {
            throw new IllegalStateException("the values must be List");
        }
        return CollectionUtils.getIndexesChanged((List)this.getOldValue(), (List)this.getNewValue());
    }
}

