/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.convertor.NumberConvertor;

public class NumberUtils {
    static final int MAX_LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();

    public static final <N extends Number> boolean areEqual(N n1, N n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        Class<?> n1Class = n1.getClass();
        if (n1Class != n2.getClass()) {
            return false;
        }
        if (n1Class == AtomicInteger.class || n1Class == AtomicLong.class) {
            return n1.longValue() == n2.longValue();
        }
        if (n1Class == BigDecimal.class) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2) == 0;
        }
        return n1.equals(n2);
    }

    public static final boolean areNumericallyEqual(Number n1, Number n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        return NumberUtils.compare(n1, n2) == 0;
    }

    public static final int compare(Number n1, Number n2) {
        Class<? extends Number> biggerClass = NumberUtils.getWiderClass(n1, n2);
        if (biggerClass == AtomicInteger.class) {
            biggerClass = Integer.class;
        } else if (biggerClass == AtomicLong.class) {
            biggerClass = Long.class;
        }
        return NumberUtils.compare(n1, n2, biggerClass);
    }

    private static final <N extends Number> int compare(Number n1, Number n2, Class<N> clazz) {
        N n1Converted = NumberConvertor.convertExact(n1, clazz);
        N n2Converted = NumberConvertor.convertExact(n2, clazz);
        Comparable comparable = (Comparable)n1Converted;
        return comparable.compareTo(n2Converted);
    }

    public static final Class<? extends Number> getWiderClass(Number n1, Number n2) {
        boolean n2isFloat;
        Class<?> n2Class;
        Class<?> n1Class = n1.getClass();
        if (n1Class == (n2Class = n2.getClass())) {
            return n1Class;
        }
        if (n1Class == BigDecimal.class || n2Class == BigDecimal.class) {
            return BigDecimal.class;
        }
        boolean n1isFloat = n1Class == Float.class || n1Class == Double.class;
        boolean bl = n2isFloat = n2Class == Float.class || n2Class == Double.class;
        if (n1isFloat && n2isFloat) {
            return Double.class;
        }
        if (n1isFloat || n2isFloat) {
            if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
                return BigDecimal.class;
            }
            return Double.class;
        }
        if (n1Class == BigInteger.class || n2Class == BigInteger.class) {
            return BigInteger.class;
        }
        if (n1Class == Long.class || n2Class == Long.class || n1Class == AtomicLong.class || n2Class == AtomicLong.class) {
            return Long.class;
        }
        if (n1Class == Integer.class || n2Class == Integer.class || n1Class == AtomicInteger.class || n2Class == AtomicInteger.class) {
            return Integer.class;
        }
        if (n1Class == Short.class || n2Class == Short.class) {
            return Short.class;
        }
        if (n1Class == Byte.class || n2Class == Byte.class) {
            return Byte.class;
        }
        throw new IllegalStateException("Unknown classes " + n1Class + " / " + n2Class);
    }

    public static final boolean hasFractionalPart(Number n) {
        if (n instanceof Integer || n instanceof Long || n instanceof Short || n instanceof Byte || n instanceof BigInteger || n instanceof AtomicLong || n instanceof AtomicInteger) {
            return false;
        }
        BigDecimal bd = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof Double || n instanceof Float ? new BigDecimal(n.doubleValue()) : new BigDecimal(n.toString()));
        return DecimalUtils.decimalDigits(bd) > 0;
    }

    public static final int intDigits(long l) {
        long x = Math.abs(l);
        long p = 10L;
        int i = 1;
        while (x >= p && i < MAX_LONG_LENGTH) {
            p *= 10L;
            ++i;
        }
        return i;
    }

    public static final int intDigits(Number n) {
        if (n instanceof Integer || n instanceof Long || n instanceof Short || n instanceof Byte || n instanceof AtomicLong || n instanceof AtomicInteger) {
            return NumberUtils.intDigits(n.longValue());
        }
        BigDecimal bd = n instanceof BigDecimal ? (BigDecimal)n : (n instanceof BigInteger ? new BigDecimal((BigInteger)n) : (n instanceof Double || n instanceof Float ? new BigDecimal(n.doubleValue()) : new BigDecimal(n.toString())));
        return DecimalUtils.intDigits(bd);
    }

    public static Number divide(Number n, double d) {
        if (d == 1.0) {
            return n;
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        if (n instanceof BigInteger) {
            return new BigDecimal((BigInteger)n).divide(new BigDecimal(d), DecimalUtils.HIGH_PRECISION);
        }
        return n.doubleValue() / d;
    }
}

