/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.RecursionType;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ExnTransformer;
import org.openconcerto.utils.cc.IClosure;

public final class FileUtils {
    private static final int CHANNEL_MAX_COUNT = Math.min(67076096, Integer.MAX_VALUE);
    public static final Set<String> VersionControl = CollectionUtils.createSet(".svn", "CVS");
    private static final Map<URL, File> files = new HashMap<URL, File>();
    private static final Map<String, String> ext2mime = new HashMap<String, String>();
    public static final Collection<Character> INVALID_CHARS;
    public static final StringUtils.Escaper FILENAME_ESCAPER;
    public static final FileFilter DIR_FILTER;
    public static final FileFilter REGULAR_FILE_FILTER;

    static {
        ext2mime.put(".xml", "text/xml");
        ext2mime.put(".jpg", "image/jpeg");
        ext2mime.put(".png", "image/png");
        ext2mime.put(".tiff", "image/tiff");
        FILENAME_ESCAPER = new StringUtils.Escaper('\'', 'Q');
        FILENAME_ESCAPER.add('\"', 'D').add(':', 'C').add('/', 'S').add('\\', 'A');
        FILENAME_ESCAPER.add('<', 'L').add('>', 'G').add('*', 'R').add('|', 'P').add('?', 'M');
        INVALID_CHARS = FILENAME_ESCAPER.getEscapedChars();
        DIR_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        };
        REGULAR_FILE_FILTER = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        };
    }

    private FileUtils() {
    }

    public static void browseFile(File f) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.BROWSE)) {
                try {
                    d.browse(f.getCanonicalFile().toURI());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    FileUtils.openNative(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                FileUtils.openNative(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void openFile(File f) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.OPEN)) {
                d.open(f.getCanonicalFile());
            } else {
                FileUtils.openNative(f);
            }
        } else {
            FileUtils.openNative(f);
        }
    }

    public static List<String> listR(File dir) {
        return FileUtils.listR_rec(dir, ".");
    }

    private static List<String> listR_rec(File dir, String prefix) {
        if (!dir.isDirectory()) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        File[] children = dir.listFiles();
        int i = 0;
        while (i < children.length) {
            String newPrefix = String.valueOf(prefix) + "/" + children[i].getName();
            if (children[i].isFile()) {
                res.add(newPrefix);
            } else if (children[i].isDirectory()) {
                res.addAll(FileUtils.listR_rec(children[i], newPrefix));
            }
            ++i;
        }
        return res;
    }

    public static void walk(File dir, IClosure<File> c) {
        FileUtils.walk(dir, c, RecursionType.BREADTH_FIRST);
    }

    public static void walk(File dir, IClosure<File> c, RecursionType type) {
        if (type == RecursionType.BREADTH_FIRST) {
            c.executeChecked(dir);
        }
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.walk(child, c, type);
                ++n2;
            }
        }
        if (type == RecursionType.DEPTH_FIRST) {
            c.executeChecked(dir);
        }
    }

    public static final List<File> list(File root, int depth) {
        return FileUtils.list(root, depth, null);
    }

    public static final List<File> list(File root, int depth, FileFilter ff) {
        if (!root.exists()) {
            return Collections.emptyList();
        }
        if (depth == 0) {
            return ff.accept(root) ? Collections.singletonList(root) : Collections.emptyList();
        }
        if (depth == 1) {
            File[] listFiles = root.listFiles(ff);
            if (listFiles == null) {
                throw new IllegalStateException("cannot list " + root);
            }
            return Arrays.asList(listFiles);
        }
        File[] childDirs = root.listFiles(DIR_FILTER);
        if (childDirs == null) {
            throw new IllegalStateException("cannot list " + root);
        }
        ArrayList<File> res = new ArrayList<File>();
        File[] fileArray = childDirs;
        int n = childDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            res.addAll(FileUtils.list(child, depth - 1, ff));
            ++n2;
        }
        return res;
    }

    public static final String relative(File fromDir, File to) throws IOException {
        if (fromDir.exists() && !fromDir.isDirectory()) {
            throw new IllegalArgumentException(fromDir + " is not a directory");
        }
        File fromF = fromDir.getCanonicalFile();
        File toF = to.getCanonicalFile();
        List<File> toPath = FileUtils.getAncestors(toF);
        List<File> fromPath = FileUtils.getAncestors(fromF);
        if (!toPath.get(0).equals(fromPath.get(0))) {
            return toF.getPath();
        }
        int commonIndex = Math.min(toPath.size(), fromPath.size()) - 1;
        boolean found = false;
        while (commonIndex >= 0 && !found) {
            found = fromPath.get(commonIndex).equals(toPath.get(commonIndex));
            if (found) continue;
            --commonIndex;
        }
        ArrayList<String> complete = new ArrayList<String>(Collections.nCopies(fromPath.size() - 1 - commonIndex, ".."));
        if (complete.isEmpty()) {
            complete.add(".");
        }
        for (File f : toPath.subList(commonIndex + 1, toPath.size())) {
            complete.add(f.getName());
        }
        return CollectionUtils.join(complete, File.separator);
    }

    public static final List<File> getAncestors(File f) {
        ArrayList<File> path = new ArrayList<File>();
        File currentF = f;
        while (currentF != null) {
            path.add(0, currentF);
            currentF = currentF.getParentFile();
        }
        return path;
    }

    public static final File addSuffix(File f, String suffix) {
        return new File(f.getParentFile(), String.valueOf(f.getName()) + suffix);
    }

    public static final File prependSuffix(File f, String toInsert, String suffix) {
        return new File(f.getParentFile(), String.valueOf(FileUtils.removeSuffix(f.getName(), suffix)) + toInsert + suffix);
    }

    public static final String removeSuffix(String name, String suffix) {
        return name.endsWith(suffix) ? name.substring(0, name.length() - suffix.length()) : name;
    }

    public static final File[] mvOut(File parent, String name, String suffix) {
        File renamed;
        File fDest = new File(parent, String.valueOf(name) + suffix);
        if (fDest.exists()) {
            int i = 0;
            File free = fDest;
            while (free.exists()) {
                free = new File(parent, String.valueOf(name) + "_" + i + suffix);
                ++i;
            }
            assert (!fDest.equals(free));
            if (!fDest.renameTo(free)) {
                throw new IllegalStateException("Couldn't rename " + fDest + " to " + free);
            }
            renamed = free;
        } else {
            renamed = null;
        }
        assert (!fDest.exists());
        return new File[]{fDest, renamed};
    }

    public static String mv(File f, File dest) {
        File canonDest;
        File canonF;
        try {
            canonF = f.getCanonicalFile();
            canonDest = dest.getCanonicalFile();
        }
        catch (IOException e) {
            return ExceptionUtils.getStackTrace(e);
        }
        if (canonF.equals(canonDest)) {
            return null;
        }
        if (canonDest.isDirectory()) {
            canonDest = new File(canonDest, canonF.getName());
        }
        if (canonDest.exists()) {
            return canonDest + " exists";
        }
        if (!canonDest.getParentFile().exists()) {
            return "parent of " + canonDest + " does not exist";
        }
        File destF = canonDest;
        if (!canonF.renameTo(destF)) {
            try {
                FileUtils.copyDirectory(canonF, destF);
                if (destF.exists()) {
                    FileUtils.rmR(canonF);
                }
            }
            catch (IOException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }
        return null;
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtils.copyFile(in, out, CHANNEL_MAX_COUNT);
    }

    public static void copyFile(File in, File out, long maxCount) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        if (maxCount == 0L) {
            maxCount = sourceChannel.size();
        }
        try {
            long size = sourceChannel.size();
            long position = 0L;
            while (position < size) {
                position += sourceChannel.transferTo(position, maxCount, destinationChannel);
            }
        }
        finally {
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    public static void copyFile(File in, File out, boolean useTime) throws IOException {
        if (!useTime || in.lastModified() != out.lastModified()) {
            FileUtils.copyFile(in, out);
            if (useTime) {
                out.setLastModified(in.lastModified());
            }
        }
    }

    public static void copyDirectory(File in, File out) throws IOException {
        FileUtils.copyDirectory(in, out, Collections.<String>emptySet());
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore) throws IOException {
        FileUtils.copyDirectory(in, out, toIgnore, false);
    }

    public static void copyDirectory(File in, File out, Set<String> toIgnore, boolean useTime) throws IOException {
        if (toIgnore.contains(in.getName())) {
            return;
        }
        if (in.isDirectory()) {
            if (!out.exists()) {
                out.mkdir();
            }
            String[] children = in.list();
            int i = 0;
            while (i < children.length) {
                FileUtils.copyDirectory(new File(in, children[i]), new File(out, children[i]), toIgnore, useTime);
                ++i;
            }
        } else if (!in.getName().equals("Thumbs.db")) {
            FileUtils.copyFile(in, out, useTime);
        }
    }

    public static boolean rmR(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtils.rmR(children[i]);
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static void rm_R(File dir) throws IOException {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                FileUtils.rmR(child);
                ++n2;
            }
        }
        FileUtils.rm(dir);
    }

    public static void rm(File f) throws IOException {
        if (f.exists() && !f.delete()) {
            throw new IOException("cannot delete " + f);
        }
    }

    public static final File mkdir_p(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("cannot create directory " + dir);
        }
        return dir;
    }

    public static final File mkParentDirs(File f) throws IOException {
        File parentFile = f.getParentFile();
        if (parentFile != null) {
            FileUtils.mkdir_p(parentFile);
        }
        return f;
    }

    public static final String read(File f) throws IOException {
        return FileUtils.read(f, null);
    }

    public static final String read(File f, String charset) throws IOException {
        return FileUtils.read(new FileInputStream(f), charset);
    }

    public static final String read(InputStream ins, String charset) throws IOException {
        InputStreamReader reader = charset == null ? new InputStreamReader(ins) : new InputStreamReader(ins, charset);
        return FileUtils.read(reader);
    }

    public static final String read(Reader reader) throws IOException {
        return FileUtils.read(reader, 8192);
    }

    public static final String read(Reader reader, int bufferSize) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[bufferSize];
        BufferedReader in = new BufferedReader(reader);
        try {
            int count;
            while ((count = in.read(buffer)) != -1) {
                sb.append(buffer, 0, count);
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    public static final byte[] readBytes(File f) throws IOException {
        FileInputStream in = new FileInputStream(f);
        if (f.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("file longer than Integer.MAX_VALUE" + f.length());
        }
        byte[] res = new byte[(int)f.length()];
        ((InputStream)in).read(res);
        ((InputStream)in).close();
        return res;
    }

    public static void write(String s, File f) throws IOException {
        FileUtils.write(s, f, null, false);
    }

    public static void write(String s, File f, String charset, boolean append) throws IOException {
        FileOutputStream fileStream = new FileOutputStream(f, append);
        OutputStreamWriter out = charset == null ? new OutputStreamWriter(fileStream) : new OutputStreamWriter((OutputStream)fileStream, charset);
        BufferedWriter w = new BufferedWriter(out);
        try {
            w.write(s);
        }
        finally {
            w.close();
        }
    }

    public static final <T> T doWithLock(File f, ExnTransformer<RandomAccessFile, T, ?> transf) throws Exception {
        RandomAccessFile out = null;
        try {
            FileUtils.mkParentDirs(f);
            out = new RandomAccessFile(f, "rw");
            out.getChannel().lock();
            T res = transf.transformChecked(out);
            out.close();
            out = null;
            return res;
        }
        catch (Exception e) {
            Exception toThrow = e;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e2) {
                    toThrow = ExceptionUtils.createExn(IOException.class, "couldn't close: " + e2.getMessage(), e);
                }
            }
            throw toThrow;
        }
    }

    private static final File getShortCutFile() throws IOException {
        return FileUtils.getFile(FileUtils.class.getResource("shortcut.vbs"));
    }

    public static final File getFile(URL url) throws IOException {
        File shortcutFile;
        File currentFile = files.get(url);
        if (currentFile == null || !currentFile.exists()) {
            shortcutFile = File.createTempFile("windowsIsLame", ".vbs");
            shortcutFile.deleteOnExit();
            files.put(url, shortcutFile);
            InputStream stream = url.openStream();
            FileOutputStream out = new FileOutputStream(shortcutFile);
            try {
                StreamUtils.copy(stream, out);
            }
            finally {
                out.close();
                stream.close();
            }
        } else {
            shortcutFile = currentFile;
        }
        return shortcutFile;
    }

    public static final File ln(File target, File link) throws IOException {
        File res;
        Process ps;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            ps = Runtime.getRuntime().exec(new String[]{"cscript", FileUtils.getShortCutFile().getAbsolutePath(), link.getAbsolutePath(), target.getCanonicalPath()});
            res = new File(link.getParentFile(), String.valueOf(link.getName()) + ".LNK");
        } else {
            String rel = FileUtils.relative(link.getAbsoluteFile().getParentFile(), target);
            String[] cmdarray = new String[]{"ln", "-sfn", rel, link.getAbsolutePath()};
            ps = Runtime.getRuntime().exec(cmdarray);
            res = link;
        }
        try {
            int exitValue = ps.waitFor();
            if (exitValue == 0) {
                return res;
            }
            throw new IOException("Abnormal exit value: " + exitValue);
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted", e);
        }
    }

    public static final File readlink(File link) throws IOException {
        String res;
        block3: {
            String os = System.getProperty("os.name");
            Process ps = os.startsWith("Windows") ? Runtime.getRuntime().exec(new String[]{"cscript", "//NoLogo", FileUtils.getShortCutFile().getAbsolutePath(), link.getAbsolutePath()}) : Runtime.getRuntime().exec(new String[]{"readlink", "-f", link.getAbsolutePath()});
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(ps.getInputStream()));
                res = reader.readLine();
                reader.close();
                if (ps.waitFor() == 0 && res != null && res.length() != 0) break block3;
                return null;
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.createExn(IOException.class, "interrupted", e);
            }
        }
        return new File(res);
    }

    /*
     * Unable to fully structure code
     */
    public static final void open(File f, String[] executables) throws IOException {
        block5: {
            try {
                FileUtils.openNative(f);
                break block5;
            }
            catch (IOException exn) {
                i = 0;
                ** while (i < executables.length)
            }
lbl-1000:
            // 1 sources

            {
                executable = executables[i];
                try {
                    Runtime.getRuntime().exec(new String[]{executable, f.getCanonicalPath()});
                    return;
                }
                catch (IOException var5_5) {
                    ++i;
                }
                continue;
            }
lbl15:
            // 1 sources

            throw ExceptionUtils.createExn(IOException.class, "unable to open " + f + " with: " + Arrays.asList(executables), exn);
        }
    }

    private static final void openNative(File f) throws IOException {
        String[] cmdarray;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            cmdarray = new String[]{"cmd", "/c", "start", "\"\"", f.getCanonicalPath()};
        } else if (os.startsWith("Mac OS")) {
            cmdarray = new String[]{"open", f.getCanonicalPath()};
        } else if (os.startsWith("Linux")) {
            cmdarray = new String[]{"xdg-open", f.getCanonicalPath()};
        } else {
            throw new IOException("unknown way to open " + f);
        }
        try {
            int res = Runtime.getRuntime().exec(cmdarray).waitFor();
            if (res != 0) {
                throw new IOException("error (" + res + ") executing " + Arrays.asList(cmdarray));
            }
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.createExn(IOException.class, "interrupted waiting for " + Arrays.asList(cmdarray), e);
        }
    }

    static final boolean gnomeRunning() {
        try {
            return Runtime.getRuntime().exec(new String[]{"pgrep", "-u", System.getProperty("user.name"), "nautilus"}).waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final String findMimeType(String fname) {
        for (Map.Entry<String, String> e : ext2mime.entrySet()) {
            if (!fname.toLowerCase().endsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public static final FileFilter createEndFileFilter(final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() && f.getName().endsWith(ext);
            }
        };
    }
}

