/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.StringUtils;

public abstract class DesktopEnvironment {
    private static DesktopEnvironment DE = null;
    private String version = null;

    public static final boolean test(String ... command) throws RTInterruptedException {
        try {
            return Runtime.getRuntime().exec(command).waitFor() == 0;
        }
        catch (InterruptedException e) {
            throw new RTInterruptedException(e);
        }
        catch (IOException e) {
            Log.get().finer(e.getLocalizedMessage());
            return false;
        }
    }

    public static final String cmdSubstitution(Process p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(102400);
        StreamUtils.copy(p.getInputStream(), out);
        return out.toString();
    }

    private static final DesktopEnvironment detectDE() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return new Windows();
        }
        if (os.startsWith("Mac OS")) {
            return new Mac();
        }
        if (os.startsWith("Linux")) {
            if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
                return new KDE();
            }
            if (System.getenv("GNOME_DESKTOP_SESSION_ID") != null) {
                return new Gnome();
            }
            if (DesktopEnvironment.test("dbus-send", "--print-reply", "--dest=org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus.GetNameOwner", "string:org.gnome.SessionManager")) {
                return new Gnome();
            }
            try {
                String saveMode = DesktopEnvironment.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"xprop", "-root", "_DT_SAVE_MODE"}));
                if (saveMode.endsWith(" = \"xfce4\"")) {
                    return new XFCE();
                }
            }
            catch (IOException e) {
                Log.get().fine(e.getLocalizedMessage());
            }
        }
        return new Unknown();
    }

    public static final DesktopEnvironment getDE() {
        if (DE == null) {
            DE = DesktopEnvironment.detectDE();
        }
        return DE;
    }

    public static final void resetDE() {
        DE = null;
    }

    private DesktopEnvironment() {
    }

    protected abstract String findVersion();

    public final String getVersion() {
        if (this.version == null) {
            this.version = this.findVersion();
        }
        return this.version;
    }

    public File getDocumentsFolder() {
        return FileSystemView.getFileSystemView().getDefaultDirectory();
    }

    public File getPreferencesFolder(String appName) {
        return new File(System.getProperty("user.home"), "." + appName);
    }

    public String quoteParamForExec(String s) {
        return s;
    }

    public String toString() {
        return "DesktopEnvironment " + this.getClass().getSimpleName();
    }

    public static void main(String[] args) {
        System.out.println(DesktopEnvironment.getDE() + " version " + DesktopEnvironment.getDE().getVersion());
    }

    /* synthetic */ DesktopEnvironment(DesktopEnvironment desktopEnvironment) {
        this();
    }

    private static class DEisOS
    extends DesktopEnvironment {
        private DEisOS() {
            super(null);
        }

        @Override
        protected String findVersion() {
            return System.getProperty("os.version");
        }
    }

    public static final class Gnome
    extends DesktopEnvironment {
        public Gnome() {
            super(null);
        }

        @Override
        protected String findVersion() {
            try {
                String line = Gnome.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"gnome-about", "--version"}));
                String[] words = line.split(" ");
                return words[words.length - 1];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class KDE
    extends DesktopEnvironment {
        private static final Pattern versionPattern = Pattern.compile("^KDE: (.*)$", 8);

        public KDE() {
            super(null);
        }

        @Override
        protected String findVersion() {
            try {
                String line = KDE.cmdSubstitution(Runtime.getRuntime().exec(new String[]{"kde-config", "--version"}));
                Matcher matcher = versionPattern.matcher(line);
                matcher.find();
                return matcher.group(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static final class Mac
    extends DEisOS {
        private static final String kDocumentsDirectory = "docs";
        private static final String kPreferencesDirectory = "pref";
        private static Class<?> FileManagerClass;
        private static Short kUserDomain;
        private static Method OSTypeToInt;

        private static Class<?> getFileManagerClass() {
            if (FileManagerClass == null) {
                try {
                    FileManagerClass = Class.forName("com.apple.eio.FileManager");
                    OSTypeToInt = FileManagerClass.getMethod("OSTypeToInt", String.class);
                    kUserDomain = (Short)FileManagerClass.getField("kUserDomain").get(null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return FileManagerClass;
        }

        @Override
        public File getDocumentsFolder() {
            return this.getFolder(kDocumentsDirectory);
        }

        @Override
        public File getPreferencesFolder(String appName) {
            return new File(this.getFolder(kPreferencesDirectory), appName);
        }

        public File getFolder(String type) {
            try {
                Method findFolder = Mac.getFileManagerClass().getMethod("findFolder", Short.TYPE, Integer.TYPE);
                String path = (String)findFolder.invoke(null, kUserDomain, OSTypeToInt.invoke(null, type));
                return new File(path);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static final class Unknown
    extends DesktopEnvironment {
        public Unknown() {
            super(null);
        }

        @Override
        protected String findVersion() {
            return "";
        }
    }

    public static final class Windows
    extends DEisOS {
        private static boolean needsQuoting(String s) {
            int len = s.length();
            if (len == 0) {
                return true;
            }
            int i = 0;
            while (i < len) {
                switch (s.charAt(i)) {
                    case '\t': 
                    case ' ': 
                    case '\"': 
                    case '\\': {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        @Override
        public String quoteParamForExec(String s) {
            if (!Windows.needsQuoting(s)) {
                return s;
            }
            return StringUtils.doubleQuote(s);
        }
    }

    public static final class XFCE
    extends DesktopEnvironment {
        public XFCE() {
            super(null);
        }

        @Override
        protected String findVersion() {
            return "";
        }
    }
}

