/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class TimestampTableCellRenderer
implements TableCellRenderer {
    Vector<TimeProp> cache = new Vector();
    private static final DateFormat formatterFull = DateFormat.getDateTimeInstance();
    private static final DateFormat formatterDate = new SimpleDateFormat("dd MMM yyyy");
    private Calendar calendar;
    private boolean highlight;
    private boolean showHour;
    private Calendar currentCalendar;
    private Date currentDate;
    private static SimpleDateFormat sf = new SimpleDateFormat("HH:mm");
    private int currentYear;
    private String currentYearS;
    private int currentDayOfYear;
    static final int WIDTH = 60;
    private JLabel jLabel = new JLabel("timestamp");

    public TimestampTableCellRenderer() {
        this(false);
    }

    public TimestampTableCellRenderer(boolean highlight) {
        this(highlight, true);
    }

    public TimestampTableCellRenderer(boolean highlight, boolean showHour) {
        this.jLabel.setOpaque(true);
        this.jLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.jLabel.setHorizontalAlignment(2);
        this.highlight = highlight;
        this.showHour = showHour;
        this.calendar = Calendar.getInstance();
        this.currentCalendar = Calendar.getInstance();
        this.currentCalendar.setTimeInMillis(System.currentTimeMillis());
        this.currentDate = new Date(System.currentTimeMillis());
        this.currentYear = this.currentCalendar.get(1);
        this.currentYearS = String.valueOf(this.currentYear);
        this.currentDayOfYear = this.currentCalendar.get(6);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRendererUtils.setColors(this.jLabel, table, isSelected);
        if (value == null) {
            this.jLabel.setText("");
            return this.jLabel;
        }
        if (row >= this.cache.size()) {
            this.cache.setSize(row + 1);
        }
        TimeProp p = this.cache.get(row);
        Date time = (Date)value;
        this.calendar.setTime(time);
        p = new TimeProp(time.getTime());
        this.cache.set(row, p);
        String str = this.showHour ? formatterFull.format(time) : formatterDate.format(time);
        str = str.replaceAll(this.currentYearS, "");
        if (this.currentDayOfYear == this.calendar.get(6) && this.currentYear == this.calendar.get(1)) {
            str = this.showHour ? "aujourd'hui \u00e0 " + sf.format(time) : "aujourd'hui";
        } else if (this.showHour) {
            str = str.substring(0, str.length() - 3);
        }
        p.label = str;
        if (this.highlight) {
            if (time.before(this.currentDate)) {
                p.fg = Color.RED.darker();
            }
            if ((this.currentDayOfYear == this.calendar.get(6) || this.currentDayOfYear + 1 == this.calendar.get(6)) && this.currentYear == this.calendar.get(1)) {
                p.fg = Color.ORANGE.darker();
            }
        }
        if (!isSelected) {
            this.jLabel.setForeground(p.fg);
        }
        this.jLabel.setText(p.label);
        return this.jLabel;
    }

    public static void install(JTable jtable, int column) {
        jtable.setAutoCreateColumnsFromModel(false);
        TimestampTableCellRenderer renderer = new TimestampTableCellRenderer();
        TableColumnModel tcm = jtable.getColumnModel();
        TableColumn tc = tcm.getColumn(column);
        tc.setCellRenderer(renderer);
        tc.setPreferredWidth(60);
        tc.setMinWidth(60);
        tc.setMaxWidth(60);
    }

    private class TimeProp {
        long t;
        String label;
        Color bg;
        Color fg;

        public TimeProp(long time) {
            this.t = time;
        }
    }
}

