/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import javax.swing.tree.DefaultMutableTreeNode;
import org.openconcerto.ui.preferences.PreferencePanel;
import org.openconcerto.utils.ExceptionHandler;

public class PrefTreeNode
extends DefaultMutableTreeNode {
    private Class<? extends PreferencePanel> c;
    private String name;
    private String[] keywords;
    private boolean match = true;
    private boolean bold = false;

    public PrefTreeNode(Class<? extends PreferencePanel> c, String name, String[] keywords) {
        this(c, name, keywords, false);
    }

    public PrefTreeNode(Class<? extends PreferencePanel> c, String name, String[] keywords, boolean bold) {
        this.name = name;
        this.keywords = keywords;
        this.bold = bold;
        this.c = c;
    }

    public PreferencePanel createPanel() {
        try {
            return this.c.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le panneau de pr\u00e9f\u00e9rence", e);
            return null;
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean match(String[] in) {
        int i = 0;
        while (i < in.length) {
            String inValue = in[i].toLowerCase();
            int j = 0;
            while (j < this.keywords.length) {
                String key = this.keywords[j].toLowerCase();
                if (key.indexOf(inValue) >= 0) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    boolean isMatching() {
        return this.match;
    }

    void setMatch(boolean match) {
        this.match = match;
    }
}

