/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.MutableListCombo;
import org.openconcerto.ui.component.MutableListComboPopupListener;
import org.openconcerto.ui.component.combo.ComboUtils;
import org.openconcerto.ui.component.combo.ISearchableComboCompletionThread;
import org.openconcerto.ui.component.combo.ISearchableComboItem;
import org.openconcerto.ui.component.combo.ISearchableComboPopup;
import org.openconcerto.ui.component.combo.ISearchableTextCombo;
import org.openconcerto.ui.component.combo.Log;
import org.openconcerto.ui.component.combo.SearchMode;
import org.openconcerto.ui.component.combo.ToStringVarDesc;
import org.openconcerto.ui.component.combo.VarDesc;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.IListModel;
import org.openconcerto.utils.model.IMutableListModel;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.model.Reloadable;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ISearchableCombo<T>
extends JPanel
implements ValueWrapper<T>,
DocumentComponent,
TextComponent {
    public static final SearchMode MODE_STARTWITH = new SearchMode.DefaultSearchMode(false);
    public static final SearchMode MODE_CONTAINS = new SearchMode.DefaultSearchMode(true);
    protected static final int LABEL_GAP = 2;
    protected static final int BTN_GAP = 3;
    private SearchMode modeCompletion = MODE_CONTAINS;
    private ISearchableComboCompletionThread<T> completionThread;
    protected final ISearchableComboPopup<T> popupCompletion;
    private final DefaultIMutableListModel<ISearchableComboItem<T>> model;
    private final ListComboBoxModel listModel;
    private final ISearchableComboItem<T> emptyItem;
    private boolean includeEmpty;
    private final ComboLockedMode locked;
    private boolean searchable;
    private final ValueChangeSupport<T> supp;
    private final List<Action> actions;
    private IListModel<T> cache;
    private JTextComponent text;
    private boolean forceDisplayStart;
    private Insets textMargin;
    private final JLabel label;
    private final JLabel btn;
    private final MouseMotionListener dragL;
    private final MouseListener clickL;
    private static Image imageSelectorEnabled;
    private static Image imageSelectorDisabled;
    private int minimumSearch = 1;
    private int maximumResult = 300;
    private final Map<T, ISearchableComboItem<T>> itemsByOriginalItem;
    protected boolean updating = false;
    private ValidState parsedValidState = ValidState.getTrueInstance();
    private ValidState validState = ValidState.createCached(false, "Not initialised");
    private ITransformer<T, VarDesc> varDescTransf = null;
    private ITransformer<T, Icon> iconTransf = null;
    private boolean trace = false;

    public ISearchableCombo() {
        this(ComboLockedMode.UNLOCKED);
    }

    public ISearchableCombo(boolean locked) {
        this(locked ? ComboLockedMode.LOCKED : ComboLockedMode.ITEMS_LOCKED);
    }

    protected ISearchableCombo(ComboLockedMode mode) {
        this(mode, 0, 0);
    }

    public ISearchableCombo(ComboLockedMode mode, int rows, int columns) {
        this(mode, rows, columns, false);
    }

    public ISearchableCombo(ComboLockedMode mode, boolean textArea) {
        this(mode, 0, 0, textArea);
    }

    public ISearchableCombo(ComboLockedMode mode, int rows, int columns, boolean textArea) {
        this.supp = new ValueChangeSupport(this);
        this.locked = mode;
        this.actions = new ArrayList<Action>();
        this.cache = null;
        this.itemsByOriginalItem = new HashMap<T, ISearchableComboItem<T>>();
        this.model = new DefaultIMutableListModel();
        this.getModel().setSelectOnAdd(false);
        this.getModel().setSelectOnRm(false);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() == -1 && e.getIndex0() == e.getIndex1()) {
                    ISearchableCombo.this.selectionChanged();
                } else {
                    this.updateValidState();
                }
            }

            private void updateValidState() {
                if (ISearchableCombo.this.getMode().valueMustBeInList()) {
                    ISearchableCombo.this.updateValidState();
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.updateValidState();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.updateValidState();
            }
        });
        this.emptyItem = new ISearchableComboItem<Object>(null, new ToStringVarDesc("effacer"));
        this.setIncludeEmpty(this.isLocked());
        this.listModel = new ListComboBoxModel();
        this.popupCompletion = new ISearchableComboPopup(this.listModel, this);
        this.popupCompletion.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ComboUtils.doNotCancelPopupHack(ISearchableCombo.this.getTextComp());
                ComboUtils.doNotCancelPopupHack(ISearchableCombo.this.getBtn());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboUtils.cancelPopupHack(ISearchableCombo.this.getTextComp());
                ComboUtils.cancelPopupHack(ISearchableCombo.this.getBtn());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ISearchableCombo.this.popupCompletion.setMinWith(ISearchableCombo.this.getBounds().width);
            }
        });
        this.dragL = new MouseMotionListener(){
            private Point last = null;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (e.getPoint().equals(this.last)) {
                    return;
                }
                this.last = e.getPoint();
                Point converted = e.getPoint();
                converted.translate(0, -ISearchableCombo.this.getHeight());
                ISearchableCombo.this.popupCompletion.updateListBoxSelection(converted);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
        this.clickL = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() != 1) {
                    return;
                }
                if (this.isClickTarget(e)) {
                    ISearchableCombo.this.getTextComp().requestFocusInWindow();
                    boolean showing = ISearchableCombo.this.popupCompletion.isShowing();
                    if (showing) {
                        ISearchableCombo.this.hideCompletionPopup();
                    } else {
                        ISearchableCombo.this.updateAutoCompletion(true);
                    }
                }
            }

            private boolean isClickTarget(MouseEvent e) {
                boolean isTextClickable;
                JComponent src = (JComponent)e.getSource();
                boolean buttonClicked = src.isEnabled() && src.contains(e.getPoint());
                boolean bl = isTextClickable = !(src instanceof JTextComponent) || !((JTextComponent)src).isEditable();
                return buttonClicked && isTextClickable;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ISearchableCombo.this.popupCompletion.isShowing() && !this.isClickTarget(e)) {
                    ISearchableCombo.this.popupCompletion.validateSelection();
                }
            }
        };
        this.completionThread = null;
        ISearchableCombo.initImages();
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.label = new JLabel();
        this.btn = new JLabel(new ImageIcon(imageSelectorEnabled));
        this.btn.setDisabledIcon(new ImageIcon(imageSelectorDisabled));
        this.btn.setSize(this.getBtn().getPreferredSize());
        this.btn.setFocusable(false);
        this.btn.addMouseMotionListener(this.dragL);
        this.btn.addMouseListener(this.clickL);
        this.forceDisplayStart = false;
        this.setTextEditor(rows, columns, textArea);
        this.getLabel().setOpaque(false);
        this.getBtn().setOpaque(false);
        this.setOpaque(false);
        this.setEnabled(true);
        this.setSearchable(true);
    }

    private static void initImages() {
        if (imageSelectorEnabled != null) {
            return;
        }
        Image ic = new ImageIcon(ISearchableCombo.class.getResource("yellowDownArrow.png")).getImage();
        int w = ic.getWidth(null);
        int h = ic.getHeight(null);
        imageSelectorEnabled = new BufferedImage(w, h, 2);
        Graphics g = imageSelectorEnabled.getGraphics();
        g.setColor(new Color(255, 255, 255, 0));
        g.fillRect(0, 0, w, h);
        g.drawImage(ic, 0, 0, null);
        imageSelectorDisabled = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)imageSelectorDisabled.getGraphics();
        g2d.setBackground(new Color(255, 255, 255, 0));
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp op = new ColorConvertOp(cs, g2d.getRenderingHints());
        op.filter((BufferedImage)imageSelectorEnabled, (BufferedImage)imageSelectorDisabled);
    }

    private void log(String s) {
        if (this.trace) {
            Log.get().info(s);
        }
    }

    public final void setDebug(boolean trace) {
        this.trace = trace;
    }

    private DefaultIMutableListModel<ISearchableComboItem<T>> getModel() {
        return this.model;
    }

    private final JLabel getLabel() {
        return this.label;
    }

    protected final JComponent getBtn() {
        return this.btn;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.text.setEnabled(b);
        this.btn.setEnabled(b && this.cache != null);
    }

    protected final ComboLockedMode getMode() {
        return this.locked;
    }

    private boolean isLocked() {
        return this.locked.valueMustBeInList();
    }

    public final boolean isSearchable() {
        return this.searchable;
    }

    public final void setSearchable(boolean searchable) {
        this.searchable = searchable;
        this.text.setEditable(this.searchable || !this.isLocked());
        if (!this.text.isEditable()) {
            this.text.setBackground(Color.WHITE);
        }
    }

    public final List<Action> getActions() {
        return this.actions;
    }

    public final IListModel<T> getCache() {
        return this.cache;
    }

    public void initCache(IListModel<T> acache) {
        if (acache == null) {
            throw new NullPointerException("null cache");
        }
        if (this.getCache() != null) {
            throw new IllegalStateException("cache already set " + this.getCache());
        }
        this.cache = acache;
        this.setEnabled(this.isEnabled());
        if (this.getMode().isListMutable()) {
            if (!(acache instanceof IMutableListModel)) {
                throw new IllegalArgumentException(this + " is unlocked but " + acache + " is not mutable");
            }
            final IMutableListModel mutable = (IMutableListModel)acache;
            final boolean isReloadable = mutable instanceof Reloadable;
            final Reloadable rel = isReloadable ? (Reloadable)((Object)mutable) : null;
            new MutableListComboPopupListener(new MutableListCombo(){

                @Override
                public ComboLockedMode getMode() {
                    return ISearchableCombo.this.getMode();
                }

                @Override
                public Component getPopupComp() {
                    return ISearchableCombo.this.getTextComp();
                }

                @Override
                public void addCurrentText() {
                    if (ISearchableCombo.this.parsedValidState.isValid()) {
                        Object newItem = ISearchableCombo.this.getValue();
                        if (newItem != null && !mutable.getList().contains(newItem)) {
                            mutable.addElement(newItem);
                        }
                    } else {
                        JOptionPane.showMessageDialog(ISearchableCombo.this, ISearchableCombo.this.parsedValidState.getValidationText(), "Impossible d'ajouter le texte", 0);
                    }
                }

                @Override
                public void removeCurrentText() {
                    mutable.removeElement(ISearchableCombo.this.getValue());
                }

                @Override
                public boolean canReload() {
                    return isReloadable;
                }

                @Override
                public void reload() {
                    rel.reload();
                }
            }).listen();
        }
        this.addItemsFromCache(0, this.getCache().getSize() - 1);
        this.getCache().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() < 0) {
                    return;
                }
                int equalsCount = CollectionUtils.equals(ISearchableCombo.this.getModel().getList(), ISearchableCombo.this.getCache().getList(), true, new ITransformer<ISearchableComboItem<T>, T>(){

                    @Override
                    public T transformChecked(ISearchableComboItem<T> input) {
                        return input.getOriginal();
                    }
                });
                int oldIndex1 = ISearchableCombo.this.getModel().getSize() - 1 - equalsCount;
                int newIndex1 = ISearchableCombo.this.getCache().getSize() - 1 - equalsCount;
                if (oldIndex1 >= 0) {
                    ISearchableCombo.this.rmItemsFromModel(e.getIndex0(), oldIndex1);
                }
                if (newIndex1 >= 0) {
                    ISearchableCombo.this.addItemsFromCache(e.getIndex0(), newIndex1);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ISearchableCombo.this.addItemsFromCache(e.getIndex0(), e.getIndex1());
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ISearchableCombo.this.rmItemsFromModel(e.getIndex0(), e.getIndex1());
            }
        });
        this.updateValidState();
    }

    private void addItemsFromCache(int index0, int index1) {
        this.addItems(index0, this.getCache().getList().subList(index0, index1 + 1));
    }

    private void addItems(int index, Collection<T> originalItems) {
        assert (SwingUtilities.isEventDispatchThread());
        ISearchableComboItem<T> sel = this.getSelection();
        Object selOriginal = sel == null ? null : sel.getOriginal();
        ArrayList<ISearchableComboItem<T>> toAdd = new ArrayList<ISearchableComboItem<T>>(originalItems.size());
        for (T originalItem : originalItems) {
            ISearchableComboItem<T> textSelectorItem;
            if (this.itemsByOriginalItem.containsKey(originalItem)) {
                textSelectorItem = this.createItem(originalItem);
                assert (!textSelectorItem.equals(this.itemsByOriginalItem.get(originalItem))) : "Have to not be equal to be able to choose one or the other";
            } else {
                textSelectorItem = sel != null && CompareUtils.equals(selOriginal, originalItem) ? sel : this.createItem(originalItem);
                this.itemsByOriginalItem.put(originalItem, textSelectorItem);
            }
            toAdd.add(textSelectorItem);
        }
        this.getModel().addAll(index, toAdd);
    }

    private void rmItemsFromModel(int index0, int index1) {
        this.getModel().removeElementsAt(index0, index1);
        this.itemsByOriginalItem.keySet().retainAll(new HashSet<T>(this.getCache().getList()));
    }

    private ISearchableComboItem<T> createItem(T originalItem) {
        return new ISearchableComboItem<T>(originalItem, this.createVarDesc(originalItem));
    }

    private final VarDesc createVarDesc(T o) {
        if (o instanceof VarDesc) {
            return (VarDesc)o;
        }
        if (this.varDescTransf != null) {
            return this.varDescTransf.transformChecked(o);
        }
        return new ToStringVarDesc(o);
    }

    public final void setVarDescFactory(ITransformer<T, VarDesc> t) {
        this.varDescTransf = t;
    }

    final Icon getIcon(ISearchableComboItem<T> i) {
        T o = i.getOriginal();
        if (o instanceof Icon) {
            return (Icon)o;
        }
        if (this.iconTransf != null) {
            return this.iconTransf.transformChecked(o);
        }
        return null;
    }

    public final void setIconFactory(ITransformer<T, Icon> t) {
        this.iconTransf = t;
    }

    protected T stringToT(String t) {
        throw new IllegalStateException("use " + ISearchableTextCombo.class);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }

    ISearchableComboItem<T> getSelection() {
        return this.getModel().getSelectedItem();
    }

    @Override
    public T getValue() {
        ISearchableComboItem<T> sel = this.getSelection();
        return sel == null ? null : (T)sel.getOriginal();
    }

    public final T getSelectedItem() {
        return this.getValue();
    }

    @Override
    public void resetValue() {
        this.setValue((T)null);
    }

    @Override
    public final void setValue(T val) {
        this.setValue(val, ValidState.getTrueInstance());
    }

    public final void setSelectedItem(T val) {
        this.setValue(val);
    }

    public final void setSelectedIndex(int anIndex) {
        int size = this.getCache().getSize();
        if (anIndex == -1) {
            this.setSelectedItem(null);
        } else {
            if (anIndex < -1 || anIndex >= size) {
                throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
            }
            this.setSelectedItem(this.getCache().getElementAt(anIndex));
        }
    }

    private final boolean setValid(ValidState valid) {
        boolean invalidChange;
        boolean bl = invalidChange = !this.parsedValidState.equals(valid);
        if (invalidChange) {
            this.parsedValidState = valid;
            this.text.setForeground(!this.parsedValidState.isValid() ? Color.GRAY : Color.BLACK);
        }
        return invalidChange;
    }

    private final void setValue(T val, ValidState valid) {
        this.log("entering " + this.getClass().getSimpleName() + ".setValue '" + val + "' valid: " + valid);
        ISearchableComboItem<T> comboItem = val == null ? null : (this.itemsByOriginalItem.containsKey(val) ? this.itemsByOriginalItem.get(val) : this.createItem(val));
        this.setComboItemValue(comboItem, valid);
    }

    @Override
    final void setValue(ISearchableComboItem<T> val) {
        this.log("entering " + this.getClass().getSimpleName() + ".setValue(ISearchableComboItem) " + val);
        assert (this.isEmptyItem(val) || new IdentityHashSet<ISearchableComboItem<T>>(this.getModelValues()).contains(val)) : "Item not in model, perhaps use setValue(T)";
        this.setComboItemValue(val, ValidState.getTrueInstance());
    }

    private final void setComboItemValue(ISearchableComboItem<T> val, ValidState valid) {
        ISearchableComboItem<T> normalized;
        this.log("entering " + this.getClass().getSimpleName() + ".setValue(ISearchableComboItem,ValidState) '" + val + "' valid: " + valid);
        boolean invalidChange = this.setValid(valid);
        ISearchableComboItem<T> iSearchableComboItem = normalized = this.isEmptyItem(val) ? null : val;
        if (!CompareUtils.equals(this.getSelection(), normalized)) {
            this.setSelection(normalized);
        } else if (invalidChange) {
            this.log("this.getSelection() == val and invalidChange");
            this.selectionChanged();
        }
    }

    private final void setSelection(ISearchableComboItem<T> val) {
        this.log("entering " + this.getClass().getSimpleName() + ".setSelection " + val);
        this.getModel().setSelectedItem(val);
    }

    protected final void selectionChanged() {
        this.updating = true;
        ISearchableComboItem<T> sel = this.getModel().getSelectedItem();
        this.getLabel().setIcon(sel == null ? null : this.getIcon(sel));
        this.updateMargin();
        if (this.parsedValidState.isValid()) {
            String newText = sel == null ? "" : sel.asString();
            this.setText(newText);
        }
        this.updating = false;
        this.updateValidState();
        this.supp.fireValueChange();
    }

    private final void setText(String newText) {
        if (!this.text.getText().equals(newText)) {
            this.text.setText(newText);
            if (this.forceDisplayStart || !this.text.isFocusOwner()) {
                this.text.getCaret().setDot(0);
            }
        }
    }

    private int getLeftMargin() {
        int labelWidth = (int)this.getLabel().getPreferredSize().getWidth();
        return this.textMargin.left + (labelWidth > 0 ? 4 + labelWidth : 0);
    }

    private int getRightMargin() {
        return 3 + this.getBtn().getWidth() + 3 + this.textMargin.right;
    }

    private void updateMargin() {
        Insets origMarg = this.text.getMargin();
        this.text.setMargin(new Insets(origMarg.top, this.getLeftMargin(), origMarg.bottom, this.getRightMargin()));
    }

    protected final void docChanged(DocumentEvent e) {
        if (!this.updating) {
            String text = SimpleDocumentListener.getText(e.getDocument());
            if (text.length() == 0) {
                this.setValue(null, ValidState.getTrueInstance());
            } else if (this.getMode().valueMustBeInList() && !this.getMode().isListMutable()) {
                this.setValue(null, ValidState.createCached(false, "la valeur n'a pas \u00e9t\u00e9 s\u00e9lectionn\u00e9e dans la liste"));
            } else {
                try {
                    this.setValue(this.stringToT(text));
                }
                catch (Exception exn) {
                    this.setValue(null, ValidState.createCached(false, "la valeur n'est pas correcte: " + exn.getLocalizedMessage()));
                }
            }
            if (this.isSearchable()) {
                this.updateAutoCompletion(false);
            }
        }
    }

    private void updateAutoCompletion(boolean showAll) {
        if (this.getCache() == null) {
            return;
        }
        String t = this.text.getText();
        if (this.completionThread != null) {
            this.completionThread.stopNow();
        }
        this.completionThread = new ISearchableComboCompletionThread(this, showAll, t);
        this.completionThread.setPriority(1);
        this.completionThread.start();
    }

    List<ISearchableComboItem<T>> getModelValues() {
        return this.getModel().getList();
    }

    void setMatchingCompletions(List<ISearchableComboItem<T>> l, boolean showAll) {
        this.listModel.removeAllElements();
        if (showAll && this.includeEmpty()) {
            this.listModel.addElement(this.emptyItem);
        }
        this.listModel.addAll(l);
        this.listModel.addAll(this.actions);
        if (showAll) {
            this.showCompletionPopup();
        } else if (l.size() > 1) {
            this.showCompletionPopup();
        } else if (l.size() == 1) {
            ISearchableComboItem<T> onlyCompletion = l.get(0);
            if (onlyCompletion.asString().equalsIgnoreCase(this.text.getText())) {
                this.hideCompletionPopup();
                this.setValue(onlyCompletion.getOriginal());
            } else {
                this.showCompletionPopup();
            }
        } else {
            this.hideCompletionPopup();
        }
    }

    public final boolean includeEmpty() {
        return this.includeEmpty;
    }

    public final void setIncludeEmpty(boolean include) {
        this.includeEmpty = include;
    }

    void hideCompletionPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ISearchableCombo.this.popupCompletion.close();
            }
        });
    }

    void showCompletionPopup() {
        if (this.isShowing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ISearchableCombo.this.popupCompletion.open();
                }
            });
        }
    }

    public final void setMaxVisibleRows(int maxVisibleRows) {
        this.popupCompletion.setMaxVisibleRows(maxVisibleRows);
    }

    public final int getMaxVisibleRows() {
        return this.popupCompletion.getMaxVisibleRows();
    }

    public final void setColumns(int columns) {
        if (this.text instanceof JTextArea) {
            ((JTextArea)this.text).setColumns(columns);
        } else if (this.text instanceof JTextField) {
            ((JTextField)this.text).setColumns(columns);
        } else {
            throw new IllegalStateException("No setColumns() on " + this.text.getClass());
        }
    }

    public final void setRows(int rows) {
        this.setRows(rows, null);
    }

    public final void setRows(int rows, Boolean textArea) {
        JTextComponent newText = null;
        if (this.text instanceof JTextArea) {
            JTextArea ta = (JTextArea)this.text;
            if (textArea == Boolean.FALSE && rows == 1) {
                newText = this.createTextField(ta.getColumns());
            } else {
                ta.setRows(rows);
            }
        } else if (this.text instanceof JTextField) {
            JTextField tf = (JTextField)this.text;
            if (textArea == Boolean.TRUE || rows > 1) {
                newText = new ITextArea(rows, tf.getColumns());
            }
        } else {
            throw new IllegalStateException("Neither JTextArea nor JTextField " + this.text.getClass());
        }
        if (newText != null) {
            this.setTextEditor(newText);
        }
    }

    private JTextField createTextField(int columns) {
        boolean macLaF = UIManager.getLookAndFeel().getID().equals("Aqua");
        JTextField tf = !macLaF ? new JTextField(columns) : new JTextField(columns){

            @Override
            public Insets getInsets() {
                Insets res = (Insets)super.getInsets().clone();
                res.left += ISearchableCombo.this.getLeftMargin();
                res.right += ISearchableCombo.this.getRightMargin();
                return res;
            }
        };
        return tf;
    }

    public final void setForceDisplayStart(boolean forceDisplayStart) {
        this.forceDisplayStart = forceDisplayStart;
    }

    public final void setTextEditor(int rows, int columns, boolean textArea) {
        this.setTextEditor(rows > 1 || textArea ? new ITextArea(rows, columns) : this.createTextField(columns));
    }

    protected final void setTextEditor(JTextComponent atext) {
        if (atext == null) {
            throw new IllegalArgumentException("null textEditor");
        }
        if (this.text != null) {
            this.text.removeMouseMotionListener(this.dragL);
            this.text.removeMouseListener(this.clickL);
            this.remove(this.text);
            this.text.removeAll();
        }
        this.text = atext;
        this.textMargin = (Insets)this.text.getMargin().clone();
        this.setFont(this.text.getFont());
        this.text.setFont(null);
        this.getTextComp().setLayout(new LayoutManager2(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void invalidateLayout(Container target) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return parent.getPreferredSize();
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return parent.getMinimumSize();
            }

            @Override
            public Dimension maximumLayoutSize(Container target) {
                return target.getMaximumSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets parentInsets = ((JComponent)parent).getInsets();
                ISearchableCombo.this.getLabel().setSize(ISearchableCombo.this.getLabel().getPreferredSize());
                ISearchableCombo.this.getLabel().setLocation(parentInsets.left - ISearchableCombo.this.getLabel().getWidth() - 2, parent.getHeight() / 2 - ISearchableCombo.this.getLabel().getHeight() / 2);
                ISearchableCombo.this.getBtn().setSize(ISearchableCombo.this.getBtn().getWidth(), parent.getHeight());
                ISearchableCombo.this.getBtn().setLocation(parent.getWidth() - parentInsets.right + 3, parent.getHeight() / 2 - ISearchableCombo.this.getBtn().getHeight() / 2);
            }

            @Override
            public float getLayoutAlignmentX(Container target) {
                return 0.5f;
            }

            @Override
            public float getLayoutAlignmentY(Container target) {
                return 0.5f;
            }
        });
        this.text.add(this.getLabel());
        this.text.add(this.getBtn());
        this.updateMargin();
        this.add(this.text);
        this.setMinimumSize(new Dimension(this.getMinimumSize()));
        this.text.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                ISearchableCombo.this.docChanged(e);
            }
        });
        this.text.addKeyListener(new KeyListener(){
            private boolean consume;

            private final boolean isAtLastLine(JTextComponent src) {
                if (src.getDocument().getLength() == 0) {
                    return true;
                }
                try {
                    Rectangle caretView = src.modelToView(src.getCaret().getDot());
                    Rectangle lastView = src.modelToView(src.getDocument().getLength() - 1);
                    return caretView.y >= lastView.y;
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                    return false;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextComponent src = (JTextComponent)e.getSource();
                ISearchableComboPopup popup = ISearchableCombo.this.popupCompletion;
                if (e.getKeyCode() == 27) {
                    if (ISearchableCombo.this.getTextComp().getDocument().getLength() == 0) {
                        ISearchableCombo.this.hideCompletionPopup();
                    }
                } else if (e.getKeyCode() == 40) {
                    if (popup.isShowing()) {
                        popup.selectNext();
                        e.consume();
                    } else if (this.isAtLastLine(src)) {
                        ISearchableCombo.this.updateAutoCompletion(true);
                    }
                } else if (e.getKeyCode() == 38) {
                    if (popup.isShowing()) {
                        popup.selectPrevious();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 10) {
                    if (popup.isShowing()) {
                        popup.validateSelection();
                        if (!popup.isShowing()) {
                            e.consume();
                        }
                    }
                } else if (e.getKeyCode() == 34) {
                    if (popup.isShowing()) {
                        popup.selectNextPage();
                        e.consume();
                    }
                } else if (e.getKeyCode() == 33 && popup.isShowing()) {
                    popup.selectPreviousPage();
                    e.consume();
                }
                if (src.getDocument().getLength() == 0 && (e.getKeyCode() == 127 || e.getKeyCode() == 8)) {
                    this.consume = true;
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                    this.consume = false;
                }
            }
        });
        this.text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ISearchableCombo.this.hideCompletionPopup();
            }
        });
        this.text.addMouseListener(this.clickL);
        this.text.addMouseMotionListener(this.dragL);
    }

    public void setMinimumSearch(int j) {
        this.minimumSearch = j;
    }

    public int getMinimumSearch() {
        return this.minimumSearch;
    }

    public void setMaximumResult(int j) {
        this.maximumResult = j;
    }

    public final SearchMode getCompletionMode() {
        return this.modeCompletion;
    }

    public final void setCompletionMode(SearchMode m) {
        this.modeCompletion = m;
    }

    boolean isEmptyItem(ISearchableComboItem<T> val) {
        return val == this.emptyItem;
    }

    public int getMaximumResult() {
        return this.maximumResult;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    private void updateValidState() {
        boolean listValid = !this.getMode().valueMustBeInList() || this.getValue() == null || this.itemsByOriginalItem.containsKey(this.getValue());
        this.setValidState(this.parsedValidState.and(ValidState.createCached(listValid, "la valeur ne fait pas partie des choix")));
    }

    private void setValidState(ValidState v) {
        if (!v.equals(this.validState)) {
            this.validState = v;
            this.supp.fireValidChange();
        }
    }

    @Override
    public ValidState getValidState() {
        return this.validState;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public Document getDocument() {
        if (this.isLocked()) {
            return null;
        }
        return this.getTextComp().getDocument();
    }

    @Override
    public JTextComponent getTextComp() {
        return this.text;
    }

    @Override
    public String toString() {
        String c = this.getCache() != null ? "with cache" : "without cache";
        String s = this.isSearchable() ? "" : "/non searchable";
        return String.valueOf(this.getClass().getSimpleName()) + "(" + (Object)((Object)this.getMode()) + "/" + c + s + ")";
    }

    public String asString() {
        return String.valueOf(this.toString()) + ":" + this.getValue() + "(\"" + this.getTextComp().getText() + "\")";
    }
}

