/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Desktop;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openconcerto.utils.ExceptionHandler;

public class HTMLTextField
extends JEditorPane {
    private static final ExecutorService exec = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.valueOf(HTMLTextField.class.getSimpleName()) + " Desktop thread");
            t.setDaemon(true);
            return t;
        }
    });

    public HTMLTextField(String html) {
        super("text/html", html);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                JComponent src = (JComponent)e.getSource();
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLTextField.this.linkActivated(e, src);
                } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    src.setToolTipText(HTMLTextField.this.getToolTip(e));
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    src.setToolTipText(null);
                }
            }
        });
        this.setBorder(null);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFont(new JTextField().getFont());
    }

    protected String getToolTip(HyperlinkEvent e) {
        return e.getDescription();
    }

    protected void linkActivated(final HyperlinkEvent e, final JComponent src) {
        exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception exn) {
                    ExceptionHandler.handle(src, "Impossible d'ouvrir " + e.getURL(), exn);
                }
            }
        });
    }
}

