/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class UserExit {
    private final Component comp;
    private final Runnable r;

    public static void closeAllWindows(Window last) {
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window f = windowArray[n2];
            if (f != last && f.isDisplayable()) {
                f.dispose();
            }
            ++n2;
        }
        if (last != null) {
            last.dispose();
        }
    }

    public UserExit(final Component comp) {
        this(comp, new Runnable(){

            @Override
            public void run() {
                UserExit.closeAllWindows(comp == null ? null : SwingUtilities.getWindowAncestor(comp));
            }
        });
    }

    public UserExit(Component comp, Runnable r) {
        this.comp = comp;
        this.r = r;
    }

    public final void ask() {
        int res = JOptionPane.showConfirmDialog(this.comp, "Voulez-vous vraiment quitter ?", "Quitter", 0, 2);
        if (res == 0) {
            this.r.run();
        }
    }
}

