/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openconcerto.ui.SwingThreadUtils;

public class MenuUtils {
    private static final String GROUPNAME_PROPNAME = "GROUPNAME";
    private static final String DEFAULT_GROUPNAME = "defaultGroupName";

    public static <C extends JComponent> JMenuItem addMenuItem(Action action, C topLevelMenu) throws IllegalArgumentException {
        return MenuUtils.addMenuItem(action, topLevelMenu, new String[]{null});
    }

    public static <C extends JComponent> JMenuItem addMenuItem(Action action, C topLevelMenu, String ... path) throws IllegalArgumentException {
        return MenuUtils.addMenuItem(action, topLevelMenu, Arrays.asList(path));
    }

    public static <C extends JComponent> JMenuItem addMenuItem(Action action, C topLevelMenu, List<String> path) throws IllegalArgumentException {
        return MenuUtils.addMenuItem(new JMenuItem(action), topLevelMenu, path);
    }

    public static <C extends JComponent> JMenuItem addMenuItem(JMenuItem mi, C topLevelMenu, List<String> path) throws IllegalArgumentException {
        if (path.size() == 0 || path.size() % 2 == 0) {
            throw new IllegalArgumentException("Path should be of the form group/menu/group/... : " + path);
        }
        Object menu = topLevelMenu;
        int i = 0;
        while (i < path.size() - 1) {
            String groupName = path.get(i);
            String menuName = path.get(i + 1);
            menu = MenuUtils.addChild(menu, groupName, new JMenu(menuName), JMenu.class, false);
            i += 2;
        }
        String actionGroupName = path.get(path.size() - 1);
        return MenuUtils.addChild(menu, actionGroupName, mi, JMenuItem.class, true);
    }

    private static Component[] getChildren(Container c) {
        return c instanceof JMenu ? ((JMenu)c).getMenuComponents() : c.getComponents();
    }

    private static <T extends JMenuItem> T addChild(Container c, String groupName, T created, Class<T> clazz, boolean alwaysAdd) {
        T res;
        Component[] children;
        int[] groupRange;
        if (groupName == null) {
            groupName = DEFAULT_GROUPNAME;
        }
        if ((groupRange = MenuUtils.getRange(children = MenuUtils.getChildren(c), groupName)) == null) {
            if (children.length > 0) {
                c.add(new JSeparator());
            }
            res = created;
            c.add(res);
        } else {
            Object existingChild;
            Object v0 = existingChild = alwaysAdd ? null : MenuUtils.findChild(children, groupRange, created.getText(), clazz);
            if (existingChild != null) {
                res = existingChild;
            } else {
                res = created;
                c.add((Component)res, groupRange[1]);
            }
        }
        res.putClientProperty(GROUPNAME_PROPNAME, groupName);
        return res;
    }

    private static int[] getRange(Component[] children, String groupName) {
        int[] nArray;
        int min = -1;
        int max = -1;
        int i = 0;
        while (i < children.length) {
            if (groupName.equals(((JComponent)children[i]).getClientProperty(GROUPNAME_PROPNAME))) {
                if (min < 0) {
                    min = i;
                }
                if (max < i) {
                    max = i;
                }
            }
            ++i;
        }
        if (min == -1) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = min;
            nArray = nArray2;
            nArray2[1] = max + 1;
        }
        return nArray;
    }

    public static <T extends JMenuItem> T findChild(Container c, String name, Class<T> clazz) {
        return MenuUtils.findChild(MenuUtils.getChildren(c), null, name, clazz);
    }

    private static <T extends JMenuItem> T findChild(Component[] children, int[] range, String name, Class<T> clazz) {
        if (range == null) {
            int[] nArray = new int[2];
            nArray[1] = children.length;
            range = nArray;
        }
        int groupIndex = range[0];
        while (groupIndex < range[1]) {
            JMenuItem casted;
            Component child = children[groupIndex];
            if (clazz == child.getClass() && name.equals((casted = (JMenuItem)clazz.cast(child)).getText())) {
                return (T)casted;
            }
            ++groupIndex;
        }
        return null;
    }

    public static void removeMenuItem(JMenuItem item) {
        Container parent = MenuUtils.detachItem(item);
        JMenu menu = SwingThreadUtils.getAncestorOrSelf(JMenu.class, parent);
        while (menu != null && menu.getMenuComponentCount() == 0) {
            parent = MenuUtils.detachItem(menu);
            menu = SwingThreadUtils.getAncestorOrSelf(JMenu.class, parent);
        }
    }

    private static Container detachItem(JComponent item) {
        Container parent = item.getParent();
        Component[] siblings = parent.getComponents();
        int index = Arrays.asList(siblings).indexOf(item);
        boolean sepBefore = index > 0 && siblings[index - 1] instanceof JSeparator;
        boolean sepAfter = index < siblings.length - 1 && siblings[index + 1] instanceof JSeparator;
        parent.remove(index);
        if (siblings.length > 1) {
            if (sepBefore && sepAfter || sepAfter && index == 0) {
                parent.remove(index);
            } else if (sepBefore && index == siblings.length - 1) {
                parent.remove(index - 1);
            }
        }
        ((JComponent)parent).revalidate();
        parent.repaint();
        return parent;
    }
}

