/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.ChangeFKRunnable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelLinesSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOffline;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.cc.ITransformer;

public class SQLTableModelLinesSourceOffline
extends SQLTableModelLinesSource {
    private final SQLTableModelSourceOffline parent;
    private final List<ListSQLLine> lines = new LinkedList<ListSQLLine>();
    private int freeID = -10;
    private final Map<Integer, ListSQLLine> id2line = new HashMap<Integer, ListSQLLine>();
    private final SQLRowValues modifiableVals;
    private final Map<ListSQLLine, SQLRowValues> dbVals;
    private final Set<ListSQLLine> deleted;

    public SQLTableModelLinesSourceOffline(SQLTableModelSourceOffline parent, ITableModel model) {
        super(model);
        this.parent = parent;
        this.modifiableVals = this.getParent().getElem().getPrivateGraph();
        this.dbVals = new IdentityHashMap<ListSQLLine, SQLRowValues>();
        this.deleted = new HashSet<ListSQLLine>();
        this.reset();
    }

    @Override
    public final SQLTableModelSourceOffline getParent() {
        return this.parent;
    }

    public final synchronized void add(SQLRowValues vals) {
        vals.grow(this.getParent().getFetcher().getGraph(), false);
        ListSQLLine newLine = this.createLine(vals);
        if (newLine != null) {
            newLine.clearCache();
        }
    }

    public final synchronized void reset() {
        this.lines.clear();
        this.id2line.clear();
        this.dbVals.clear();
        this.deleted.clear();
        for (SQLRowValues r : this.getParent().getFetcher().fetch()) {
            this.add(r);
        }
    }

    public final synchronized ListSQLLine rm(int index) {
        return this.rm(this.lines.get(index));
    }

    private synchronized ListSQLLine rm(ListSQLLine line) {
        if (line != null) {
            this._rm(line);
            if (line.getRow().hasID()) {
                this.deleted.add(line);
            }
            this.fireLineChanged(line.getID(), null, null);
        }
        return line;
    }

    private synchronized void _rm(ListSQLLine l) {
        if (l != null) {
            this.lines.remove(l);
            this.id2line.remove(l.getID());
        }
    }

    @Override
    public synchronized List<ListSQLLine> getAll() {
        return Collections.unmodifiableList(this.lines);
    }

    @Override
    public synchronized ListSQLLine get(final int id) {
        SQLRowValuesListFetcher f = new SQLRowValuesListFetcher(this.getParent().getFetcher().getGraph());
        f.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                if (ListSQLRequest.lockSelect) {
                    input.addWaitPreviousWriteTXTable(SQLTableModelLinesSourceOffline.this.getParent().getPrimaryTable().getName());
                }
                Where w = new Where((FieldRef)SQLTableModelLinesSourceOffline.this.getParent().getPrimaryTable().getKey(), "=", id);
                return SQLTableModelLinesSourceOffline.this.getParent().getFetcher().getSelTransf().transformChecked(input).andWhere(w);
            }
        });
        SQLRowValues row = CollectionUtils.getSole(f.fetch());
        if (row == null) {
            this._rm(this.id2line.get(id));
        }
        return this.createLine(row);
    }

    @Override
    protected synchronized void lineCreated(ListSQLLine res) {
        super.lineCreated(res);
        this.id2line.put(res.getID(), res);
        this.lines.add(res);
    }

    @Override
    protected synchronized int getID(SQLRowValues r) {
        int n;
        if (r.hasID()) {
            n = r.getID();
        } else {
            int n2 = this.freeID;
            n = n2;
            this.freeID = n2 - 1;
        }
        return n;
    }

    @Override
    public synchronized int compare(ListSQLLine l1, ListSQLLine l2) {
        if (l1 == l2) {
            return 0;
        }
        for (ListSQLLine l : this.lines) {
            if (l == l1) {
                return -1;
            }
            if (l != l2) continue;
            return 1;
        }
        throw new IllegalArgumentException("neither " + l1 + " nor " + l2 + " in " + this);
    }

    @Override
    public void commit(ListSQLLine l, Path path, SQLRowValues vals) {
        this.checkCanModif(l, path);
        l.loadAt(vals, path);
    }

    private synchronized void checkCanModif(ListSQLLine l, Path path) {
        if (this.modifiableVals.followPath(path) == null) {
            throw new IllegalArgumentException("can only modify " + this.modifiableVals);
        }
        if (l.getRow().hasID() && !this.dbVals.containsKey(l)) {
            this.dbVals.put(l, l.getRow().deepCopy());
        }
    }

    public void changeFK(ListSQLLine l, Path p, int id) {
        this.checkCanModif(l, p.subPath(0, p.length() - 1));
        if (this.modifiableVals.followPath(p) != null) {
            throw new IllegalArgumentException("can only modify a foreign key of " + this.modifiableVals);
        }
        this.getModel().getUpdateQ().put(new ChangeFKRunnable(l, p, id));
    }

    public final synchronized void commit() throws SQLException {
        for (ListSQLLine listSQLLine : CopyUtils.copy(this.lines)) {
            if (listSQLLine.getRow().hasID()) continue;
            this.rm(listSQLLine);
            listSQLLine.getRow().prune(this.modifiableVals).commit();
        }
        for (Map.Entry entry : this.dbVals.entrySet()) {
            this.getParent().getElem().update((SQLRowValues)entry.getValue(), ((ListSQLLine)entry.getKey()).getRow()).exec();
        }
        this.dbVals.clear();
        for (ListSQLLine listSQLLine : this.deleted) {
            this.getParent().getElem().archive(listSQLLine.getRow().getID());
        }
        this.deleted.clear();
    }
}

