/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.sql.SQLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.SleepingQueue;

final class MoveQueue
extends SleepingQueue {
    private final ITableModel tableModel;

    public MoveQueue(ITableModel model) {
        super(String.valueOf(MoveQueue.class.getSimpleName()) + " on " + model);
        this.tableModel = model;
    }

    public void move(final int id, final int inc) {
        this.put(new Runnable(){

            @Override
            public void run() {
                final AtomicReference destID = new AtomicReference();
                final CountDownLatch latch = new CountDownLatch(1);
                MoveQueue.this.tableModel.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        destID.set(MoveQueue.this.tableModel.getDestID(id, inc));
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                }
                if (destID.get() != null) {
                    try {
                        MoveQueue.this.moveQuick(id, (Integer)destID.get());
                    }
                    catch (SQLException e) {
                        throw ExceptionUtils.createExn(IllegalStateException.class, "move failed", e);
                    }
                }
            }
        });
    }

    final void moveQuick(int srcId, int destId) throws SQLException {
        SQLRow srcRow = this.getTable().getRow(srcId);
        SQLRow destRow = this.getTable().getRow(destId);
        boolean after = srcRow.getOrder().compareTo(destRow.getOrder()) < 0;
        SQLRowValues vals = srcRow.createEmptyUpdateRow();
        vals.setOrder(destRow, after).update();
    }

    private SQLTable getTable() {
        return this.tableModel.getTable();
    }
}

