/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLImmutableRowValues;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.FileTransfertHandler;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.sql.view.list.TableListStateModel;
import org.openconcerto.sql.view.list.VirtualMenu;
import org.openconcerto.sql.view.search.ColumnSearchSpec;
import org.openconcerto.sql.view.search.SearchList;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.ui.FormatEditor;
import org.openconcerto.ui.MenuUtils;
import org.openconcerto.ui.PopupMouseListener;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.list.selection.ListSelection;
import org.openconcerto.ui.list.selection.ListSelectionState;
import org.openconcerto.ui.state.JTableStateManager;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.ColumnSizeAdjustor;
import org.openconcerto.ui.table.TableColumnModelAdapter;
import org.openconcerto.ui.table.TablePopupMouseListener;
import org.openconcerto.ui.table.ViewTableModel;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.FormatGroup;
import org.openconcerto.utils.TableModelSelectionAdapter;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.convertor.StringClobConvertor;
import org.openconcerto.utils.text.BooleanFormat;

public final class IListe
extends JPanel
implements AncestorListener {
    private static boolean FORCE_ALT_CELL_RENDERER = false;
    private static final DateFormat MODIF_DATE_FORMAT = new SimpleDateFormat("'le' dd MMMM yyyy '\u00e0' HH:mm:ss");
    static final String SEP = " \u25ba ";
    public static final TableCellRenderer DATE_RENDERER = new FormatRenderer(DateFormat.getDateInstance(2));
    public static final TableCellRenderer TIME_RENDERER = new FormatRenderer(DateFormat.getTimeInstance(3));
    public static final TableCellRenderer DATETIME_RENDERER = new FormatRenderer(DateFormat.getDateTimeInstance(2, 3));
    private static final Map<Class<?>, FormatGroup> FORMATS = new HashMap();
    private final JTable jTable;
    private final JTextField filter;
    private boolean debugFilter;
    private FilterWorker filterWorker;
    private final JPopupMenu popup;
    private final TableSorter sorter;
    private SQLTableModelSource src;
    private boolean adjustVisible;
    private ColumnSizeAdjustor tcsa;
    private final Map<IListeAction, IListeAction.ButtonsBuilder> rowActions;
    private IListeAction defaultRowAction;
    private final JPanel btnPanel;
    private final Map<Class<?>, FormatGroup> searchFormats;
    private final List<IListener> listeners;
    private final List<IListener> naListeners;
    private final PropertyChangeSupport supp;
    private final ListSelectionListener selectionListener;
    private final PropertyChangeListener filterListener;
    private final List<PropertyChangeListener> modelPCListeners;
    private final ListSelectionState state;
    private final JTableStateManager tableStateManager;
    private int retainCount = 0;

    static {
        FORMATS.put(Date.class, new FormatGroup(DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1)));
        FORMATS.put(Time.class, new FormatGroup(DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(3)));
        FORMATS.put(Timestamp.class, new FormatGroup(DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 3)));
    }

    public static final void remove(InputMap m, KeyStroke key) {
        InputMap current = m;
        while (current != null) {
            current.remove(key);
            current = current.getParent();
        }
    }

    public static void setForceAlternateCellRenderer(boolean force) {
        FORCE_ALT_CELL_RENDERER = force;
    }

    public static final IListe get(EventObject evt) {
        return SwingThreadUtils.getAncestorOrSelf(IListe.class, (Component)evt.getSource());
    }

    public IListe(ListSQLRequest req) {
        this(req, null);
    }

    public IListe(ListSQLRequest req, File configFile) {
        this((Object)req, configFile);
    }

    public IListe(SQLTableModelSource req) {
        this(req, null);
    }

    public IListe(SQLTableModelSource req, File configFile) {
        this((Object)req, configFile);
    }

    private IListe(Object req, File configFile) {
        if (req == null) {
            throw new NullPointerException("Cr\u00e9ation d'une IListe avec une requete null");
        }
        this.rowActions = new LinkedHashMap<IListeAction, IListeAction.ButtonsBuilder>();
        this.supp = new PropertyChangeSupport(this);
        this.listeners = new ArrayList<IListener>();
        this.naListeners = new ArrayList<IListener>();
        this.modelPCListeners = new ArrayList<PropertyChangeListener>();
        this.sorter = new TableSorter();
        this.jTable = new JTable(this.sorter){

            @Override
            public String getToolTipText(MouseEvent event) {
                String modif;
                SQLRowValues row;
                String create;
                String original = super.getToolTipText(event);
                int rowIndex = this.rowAtPoint(event.getPoint());
                if (rowIndex < 0) {
                    return original;
                }
                ArrayList<String> infoL = new ArrayList<String>();
                if (original != null) {
                    String html = "<html>";
                    if (original.startsWith("<html>")) {
                        infoL.add(original.substring("<html>".length(), original.length() - "<html>".length() - 1));
                    } else {
                        infoL.add(original);
                    }
                }
                if ((create = this.getLine("Cr\u00e9\u00e9e", row = ITableModel.getLine(this.getModel(), rowIndex).getRow(), IListe.this.getSource().getPrimaryTable().getCreationUserField(), IListe.this.getSource().getPrimaryTable().getCreationDateField())) != null) {
                    infoL.add(create);
                }
                if ((modif = this.getLine("Modifi\u00e9e", row, IListe.this.getSource().getPrimaryTable().getModifUserField(), IListe.this.getSource().getPrimaryTable().getModifDateField())) != null) {
                    infoL.add(modif);
                }
                String info = infoL.size() == 0 ? null : "<html>" + CollectionUtils.join(infoL, "<br/>") + "</html>";
                return info;
            }

            public String getLine(String verb, SQLRowValues row, SQLField userF, SQLField dateF) {
                SQLRowAccessor user;
                Calendar date = dateF == null ? null : row.getDate(dateF.getName());
                SQLRowAccessor sQLRowAccessor = user = userF == null || row.isForeignEmpty(userF.getName()) ? null : row.getForeign(userF.getName());
                if (user == null && date == null) {
                    return null;
                }
                String res = verb;
                if (user != null) {
                    res = String.valueOf(res) + " par " + user.getString("PRENOM") + " " + user.getString("NOM");
                }
                if (date != null) {
                    res = String.valueOf(res) + " " + MODIF_DATE_FORMAT.format(date.getTime());
                }
                return res;
            }

            @Override
            public void createDefaultColumnsFromModel() {
                super.createDefaultColumnsFromModel();
                IListe.this.loadTableState();
            }
        };
        this.adjustVisible = true;
        this.tcsa = null;
        this.filter = new JTextField();
        this.filter.setEditable(false);
        this.debugFilter = false;
        this.filterWorker = null;
        InputMap tm = this.jTable.getInputMap(1);
        IListe.remove(tm, KeyStroke.getKeyStroke("F2"));
        tm.put(KeyStroke.getKeyStroke(' '), "startEditing");
        this.jTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.jTable.setShowHorizontalLines(false);
        this.jTable.setGridColor(new Color(230, 230, 230));
        this.jTable.setRowHeight(this.jTable.getRowHeight() + 4);
        this.popup = new JPopupMenu();
        TablePopupMouseListener.add(this.jTable, new ITransformer<MouseEvent, JPopupMenu>(){

            @Override
            public JPopupMenu transformChecked(MouseEvent input) {
                return IListe.this.updatePopupMenu(true);
            }
        });
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    IListe.this.performDefaultAction(e);
                }
            }
        });
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    IListe.this.fireNASelectionId();
                    IListe.this.updateButtons();
                }
            }
        };
        this.filterListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListe.this.updateFilter();
            }
        };
        this.jTable.getColumnModel().addColumnModelListener(new TableColumnModelAdapter(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                IListe.this.updateCols(e.getToIndex());
            }
        });
        this.tableStateManager = new JTableStateManager(this.jTable, configFile);
        if (req instanceof SQLTableModelSource) {
            this.setSource((SQLTableModelSource)req);
        } else {
            this.setRequest((ListSQLRequest)req);
        }
        this.state = ListSelectionState.manage(this.jTable.getSelectionModel(), new TableListStateModel(this.sorter));
        this.state.addPropertyChangeListener("selectedIndex", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Number newValue = (Number)evt.getNewValue();
                if (newValue.intValue() >= 0) {
                    IListe.this.jTable.scrollRectToVisible(IListe.this.jTable.getCellRect(newValue.intValue(), 0, true));
                }
            }
        });
        this.state.addPropertyChangeListener("selectedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListe.this.fireSelectionId(((Number)evt.getNewValue()).intValue(), IListe.this.jTable.getSelectedColumn());
            }
        });
        this.btnPanel = new JPanel(new FlowLayout(3));
        this.addModelListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("updating".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue())) {
                    IListe.this.updateButtons();
                }
            }
        });
        this.searchFormats = new HashMap(this.getFormats());
        this.searchFormats.put(Boolean.class, new FormatGroup(new BooleanFormat(), BooleanFormat.getNumberInstance(), BooleanFormat.createYesNo(Locale.getDefault())));
        ArrayList<Format> wAndwoTime = new ArrayList<Format>();
        wAndwoTime.addAll(this.searchFormats.get(Timestamp.class).getFormats());
        wAndwoTime.addAll(this.searchFormats.get(Date.class).getFormats());
        this.searchFormats.put(Timestamp.class, new FormatGroup(wAndwoTime));
        this.uiInit();
    }

    public final Map<Class<?>, FormatGroup> getFormats() {
        return FORMATS;
    }

    public final Map<Class<?>, FormatGroup> getSearchFormats() {
        return this.searchFormats;
    }

    public final RowAction addRowAction(Action action) {
        RowAction.PredicateRowAction res = new RowAction.PredicateRowAction(action, false, true).setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.addIListeAction(res);
        return res;
    }

    public final void addIListeActions(Collection<? extends IListeAction> actions) {
        for (IListeAction iListeAction : actions) {
            this.addIListeAction(iListeAction);
        }
    }

    private final int findGroupIndex(String groupName) {
        if (groupName != null) {
            Component[] components = this.btnPanel.getComponents();
            int i = components.length - 1;
            while (i >= 0) {
                JComponent comp = (JComponent)components[i];
                if (groupName.equals(comp.getClientProperty("GROUPNAME"))) {
                    return i + 1;
                }
                --i;
            }
        }
        return -1;
    }

    public final void addIListeAction(IListeAction action) {
        if (this.rowActions.containsKey(action)) {
            return;
        }
        IListeAction.ButtonsBuilder headerBtns = action.getHeaderButtons();
        this.rowActions.put(action, headerBtns);
        if (headerBtns.getContent().size() > 0) {
            this.updateButton(headerBtns, new IListeAction.IListeEvent(this));
            for (JButton headerBtn : headerBtns.getContent().keySet()) {
                headerBtn.setOpaque(false);
                this.btnPanel.add((Component)headerBtn, this.findGroupIndex((String)headerBtn.getClientProperty("GROUPNAME")));
            }
            this.btnPanel.setVisible(true);
        }
    }

    public final void removeIListeActions(Collection<? extends IListeAction> actions) {
        for (IListeAction iListeAction : actions) {
            this.removeIListeAction(iListeAction);
        }
    }

    public final void removeIListeAction(IListeAction action) {
        IListeAction.ButtonsBuilder headerBtns = this.rowActions.remove(action);
        if (headerBtns == null) {
            return;
        }
        for (JButton headerBtn : headerBtns.getContent().keySet()) {
            this.btnPanel.remove(headerBtn);
            if (this.btnPanel.getComponentCount() == 0) {
                this.btnPanel.setVisible(false);
            }
            this.btnPanel.revalidate();
        }
        if (action.equals(this.defaultRowAction)) {
            this.setDefaultRowAction(null);
        }
    }

    private void updateButtons() {
        IListeAction.IListeEvent evt = new IListeAction.IListeEvent(this);
        for (IListeAction.ButtonsBuilder btns : this.rowActions.values()) {
            this.updateButton(btns, evt);
        }
    }

    private void updateButton(IListeAction.ButtonsBuilder btns, IListeAction.IListeEvent evt) {
        for (Map.Entry<JButton, IPredicate<IListeAction.IListeEvent>> e : btns.getContent().entrySet()) {
            e.getKey().setEnabled(e.getValue().evaluateChecked(evt));
        }
    }

    private JPopupMenu updatePopupMenu(boolean onRows) {
        this.popup.removeAll();
        IListeAction.PopupEvent evt = new IListeAction.PopupEvent(this, onRows);
        Action defaultAction = this.defaultRowAction != null ? this.defaultRowAction.getDefaultAction(evt) : null;
        VirtualMenu menu = VirtualMenu.createRoot(null);
        for (IListeAction iListeAction : this.rowActions.keySet()) {
            IListeAction.PopupBuilder popupContent = iListeAction.getPopupContent(evt);
            if (defaultAction != null && iListeAction == this.defaultRowAction) {
                JMenuItem defaultMI = popupContent.getRootMenuItem(defaultAction);
                if (defaultMI == null) {
                    Log.get().warning("Default action not found at the root level of popup for " + this);
                } else {
                    defaultMI.setFont(defaultMI.getFont().deriveFont(1));
                }
            }
            menu.merge(popupContent.getMenu());
        }
        for (Map.Entry entry : menu.getContent().entrySet()) {
            MenuUtils.addMenuItem((JMenuItem)entry.getKey(), this.popup, (List<String>)((List)entry.getValue()));
        }
        return this.popup;
    }

    public final void setDefaultRowAction(IListeAction action) {
        this.defaultRowAction = action;
        if (action != null) {
            this.addIListeAction(action);
        }
    }

    public final IListeAction getDefaultRowAction() {
        return this.defaultRowAction;
    }

    private void performDefaultAction(MouseEvent e) {
        Action defaultAction;
        if (this.defaultRowAction != null && (defaultAction = this.defaultRowAction.getDefaultAction(new IListeAction.IListeEvent(this))) != null) {
            defaultAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null, e.getWhen(), e.getModifiers()));
        }
    }

    private void uiInit() {
        this.filter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isAltDown()) {
                    IListe.this.invertDebug();
                }
            }
        });
        FontUtils.setFontFor(this.filter, SEP);
        this.updateFilter();
        this.jTable.getTableHeader().addMouseListener(new MouseAdapter(){
            private final JPopupMenu popupMenu = new JPopupMenu();
            {
                this.popupMenu.add(new JCheckBoxMenuItem(new AbstractAction("Ajuster la largeur des colonnes"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IListe.this.toggleAutoAdjust();
                    }
                }));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isAltDown()) {
                    boolean debug = IListe.this.getModel().isDebug();
                    IListe.this.getModel().setDebug(!debug);
                    IListe.this.setDebug(!debug);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (IListe.this.adjustVisible && e.isPopupTrigger()) {
                    ((JCheckBoxMenuItem)this.popupMenu.getComponent(0)).setSelected(IListe.this.isAutoAdjusting());
                    this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.jTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){
            private final TableCellRenderer orig;
            {
                this.orig = IListe.this.jTable.getTableHeader().getDefaultRenderer();
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component res = this.orig.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (res instanceof JComponent) {
                    SQLTableModelColumn col = IListe.this.getSource().getColumn(table.convertColumnIndexToModel(column));
                    ((JComponent)res).setToolTipText(col.getToolTip());
                }
                return res;
            }
        });
        this.jTable.setDefaultRenderer(Clob.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, StringClobConvertor.INSTANCE.unconvert((Clob)value), isSelected, hasFocus, row, column);
            }
        });
        this.jTable.setDefaultRenderer(Date.class, DATE_RENDERER);
        this.jTable.setDefaultRenderer(Time.class, TIME_RENDERER);
        this.jTable.setDefaultRenderer(Timestamp.class, DATETIME_RENDERER);
        for (Map.Entry<Class<?>, FormatGroup> e : this.getFormats().entrySet()) {
            this.jTable.setDefaultEditor(e.getKey(), new FormatEditor(e.getValue()));
        }
        this.sorter.setTableHeader(this.jTable.getTableHeader());
        this.addAncestorListener(this);
        this.jTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (IListe.this.isSorted()) {
                    return;
                }
                if (e.getKeyChar() == '+') {
                    IListe.this.deplacerDe(1);
                } else if (e.getKeyChar() == '-') {
                    IListe.this.deplacerDe(-1);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        scrollPane.setFocusable(false);
        scrollPane.addMouseListener(new PopupMouseListener(){

            @Override
            protected JPopupMenu createPopup(MouseEvent e) {
                return IListe.this.updatePopupMenu(false);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.filter, c);
        ++c.gridy;
        this.btnPanel.setVisible(false);
        this.btnPanel.setOpaque(false);
        this.add((Component)this.btnPanel, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)scrollPane, c);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 2L) != 0L) {
                    IListe.this.dispChanged();
                }
            }
        });
        this.setTransferHandler(new FileTransfertHandler(this.getSource().getPrimaryTable()));
    }

    protected final synchronized void invertDebug() {
        this.setDebug(!this.debugFilter);
    }

    protected final synchronized void setDebug(boolean b) {
        this.debugFilter = b;
        this.updateFilter();
    }

    private synchronized void updateFilter() {
        if (this.filterWorker != null) {
            this.filterWorker.cancel(true);
        }
        FilterWorker worker = !this.hasRequest() ? new RowFilterWorker(null) : (this.debugFilter ? new WhereFilterWorker(this.getRequest().getInstanceWhere()) : new RowFilterWorker(this.getRequest().getFilterRows()));
        this.filterWorker = worker;
        this.filterWorker.execute();
    }

    private void setFilter(String text) {
        this.filter.setText(text == null ? "" : text);
        this.filter.setVisible(text != null);
        this.revalidate();
    }

    public void selectID(int id) {
        this.selectIDs(Collections.singleton(id));
    }

    public void selectIDs(Collection<Integer> ids) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("not in EDT");
        }
        if (!this.isDead()) {
            this.state.selectIDs(ids);
        }
    }

    public int idFromIndex(int rowIndex) {
        return this.state.idFromIndex(rowIndex);
    }

    public void search(String s, String column) {
        this.search(s, column, null);
    }

    public void search(String s, String column, Runnable r) {
        this.getModel().search(SearchList.singleton(ColumnSearchSpec.create(s, this.getModel().getColumnNames().indexOf(column))), r);
    }

    public void exporter(File file) throws IOException {
        this.exporter(file, false, XMLFormatVersion.getDefault());
    }

    public File exporter(File file, boolean onlySelection, XMLFormatVersion version) throws IOException {
        return SpreadSheet.export(this.getExportModel(onlySelection), file, version);
    }

    protected TableModel getExportModel(boolean onlySelection) {
        ViewTableModel res = new ViewTableModel(this.jTable);
        return onlySelection ? new TableModelSelectionAdapter(res, this.jTable.getSelectedRows()) : res;
    }

    public void update() {
        this.getModel().updateAll();
    }

    public int getRowCount() {
        return this.getTableModel().getRowCount();
    }

    public int getTotalRowCount() {
        if (this.isDead()) {
            return this.getRowCount();
        }
        return this.getModel().getTotalRowCount();
    }

    public final boolean isDead() {
        return this.getTableModel() == null;
    }

    public int getItemCount() {
        int count = -1;
        if (!this.isDead()) {
            int fieldIndex = -1;
            SQLTable t = this.getModel().getTable();
            SQLField qte = t.contains("QUANTITE") ? t.getField("QUANTITE") : t.getFieldRaw("NB_ESSAI_DDR");
            if (qte != null) {
                SQLTableModelSource src = this.getModel().getReq();
                int i = 0;
                for (SQLTableModelColumn col : src.getColumns()) {
                    if (CollectionUtils.getSole(col.getFields()) == qte) {
                        fieldIndex = i;
                    }
                    ++i;
                }
            }
            if (fieldIndex > 0) {
                count = 0;
                int j = 0;
                while (j < this.getTableModel().getRowCount()) {
                    count += ((Number)this.getTableModel().getValueAt(j, fieldIndex)).intValue();
                    ++j;
                }
            }
        }
        return count;
    }

    public void deplacerDe(int inc) {
        this.getModel().moveBy(this.getSelectedId(), inc);
    }

    public int getSelectedId() {
        return this.state.getSelectedID();
    }

    public final boolean hasSelection() {
        return this.jTable.getSelectedRow() >= 0;
    }

    public final ListSelection getSelection() {
        return this.state;
    }

    public final ListSQLLine getLine(int viewIndex) {
        return ITableModel.getLine(this.getJTable().getModel(), viewIndex);
    }

    private SQLRow getRow(int id) {
        if (id < 0) {
            return null;
        }
        return this.getSource().getPrimaryTable().getRow(id);
    }

    public SQLRow getSelectedRow() {
        return this.getRow(this.getSelectedId());
    }

    public final SQLRow getDesiredRow() {
        return this.getRow(this.getSelection().getUserSelectedID());
    }

    public final List<SQLRowAccessor> getSelectedRows() {
        ListSelectionModel selectionModel = this.getJTable().getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return Collections.emptyList();
        }
        int start = selectionModel.getMinSelectionIndex();
        int stop = selectionModel.getMaxSelectionIndex();
        ArrayList<SQLRowAccessor> res = new ArrayList<SQLRowAccessor>();
        int i = start;
        while (i <= stop) {
            if (selectionModel.isSelectedIndex(i)) {
                res.add(new SQLImmutableRowValues(this.getLine(i).getRow()));
            }
            ++i;
        }
        return res;
    }

    public final void setAdjustVisible(boolean b) {
        this.adjustVisible = b;
    }

    protected final void toggleAutoAdjust() {
        if (this.tcsa == null) {
            this.tcsa = new ColumnSizeAdjustor(this.jTable);
        } else {
            this.tcsa.setInstalled(!this.tcsa.isInstalled());
        }
    }

    public final boolean isAutoAdjusting() {
        if (this.tcsa == null) {
            return false;
        }
        return this.tcsa.isInstalled();
    }

    public void addIListener(IListener l) {
        this.listeners.add(l);
    }

    public void addNonAdjustingIListener(IListener l) {
        this.naListeners.add(l);
    }

    public void addListener(TableModelListener l) {
        this.jTable.getModel().addTableModelListener(l);
    }

    public void addSortListener(PropertyChangeListener l) {
        this.sorter.addPropertyChangeListener(new PropertyChangeListenerProxy("sorting", l));
    }

    public boolean isSorted() {
        return this.sorter.isSorting();
    }

    private void fireSelectionId(int id, int selectedColumn) {
        for (IListener l : this.listeners) {
            l.selectionId(id, selectedColumn);
        }
    }

    protected final void fireNASelectionId() {
        int id = this.getSelectedId();
        for (IListener l : this.naListeners) {
            l.selectionId(id, -1);
        }
    }

    public final void addModelListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("model", l);
    }

    public final void rmModelListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("model", l);
    }

    public final void addListenerOnModel(PropertyChangeListener l) {
        this.modelPCListeners.add(l);
        if (this.getModel() != null) {
            this.getModel().addPropertyChangeListener(l);
        }
    }

    public final void rmListenerOnModel(PropertyChangeListener l) {
        this.modelPCListeners.remove(l);
        if (this.getModel() != null) {
            this.getModel().rmPropertyChangeListener(l);
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        assert (event.getAncestor().isVisible());
        this.getModel().setSleeping(false);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        assert (!event.getAncestor().isVisible() || !event.getAncestor().isDisplayable());
        if (!this.isDead()) {
            this.getModel().setSleeping(true);
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    public void setSQLEditable(boolean b) {
        this.getModel().setEditable(b);
    }

    public ITableModel getModel() {
        return (ITableModel)this.getTableModel();
    }

    public TableModel getTableModel() {
        return this.sorter.getTableModel();
    }

    private final void setTableModel(ITableModel t) {
        ITableModel old = this.getModel();
        if (t == old) {
            return;
        }
        if (old != null) {
            for (PropertyChangeListener l : this.modelPCListeners) {
                old.rmPropertyChangeListener(l);
            }
            if (this.hasRequest()) {
                this.getRequest().rmWhereListener(this.filterListener);
            }
        }
        this.sorter.setTableModel(t);
        if (t != null) {
            for (PropertyChangeListener l : this.modelPCListeners) {
                t.addPropertyChangeListener(l);
                l.propertyChange(new PropertyChangeEvent(t, null, null, null));
            }
            if (this.hasRequest()) {
                this.getRequest().addWhereListener(this.filterListener);
                this.filterListener.propertyChange(null);
            }
        }
        this.supp.firePropertyChange("model", old, t);
    }

    private void updateCols(int index) {
        TableColumnModel columnModel = this.jTable.getColumnModel();
        int start = index < 0 ? 0 : index;
        int stop = index < 0 ? columnModel.getColumnCount() : index + 1;
        int i = start;
        while (i < stop) {
            TableColumn col = columnModel.getColumn(i);
            SQLTableModelColumn srcCol = this.getSource().getColumn(i);
            srcCol.install(col);
            if (FORCE_ALT_CELL_RENDERER) {
                AlternateTableCellRenderer.setRendererAndListen(col);
            } else {
                AlternateTableCellRenderer.setRenderer(col);
            }
            ++i;
        }
    }

    public final boolean hasRequest() {
        return this.getSource() instanceof SQLTableModelSourceOnline;
    }

    public final ListSQLRequest getRequest() {
        return ((SQLTableModelSourceOnline)this.getSource()).getReq();
    }

    public final void setRequest(ListSQLRequest listReq) {
        this.setSource(new SQLTableModelSourceOnline(listReq));
    }

    public final void setSource(SQLTableModelSource src) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (this.src == src) {
            return;
        }
        this.src = src;
        this.setTableModel(new ITableModel(src));
    }

    public final SQLTableModelSource getSource() {
        ITableModel m = this.getModel();
        return m == null ? null : m.getReq();
    }

    public final File getConfigFile() {
        return this.tableStateManager == null ? null : this.tableStateManager.getConfigFile();
    }

    public final void setConfigFile(File configFile) {
        File oldFile = this.getConfigFile();
        if (!CompareUtils.equals(oldFile, configFile)) {
            if (configFile == null) {
                this.tableStateManager.endAutoSave();
            }
            this.tableStateManager.setConfigFile(configFile);
            if (oldFile == null) {
                this.tableStateManager.beginAutoSave();
            }
            this.loadTableState();
        }
    }

    private void loadTableState() {
        if (this.getConfigFile() != null) {
            this.tableStateManager.loadState();
        }
    }

    private final void dispChanged() {
        boolean requiredToLive;
        boolean bl = requiredToLive = this.isDisplayable() || this.retainCount > 0;
        if (!requiredToLive && !this.isDead()) {
            this.setTableModel(null);
        } else if (requiredToLive && this.isDead()) {
            this.setTableModel(new ITableModel(this.src));
        }
    }

    public final void retain() {
        ++this.retainCount;
        this.dispChanged();
    }

    public final void release() {
        if (this.retainCount == 0) {
            throw new IllegalStateException("Unbalanced release");
        }
        --this.retainCount;
        this.dispChanged();
    }

    public JTable getJTable() {
        return this.jTable;
    }

    @Override
    public void grabFocus() {
        this.jTable.grabFocus();
    }

    private abstract class FilterWorker
    extends SwingWorker<String, Object> {
        private FilterWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void done() {
            if (!this.isCancelled()) {
                try {
                    IListe.this.setFilter((String)this.get());
                }
                catch (Exception e) {
                    if (e instanceof ExecutionException && ((ExecutionException)e).getCause() instanceof InterruptedException) {
                        String msg = this.getClass() + " interruped";
                        Log.get().fine(msg);
                        IListe.this.setFilter(msg);
                    }
                    e.printStackTrace();
                    IListe.this.setFilter(e.getLocalizedMessage());
                }
                IListe iListe = IListe.this;
                synchronized (iListe) {
                    if (IListe.this.filterWorker == this) {
                        IListe.this.filterWorker = null;
                    }
                }
            }
        }
    }

    private static final class FormatRenderer
    extends DefaultTableCellRenderer {
        private final Format fmt;

        private FormatRenderer(Format fmt) {
            this.fmt = fmt;
        }

        @Override
        protected void setValue(Object value) {
            this.setText(value == null ? "" : this.fmt.format(value));
        }
    }

    private final class RowFilterWorker
    extends FilterWorker {
        private final Collection<SQLRow> rows;

        private RowFilterWorker(Collection<SQLRow> r) {
            this.rows = r;
        }

        @Override
        protected String doInBackground() throws InterruptedException {
            if (this.getRows() == null) {
                return null;
            }
            Thread.sleep(60L);
            ArrayList<String> ancestors = new ArrayList<String>();
            SQLElementDirectory dir = Configuration.getInstance().getDirectory();
            Tuple2<SQLRow, String> parentAndDesc = this.getParent(this.getRows(), dir);
            ancestors.add(parentAndDesc.get1());
            SQLRow current = parentAndDesc.get0();
            while (current != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                SQLElement elem = dir.getElement(current.getTable());
                ancestors.add(0, elem.getDescription(current));
                current = elem.getParent(current);
            }
            return CollectionUtils.join(ancestors, IListe.SEP);
        }

        private Tuple2<SQLRow, String> getParent(Collection<SQLRow> rows, SQLElementDirectory dir) throws InterruptedException {
            SQLRow parent = null;
            boolean sameParent = true;
            ArrayList<String> desc = new ArrayList<String>(rows.size());
            for (SQLRow current : rows) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                SQLElement elem = dir.getElement(current.getTable());
                if (parent == null || sameParent) {
                    SQLRow currentParent = elem.getParent(current);
                    if (parent == null) {
                        parent = currentParent;
                    } else if (!parent.equals(currentParent)) {
                        sameParent = false;
                    }
                }
                desc.add(elem.getDescription(current));
            }
            return Tuple2.create(sameParent ? parent : null, CollectionUtils.join(desc, " \u25cf"));
        }

        private final Collection<SQLRow> getRows() {
            return this.rows;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " on " + this.getRows();
        }
    }

    private final class WhereFilterWorker
    extends FilterWorker {
        private final Where w;

        private WhereFilterWorker(Where r) {
            this.w = r;
        }

        @Override
        protected String doInBackground() throws InterruptedException {
            return this.w == null ? "No where" : this.w.getClause();
        }
    }
}

