/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListener;
import org.openconcerto.ui.state.WindowStateManager;
import org.openconcerto.utils.doc.Documented;

public class EditFrame
extends JFrame
implements IListener,
EditPanelListener,
Documented {
    public static final EditPanel.EditMode MODIFICATION = EditPanel.MODIFICATION;
    public static final EditPanel.EditMode CREATION = EditPanel.CREATION;
    public static final String SMALL_MIN_SIZE = "org.openconcerto.sql.editFrame.smallMinSize";
    private boolean frameResize = false;
    private final EditPanel panel;
    private boolean wasFilled;

    public EditFrame(SQLElement e) {
        this(e, EditPanel.CREATION);
    }

    public EditFrame(SQLElement e, EditPanel.EditMode mode) {
        this(e.createDefaultComponent(), mode);
    }

    public EditFrame(SQLComponent comp, EditPanel.EditMode mode) {
        int wantedH;
        int wantedW;
        this.panel = new EditPanel(comp, mode);
        final PropertyChangeListener fillingL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EditFrame.this.wasFilled = true;
            }
        };
        this.getSQLComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) != 0L) {
                    boolean isDesc;
                    boolean bl = isDesc = SwingUtilities.getAncestorOfClass(EditFrame.this.getClass(), e.getComponent()) != null;
                    if (isDesc) {
                        ((BaseSQLComponent)EditFrame.this.getSQLComponent()).addFillingListener(fillingL);
                    } else {
                        ((BaseSQLComponent)EditFrame.this.getSQLComponent()).rmFillingListener(fillingL);
                    }
                }
            }
        });
        this.setContentPane(this.panel);
        this.initTitle(comp.getElement(), mode);
        this.setLocation(0, 50);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (Boolean.getBoolean(SMALL_MIN_SIZE)) {
            Dimension minimumSize = this.getMinimumSize();
            wantedW = minimumSize.width;
            wantedH = minimumSize.height;
        } else {
            wantedW = this.getWidth();
            wantedH = this.getHeight();
        }
        int w = Math.min(d.width - 100, wantedW);
        int h = Math.min(d.height - 100, wantedH);
        this.setMinimumSize(new Dimension(w, h));
        this.viewResized();
        this.addEditPanelListener(this);
        if (mode == CREATION) {
            this.wasFilled = false;
            this.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) != 0L) {
                        if (!e.getComponent().isVisible()) {
                            if (EditFrame.this.getPanel().getSQLComponent().getResetMode().isOnHide()) {
                                EditFrame.this.getPanel().resetValue();
                            }
                            EditFrame.this.wasFilled = false;
                        } else if (!EditFrame.this.wasFilled && EditFrame.this.getPanel().getSQLComponent().getResetMode().isOnShow()) {
                            EditFrame.this.getPanel().resetValue();
                        }
                    }
                }
            });
        }
        this.panel.addComponentListenerOnViewPort(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                EditFrame.this.viewResized();
            }
        });
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                EditFrame.this.setFrameResize(true);
            }
        });
        this.setDefaultCloseOperation(2);
        new WindowStateManager(this, IListFrame.getConfigFile(this.getPanel().getSQLComponent(), this.getClass())).loadState();
    }

    private final void initTitle(SQLElement element, EditPanel.EditMode mode) {
        switch (mode) {
            case CREATION: {
                this.setTitle("Cr\u00e9er " + element.getSingularName());
                break;
            }
            case MODIFICATION: {
                this.setTitle("Modifier " + element.getSingularName());
                break;
            }
            case READONLY: {
                this.setTitle("D\u00e9tail d'" + element.getSingularName());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode : " + (Object)((Object)mode));
            }
        }
    }

    protected void viewResized() {
        if (!this.frameResize) {
            this.setSize(this.getPanel().getViewResizedDimesion(this.getSize()));
        }
        this.setFrameResize(false);
    }

    protected void setFrameResize(boolean b) {
        this.frameResize = b;
    }

    public void addEditPanelListener(EditPanelListener listener) {
        this.getPanel().addEditPanelListener(listener);
    }

    @Override
    public void cancelled() {
        this.close();
    }

    @Override
    public void deleted() {
        this.close();
    }

    @Override
    public void inserted(int id) {
        if (!this.getPanel().alwaysVisible()) {
            this.close();
        }
    }

    @Override
    public void modified() {
        this.close();
    }

    private void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    @Override
    @Deprecated
    public void selectionId(int selectedId, int i) {
        this.getPanel().selectionId(selectedId, i);
    }

    public void selectionId(int selectedId) {
        this.getPanel().selectionId(selectedId, 0);
    }

    public SQLComponent getSQLComponent() {
        return this.getPanel().getSQLComponent();
    }

    public EditPanel getPanel() {
        return this.panel;
    }

    @Override
    public String getDocId() {
        return "EditFrame" + this.panel.getDocId();
    }

    @Override
    public String getGenericDoc() {
        return "La fermeture de la fen\u00eatre annule l'action en cours";
    }

    @Override
    public boolean onScreen() {
        return false;
    }

    @Override
    public boolean isDocTransversable() {
        return true;
    }
}

