/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.utils.CollectionUtils;

public final class SQLCreateRoot {
    private final SQLSyntax syntax;
    private String name;
    private final List<String> clauses;
    private final List<SQLCreateTableBase<?>> tables;

    public SQLCreateRoot(SQLSyntax syntax, String name) {
        this.syntax = syntax;
        this.name = name;
        this.tables = new ArrayList();
        this.clauses = new ArrayList<String>();
    }

    public final SQLSyntax getSyntax() {
        return this.syntax;
    }

    public final SQLCreateRoot addTable(SQLCreateTableBase<?> t) {
        this.tables.add(t);
        return this;
    }

    public final SQLCreateRoot addClause(String s) {
        this.clauses.add(s);
        return this;
    }

    public String asString() {
        return this.asString(this.getName());
    }

    public final String asString(String r) {
        return this.asString(r, true, true);
    }

    public String asString(boolean drop, boolean create) {
        return this.asString(this.getName(), drop, create);
    }

    public String asString(String r, boolean drop, boolean create) {
        String rootName = r == null ? this.getName() : r;
        ArrayList<String> genClauses = new ArrayList<String>(this.clauses);
        if (create) {
            genClauses.add(0, this.getSyntax().getCreateRoot(rootName));
        }
        if (drop) {
            genClauses.add(0, this.getSyntax().getDropRoot(rootName));
        }
        genClauses.addAll(ChangeTable.cat(this.tables, rootName));
        genClauses.add(this.getSyntax().getInitRoot(rootName));
        return CollectionUtils.join(genClauses, "\n");
    }

    public final String toString() {
        return this.asString(null);
    }

    public final String getName() {
        return this.name;
    }

    public final SQLCreateRoot setName(String name) {
        this.name = name;
        return this;
    }
}

