/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.changer.Change;
import org.openconcerto.sql.changer.Correct;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeBase;
import org.openconcerto.utils.CollectionUtils;

public class CorrectBase
extends ChangeBase {
    public void restoreIntegrity(boolean existant, int modus) {
        for (String table : this.getBase().getTableNames()) {
            this.restoreIntegrity(existant, modus, table);
        }
    }

    public void restoreIntegrity(boolean inexistant, int modus, String table) {
        System.out.println("*** " + table);
        Iterator<Object> li = this.getBase().getTable(table).checkIntegrity().iterator();
        while (li.hasNext()) {
            SQLRow row = (SQLRow)li.next();
            SQLField foreignKey = (SQLField)li.next();
            SQLRow pb = (SQLRow)li.next();
            if (inexistant && pb.exists()) continue;
            String where = String.valueOf(row.getTable().getKey().getName()) + "=" + row.getID();
            String update = modus == 2 ? "DELETE FROM " + row.getTable().getName() + " WHERE " + where : (modus == 1 ? "UPDATE " + row.getTable().getName() + " SET " + foreignKey.getName() + "=1 WHERE " + where : "UPDATE " + row.getTable().getName() + " SET ARCHIVE=1 WHERE " + where);
            System.out.println(update);
            this.getBase().getDataSource().execute(update);
        }
    }

    public void correctPoint2NonExistant() {
        this.restoreIntegrity(true, 1);
    }

    public void deletePoint2NonExistant() {
        this.restoreIntegrity(true, 2);
    }

    public void correctSharedPrivates() {
        SQLElementDirectory dir = Configuration.getInstance().getDirectory();
        for (SQLTable table : dir.getTables()) {
            SQLElement element = dir.getElement(table);
            System.err.println(table);
            for (String f : element.getPrivateForeignFields()) {
                SQLElement foreignElement = element.getPrivateElement(f);
                String sel = "SELECT " + f + ", ARCHIVE FROM " + element.getTable().getName() + " WHERE ARCHIVE=0" + " GROUP BY " + f;
                sel = String.valueOf(sel) + " HAVING count(" + f + ") > 1 and " + f + "!= " + foreignElement.getTable().getUndefinedID();
                List sharedPrivateIDs = this.getBase().getDataSource().executeCol(sel);
                if (sharedPrivateIDs.size() <= 0) continue;
                System.err.println(sharedPrivateIDs);
                for (Number sharedPrivateID : sharedPrivateIDs) {
                    SQLRow foreignRow = foreignElement.getTable().getRow(sharedPrivateID.intValue());
                    Collection invalidRows = foreignRow.getReferentRows(element.getTable().getField(f));
                    ListIterator invalidRowsIter = invalidRows.listIterator(1);
                    while (invalidRowsIter.hasNext()) {
                        SQLRow invalidR = (SQLRow)invalidRowsIter.next();
                        try {
                            SQLRow clone = foreignElement.copy(foreignRow);
                            System.err.println("Updating " + invalidR + " by putting " + clone.getID() + " in " + f);
                            SQLRowValues vals = invalidR.createEmptyUpdateRow().put(f, clone.getID());
                            vals.update();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public void deleteArchived() throws SQLException {
        for (SQLTable t : this.getBase().getTables()) {
            if (!t.isArchivable()) continue;
            System.out.println("*** " + t);
            this.getBase().getDataSource().execute("DELETE FROM " + t.getName() + " where ARCHIVE=1");
        }
    }

    public void standardizeKeys() throws SQLException {
        this.getBase().getDataSource().getConnection().setAutoCommit(false);
        for (SQLTable t : this.getBase().getTables()) {
            if (!t.isRowable()) continue;
            ArrayList<String> statements = new ArrayList<String>();
            statements.add("SET FOREIGN_KEY_CHECKS=0");
            HashSet<SQLField> keys = new HashSet<SQLField>(this.getBase().getGraph().getReferentKeys(t));
            keys.add(t.getKey());
            for (SQLField refKey : keys) {
                String alter = "ALTER TABLE \"" + refKey.getTable().getName();
                if (refKey != t.getKey()) {
                    alter = String.valueOf(alter) + "\" MODIFY COLUMN \"" + refKey.getName() + "\" " + this.getSyntax().getIDType();
                    alter = String.valueOf(alter) + " DEFAULT " + refKey.getDefaultValue();
                } else {
                    alter = String.valueOf(alter) + "\" MODIFY COLUMN \"" + refKey.getName() + "\" " + this.getSyntax().getPrimaryIDDefinitionShort();
                }
                statements.add(alter);
            }
            statements.add("SET FOREIGN_KEY_CHECKS=1");
            System.err.println(CollectionUtils.join(statements, " ; "));
            this.getBase().getDataSource().execute(CollectionUtils.join(statements, " ; "));
            this.getBase().getDataSource().getConnection().commit();
        }
        System.err.println("Done.");
    }

    public CorrectBase(DBRoot root) {
        super(root);
    }

    public CorrectBase() throws IOException {
    }

    @Override
    protected Change getChange() {
        return new Correct(this.getRoot());
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("usage: " + CorrectBase.class.getName() + " method...");
            System.exit(0);
        }
        CorrectBase conv = new CorrectBase();
        conv.call(args);
    }
}

