/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.JListSQLTablePanel;
import org.openconcerto.sql.users.rights.UserRightsManagerModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;

public class UserRightsManagerPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JListSQLTablePanel list;
    SQLTable table = Configuration.getInstance().getRoot().findTable("USER_COMMON");
    JButton buttonApply;
    JButton buttonClose;
    JButton buttonRevert;
    final UserRightsManagerModel model = new UserRightsManagerModel();
    final JTable tableDroits = new JTable(this.model);
    ITextArea infos = new ITextArea();

    public UserRightsManagerPanel() {
        super(new GridBagLayout());
        JPanel listePanel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 0;
        listePanel.add((Component)new JLabel("Liste des utilisateurs"), c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.fill = 1;
        this.list = new JListSQLTablePanel(this.table, Arrays.asList("NOM", "PRENOM"), "Droits par d\u00e9faut");
        listePanel.add((Component)this.list, c);
        JPanel panelDroits = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridwidth = 0;
        panelDroits.add((Component)new JLabel("Droits"), c2);
        ++c2.gridy;
        c2.weightx = 1.0;
        c2.weighty = 0.7;
        c2.fill = 1;
        this.tableDroits.getTableHeader().setReorderingAllowed(false);
        this.tableDroits.getColumnModel().getColumn(0).setResizable(false);
        this.tableDroits.getColumnModel().getColumn(0).setMaxWidth(40);
        this.tableDroits.getColumnModel().getColumn(0).setWidth(40);
        this.tableDroits.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                UserRightsManagerPanel.this.tableDroits.getColumnModel().getColumn(0).setResizable(false);
                UserRightsManagerPanel.this.tableDroits.getColumnModel().getColumn(0).setMaxWidth(40);
                UserRightsManagerPanel.this.tableDroits.getColumnModel().getColumn(0).setWidth(40);
                UserRightsManagerPanel.this.buttonRevert.setEnabled(true);
                UserRightsManagerPanel.this.buttonApply.setEnabled(true);
            }
        });
        panelDroits.add((Component)new JScrollPane(this.tableDroits), c2);
        ++c2.gridy;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        panelDroits.add((Component)new JLabel("Informations"), c2);
        c2.weightx = 1.0;
        c2.weighty = 0.3;
        ++c2.gridy;
        this.infos.setEditable(false);
        panelDroits.add((Component)this.infos, c2);
        JPanel panelButton = new JPanel();
        this.buttonApply = new JButton("Appliquer");
        panelButton.add(this.buttonApply);
        this.buttonRevert = new JButton("Annuler");
        panelButton.add(this.buttonRevert);
        this.buttonClose = new JButton("Fermer");
        panelButton.add(this.buttonClose);
        ++c2.gridy;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        c2.fill = 0;
        c2.gridwidth = 1;
        c2.anchor = 13;
        panelDroits.add((Component)panelButton, c2);
        this.buttonClose.addActionListener(this);
        this.buttonApply.addActionListener(this);
        this.buttonRevert.addActionListener(this);
        JSplitPane pane = new JSplitPane(1, listePanel, panelDroits);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.weightx = 1.0;
        c3.weighty = 1.0;
        c3.fill = 1;
        this.add((Component)pane, c3);
        this.list.addListSelectionListener(this);
        this.tableDroits.getSelectionModel().addListSelectionListener(this);
        this.tableDroits.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(new AbstractAction("Tout cocher"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = 0;
                            while (i < (this).UserRightsManagerPanel.this.tableDroits.getRowCount()) {
                                (this).UserRightsManagerPanel.this.model.setValueAt(Boolean.TRUE, i, 0);
                                ++i;
                            }
                            (this).UserRightsManagerPanel.this.model.fireTableDataChanged();
                        }
                    });
                    menu.add(new AbstractAction("Tout d\u00e9cocher"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = 0;
                            while (i < (this).UserRightsManagerPanel.this.tableDroits.getRowCount()) {
                                (this).UserRightsManagerPanel.this.model.setValueAt(Boolean.FALSE, i, 0);
                                ++i;
                            }
                            (this).UserRightsManagerPanel.this.model.fireTableDataChanged();
                        }
                    });
                    final int[] selectedRows = UserRightsManagerPanel.this.tableDroits.getSelectedRows();
                    if (selectedRows.length > 0) {
                        menu.add(new AbstractAction("Cocher la s\u00e9lection"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int[] nArray = selectedRows;
                                int n = selectedRows.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int i = nArray[n2];
                                    (this).UserRightsManagerPanel.this.model.setValueAt(Boolean.TRUE, i, 0);
                                    ++n2;
                                }
                                (this).UserRightsManagerPanel.this.model.fireTableDataChanged();
                            }
                        });
                        menu.add(new AbstractAction("D\u00e9cocher la s\u00e9lection"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int[] nArray = selectedRows;
                                int n = selectedRows.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int i = nArray[n2];
                                    (this).UserRightsManagerPanel.this.model.setValueAt(Boolean.FALSE, i, 0);
                                    ++n2;
                                }
                                (this).UserRightsManagerPanel.this.model.fireTableDataChanged();
                            }
                        });
                    }
                    menu.pack();
                    menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
                    menu.setVisible(true);
                }
            }
        });
        this.buttonRevert.setEnabled(false);
        this.buttonApply.setEnabled(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.tableDroits.getSelectionModel()) {
            if (this.tableDroits.getSelectedRow() >= 0) {
                SQLRowValues rowVals = this.model.getRowValuesAt(this.tableDroits.getSelectedRow());
                this.infos.setText(rowVals.getString("DESCRIPTION"));
            } else {
                this.infos.setText("");
            }
        } else if (e.getSource() == this.list.getJList()) {
            boolean b;
            int selectedIndex = this.list.getSelectedIndex();
            boolean bl = b = selectedIndex >= 0;
            if (b) {
                this.model.loadRightsForUser(this.list.getModel().getRowAt(selectedIndex).getID());
            } else {
                this.model.loadRightsForUser(-1);
            }
            this.buttonRevert.setEnabled(false);
            this.buttonApply.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonApply) {
            this.model.commitData();
            this.buttonRevert.setEnabled(false);
            this.buttonApply.setEnabled(false);
        } else if (e.getSource() == this.buttonClose) {
            ((JFrame)SwingUtilities.getRoot(this)).dispose();
        } else if (e.getSource() == this.buttonRevert) {
            int selectedIndex = this.list.getSelectedIndex();
            if (selectedIndex >= 0) {
                this.model.loadRightsForUser(this.list.getModel().getRowAt(selectedIndex).getID());
            } else {
                this.model.loadRightsForUser(-1);
            }
            this.buttonRevert.setEnabled(false);
            this.buttonApply.setEnabled(false);
        }
    }
}

