/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.IListButton;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.cc.ITransformer;

public class ElementComboBox
extends SQLRequestComboBox
implements ActionListener {
    public static final String CAN_MODIFY = "org.openconcerto.sql.comboCanModify";
    private static ImageIcon icon = null;
    private static ImageIcon iconModif = null;
    private static ImageIcon iconAdd = null;
    private static ITransformer<ElementComboBox, Boolean> globalRowDisplayer = null;
    private SQLElement element;
    private Boolean canModif = null;
    private Boolean isModif = null;
    private final JButton viewButton = new JButton();
    private final IListButton listButton = new IListButton();
    private final JButton addButton = new JButton();
    private IListFrame listFrame = null;
    private EditFrame viewFrame = null;
    private EditFrame addFrame = null;
    private boolean minimal = false;

    private static void checkLoaded() {
        if (icon == null) {
            icon = new ImageIcon(ElementComboBox.class.getResource("loupe.png"));
            iconAdd = new ImageIcon(ElementComboBox.class.getResource("plus.png"));
            iconModif = new ImageIcon(ElementComboBox.class.getResource("pen.png"));
        }
    }

    private static Icon getDetailsIcon() {
        ElementComboBox.checkLoaded();
        return icon;
    }

    private static Icon getModifIcon() {
        ElementComboBox.checkLoaded();
        return iconModif;
    }

    private static Icon getAddIcon() {
        ElementComboBox.checkLoaded();
        return iconAdd;
    }

    public static void setGlobalRowDisplayer(ITransformer<ElementComboBox, Boolean> transf) {
        globalRowDisplayer = transf;
    }

    public ElementComboBox() {
    }

    public ElementComboBox(boolean addUndefined) {
        super(addUndefined);
    }

    public ElementComboBox(boolean addUndefined, int preferredWidthInChar) {
        super(addUndefined, preferredWidthInChar);
    }

    public final ElementComboBox init(SQLElement element) {
        return this.init(element, element.getComboRequest());
    }

    public final ElementComboBox init(SQLElement element, ComboSQLRequest req) {
        if (element.getTable() != req.getPrimaryTable()) {
            throw new IllegalArgumentException("Tables are different " + element.getTable().getSQLName() + " != " + req.getPrimaryTable().getSQLName());
        }
        this.element = element;
        this.uiInit(req);
        return this;
    }

    @Override
    public void init(SQLRowItemView v) {
        SQLTable foreignTable = v.getField().getDBSystemRoot().getGraph().getForeignTable(v.getField());
        if (foreignTable == null) {
            throw new IllegalArgumentException("No foreign table for " + v.getField().getFullName());
        }
        if (this.getElement() == null) {
            this.init(Configuration.getInstance().getDirectory().getElement(foreignTable));
        } else if (this.getElement().getTable() != foreignTable) {
            throw new IllegalArgumentException("Tables are different " + this.getElement().getTable().getSQLName() + " != " + foreignTable.getSQLName());
        }
    }

    public final SQLElement getElement() {
        return this.element;
    }

    public final void setCanModify(boolean canModif) {
        if (this.canModif == null || this.canModif != canModif) {
            this.canModif = canModif;
            this.updateViewBtn();
        }
    }

    private final void setViewBtn(boolean modif) {
        if (this.isModif == null || this.isModif != modif) {
            this.isModif = modif;
            this.viewFrame = null;
            if (this.isModif.booleanValue()) {
                this.viewButton.setToolTipText("Modifier");
                this.viewButton.setIcon(ElementComboBox.getModifIcon());
            } else {
                this.viewButton.setToolTipText("Voir plus de d\u00e9tails");
                this.viewButton.setIcon(ElementComboBox.getDetailsIcon());
            }
            IListButton.initButton(this.viewButton);
        }
    }

    @Override
    protected void uiLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 2;
        c.weighty = 0.0;
        c.weightx = 1.0;
        this.combo.getActions().add(new AbstractAction("Tout afficher"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementComboBox.this.actionPerformed(e);
            }
        });
        this.add((Component)this.combo, c);
        if (!this.minimal) {
            c.weightx = 0.0;
            ++c.gridx;
            this.viewButton.setPreferredSize(new Dimension(24, 16));
            this.setCanModify(Boolean.getBoolean(CAN_MODIFY));
            DefaultGridBagConstraints.lockMinimumSize(this.viewButton);
            this.add((Component)this.viewButton, c);
            ++c.gridx;
            this.listButton.setToolTipText("Lister les " + this.element.getPluralName());
            DefaultGridBagConstraints.lockMinimumSize(this.listButton);
            this.add((Component)this.listButton, c);
            this.addButton.setPreferredSize(new Dimension(24, 16));
            this.addButton.setIcon(ElementComboBox.getAddIcon());
            IListButton.initButton(this.addButton);
            this.addButton.setToolTipText("Cr\u00e9er " + this.element.getSingularName());
            ++c.gridx;
            DefaultGridBagConstraints.lockMinimumSize(this.addButton);
            this.add((Component)this.addButton, c);
            this.addButton.addActionListener(this);
            this.setAddIconVisible(Boolean.getBoolean("org.openconcerto.ui.addComboButton"));
            this.viewButton.addActionListener(this);
            this.listButton.addActionListener(this);
            this.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!ElementComboBox.this.isUpdating()) {
                        ElementComboBox.this.valueChanged();
                    }
                }
            });
            if (Boolean.getBoolean("org.openconcerto.ui.simpleTraversal")) {
                this.viewButton.setFocusable(false);
                this.listButton.setFocusable(false);
                this.addButton.setFocusable(false);
            }
        } else {
            this.setCanModify(false);
        }
        assert (this.canModif != null && this.isModif != null) : "Modif booleans not initialized, this.canModif: " + this.canModif + ", this.isModif: " + this.isModif;
    }

    private void valueChanged() {
        this.updateViewBtn();
        if (this.viewFrame != null) {
            this.viewFrame.selectionId(this.getSelectedId());
        }
        if (this.listFrame != null) {
            this.listFrame.getPanel().getListe().selectID(this.getSelectedId());
        }
    }

    private final boolean displayRow() {
        if (globalRowDisplayer == null) {
            return false;
        }
        return globalRowDisplayer.transformChecked(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.viewButton) {
            boolean displayed = (e.getModifiers() & 1) != 0 ? this.displayRow() : false;
            if (!displayed) {
                if (this.viewFrame == null) {
                    this.viewFrame = new EditFrame(this.element, this.isModif != false ? EditPanel.MODIFICATION : EditPanel.READONLY);
                    this.viewFrame.setDefaultCloseOperation(2);
                }
                this.viewFrame.selectionId(this.getSelectedId());
                FrameUtil.show(this.viewFrame);
            }
        } else if (e.getSource() == this.addButton) {
            FrameUtil.show(this.getAddFrame());
        } else if (e.getSource() == this.listButton || e.getSource() == this.combo) {
            if (this.listFrame == null) {
                this.listFrame = new IListFrame(new ListeAddPanel(this.element));
                this.listFrame.getPanel().getListe().getSelection().addPropertyChangeListener("userSelectedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        int newID = ((Number)evt.getNewValue()).intValue();
                        ElementComboBox.this.setValue(newID == -1 ? null : Integer.valueOf(newID));
                    }
                });
                this.listFrame.getPanel().getListe().selectID(this.getSelectedId());
            }
            FrameUtil.show(this.listFrame);
        }
    }

    private final EditFrame getAddFrame() {
        if (this.addFrame == null) {
            this.addFrame = new EditFrame(this.element, EditPanel.CREATION);
            this.addFrame.addEditPanelListener(new EditPanelListener(){

                @Override
                public void cancelled() {
                }

                @Override
                public void deleted() {
                }

                @Override
                public void inserted(int mid) {
                    ElementComboBox.this.setValue(mid);
                }

                @Override
                public void modified() {
                }
            });
        }
        return this.addFrame;
    }

    public final SQLComponent getAddComp() {
        return this.getAddFrame().getSQLComponent();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.element;
    }

    @Override
    protected void modeChanged(SQLRequestComboBox.ComboMode mode) {
        super.modeChanged(mode);
        this.updateViewBtn();
        this.listButton.setEnabled(mode == SQLRequestComboBox.ComboMode.EDITABLE);
        this.addButton.setEnabled(mode == SQLRequestComboBox.ComboMode.EDITABLE);
    }

    private void updateViewBtn() {
        boolean enabled;
        boolean modif;
        if (this.getEnabled() == SQLRequestComboBox.ComboMode.DISABLED || this.getSelectedId() < 0) {
            modif = this.canModif;
            enabled = false;
        } else if (this.canModif.booleanValue() && this.getEnabled() == SQLRequestComboBox.ComboMode.EDITABLE) {
            modif = true;
            enabled = true;
        } else {
            modif = false;
            enabled = true;
        }
        this.setViewBtn(modif);
        this.viewButton.setEnabled(enabled);
    }

    public void setMinimal() {
        this.minimal = true;
    }

    public void setInfoIconVisible(boolean b) {
        this.viewButton.setVisible(b);
    }

    public void setListIconVisible(boolean b) {
        this.listButton.setVisible(b);
    }

    public void setAddIconVisible(boolean b) {
        this.addButton.setVisible(b);
    }

    public void setButtonsVisible(boolean b) {
        this.setInfoIconVisible(b);
        this.setListIconVisible(b);
        this.setAddIconVisible(b);
    }
}

