/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.dbutils.ResultSetHandler;
import org.jdom.Element;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.Constraint;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.JDBCStructureSource;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLIdentifier;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.SystemQueryExecutor;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateMoveableTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.xml.JDOMUtils;

public final class SQLTable
extends SQLIdentifier
implements SQLData {
    public static final String UNDEFINED_ID_POLICY = "undefined ID policy";
    public static final String undefTable = "FWK_UNDEFINED_IDS";
    private static final Map<SQLSchema, Map<String, Number>> UNDEFINED_IDs = new HashMap<SQLSchema, Map<String, Number>>();
    private final ListOrderedMap fields;
    private final Set<SQLField> primaryKeys;
    private SQLField primaryKey = null;
    private boolean primaryKeyOK = true;
    private Set<SQLField> keys = null;
    private final Map<String, Trigger> triggers;
    private Set<Constraint> constraints;
    private List<SQLTableModifiedListener> tableModifiedListeners = Collections.emptyList();
    private Integer undefinedID = null;
    private String comment;
    private String type;
    private static final String orderField = "ORDRE";
    private static final String archiveField = "ARCHIVE";
    private static final ThreadLocal<LinkedList<Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent>>> events = new ThreadLocal<LinkedList<Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent>>>(){

        @Override
        protected LinkedList<Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent>> initialValue() {
            return new LinkedList<Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent>>();
        }
    };

    private static final Map<String, Number> getUndefIDs(final SQLSchema schema) {
        if (!UNDEFINED_IDs.containsKey(schema)) {
            Map r;
            if (schema.contains(undefTable)) {
                SQLBase b = schema.getBase();
                final SQLTable undefT = schema.getTable(undefTable);
                SQLSelect sel = new SQLSelect(b).addSelectStar(undefT);
                r = (Map)b.getDataSource().execute(sel.asString(), new ResultSetHandler(){

                    @Override
                    public Object handle(ResultSet rs) throws SQLException {
                        HashMap<String, Number> res = new HashMap<String, Number>();
                        while (rs.next()) {
                            res.put(rs.getString("TABLENAME"), (Number)rs.getObject("UNDEFINED_ID"));
                        }
                        return res;
                    }
                });
                undefT.addTableModifiedListener(new SQLTableModifiedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        Map map = UNDEFINED_IDs;
                        synchronized (map) {
                            UNDEFINED_IDs.remove(schema);
                            undefT.removeTableModifiedListener(this);
                        }
                    }
                });
            } else {
                r = Collections.emptyMap();
            }
            UNDEFINED_IDs.put(schema, r);
        }
        return UNDEFINED_IDs.get(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Number getUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            return SQLTable.getUndefIDs(b).get(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean containsUndefID(SQLSchema b, String tableName) {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            return SQLTable.getUndefIDs(b).containsKey(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setUndefID(SQLSchema schema, String tableName, Integer value) throws SQLException {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            boolean modified;
            SQLTable undefT = schema.getTable(undefTable);
            String sql = undefT.getField("UNDEFINED_ID").getType().toString(value);
            if (!SQLTable.containsUndefID(schema, tableName)) {
                SQLRowValues.insertCount(undefT, "(\"TABLENAME\", \"UNDEFINED_ID\") VALUES(" + schema.getBase().quoteString(tableName) + ", " + sql + ")");
                modified = true;
            } else if (!CompareUtils.equals(SQLTable.getUndefID(schema, tableName), value)) {
                UpdateBuilder update = new UpdateBuilder(undefT).set("UNDEFINED_ID", sql);
                update.setWhere(new Where((FieldRef)undefT.getField("TABLENAME"), "=", (Object)tableName));
                schema.getDBSystemRoot().getDataSource().execute(update.asString());
                modified = true;
            } else {
                modified = false;
            }
            if (modified) {
                schema.updateVersion();
                undefT.fireTableModified(-1);
            }
        }
    }

    private static ListOrderedMap createMap() {
        return (ListOrderedMap)ListOrderedMap.decorate(new CaseInsensitiveMap());
    }

    SQLTable(SQLSchema schema, String name) {
        super(schema, name);
        this.fields = SQLTable.createMap();
        this.primaryKeys = new LinkedHashSet<SQLField>();
        this.triggers = new HashMap<String, Trigger>();
        this.constraints = new HashSet<Constraint>();
    }

    void clearNonPersistent() {
        this.triggers.clear();
        this.constraints = new HashSet<Constraint>();
    }

    void loadFields(Element xml) {
        Element constraintsElem;
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        for (Element elementField : xml.getChildren("field")) {
            SQLField f = SQLField.create(this, elementField);
            newFields.put(f.getName(), f);
        }
        Element primary = xml.getChild("primary");
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        for (Element elementField : primary.getChildren("field")) {
            String fieldName = elementField.getAttributeValue("name");
            newPrimaryKeys.add(fieldName);
        }
        String undefAttr = xml.getAttributeValue("undefID");
        this.setState(newFields, newPrimaryKeys, undefAttr == null ? null : Integer.valueOf(undefAttr));
        Element triggersElem = xml.getChild("triggers");
        if (triggersElem != null) {
            for (Element triggerElem : triggersElem.getChildren()) {
                this.addTrigger(Trigger.fromXML(this, triggerElem));
            }
        }
        if ((constraintsElem = xml.getChild("constraints")) == null) {
            this.addConstraint((Constraint)null);
        } else {
            for (Element elem : constraintsElem.getChildren()) {
                this.addConstraint(Constraint.fromXML(this, elem));
            }
        }
        Element commentElem = xml.getChild("comment");
        if (commentElem != null) {
            this.setComment(commentElem.getText());
        }
        this.setType(xml.getAttributeValue("type"));
    }

    private void addTrigger(Trigger t) {
        this.triggers.put(t.getName(), t);
    }

    private void addConstraint(Constraint c) {
        if (c == null) {
            this.constraints = null;
        } else {
            if (this.constraints == null) {
                this.constraints = new HashSet<Constraint>();
            }
            this.constraints.add(c);
        }
    }

    public void fetchFields() throws SQLException {
        this.getBase().getDataSource().useConnection(new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                ResultSet rs = metaData.getColumns(SQLTable.this.getBase().getMDName(), SQLTable.this.getSchema().getName(), SQLTable.this.getName(), null);
                if (!rs.next()) {
                    SQLTable.this.emptyFields();
                } else {
                    SQLTable.this.fetchFields(metaData, rs);
                }
                ResultSet tableRS = metaData.getTables(SQLTable.this.getBase().getMDName(), SQLTable.this.getSchema().getName(), SQLTable.this.getName(), new String[]{"TABLE", "SYSTEM TABLE", "VIEW"});
                if (!tableRS.next()) {
                    SQLTable.this.setType(null);
                    SQLTable.this.setComment(null);
                } else {
                    SQLTable.this.setType(tableRS.getString("TABLE_TYPE"));
                    SQLTable.this.setComment(tableRS.getString("REMARKS"));
                }
                return null;
            }
        });
        this.clearNonPersistent();
        new JDBCStructureSource.TriggerQueryExecutor(null).apply(this);
        new JDBCStructureSource.ColumnsQueryExecutor(null).apply(this);
        try {
            new JDBCStructureSource.ConstraintsExecutor(null).apply(this);
        }
        catch (SystemQueryExecutor.QueryExn e) {
            e.printStackTrace();
            this.addConstraint((Constraint)null);
        }
        this.getDBSystemRoot().descendantsChanged(false);
        this.save();
    }

    boolean fetchFields(DatabaseMetaData metaData, ResultSet rs) throws SQLException {
        if (!this.isUs(rs)) {
            throw new IllegalStateException("rs current row does not describe " + this);
        }
        LinkedHashMap<String, SQLField> newFields = new LinkedHashMap<String, SQLField>();
        boolean hasNext = true;
        while (hasNext && this.isUs(rs)) {
            SQLField f = SQLField.create(this, rs);
            newFields.put(f.getName(), f);
            hasNext = rs.next();
        }
        ArrayList<String> newPrimaryKeys = new ArrayList<String>();
        ResultSet pkRS = metaData.getPrimaryKeys(this.getBase().getMDName(), this.getSchema().getName(), this.getName());
        while (pkRS.next()) {
            newPrimaryKeys.add(pkRS.getString("COLUMN_NAME"));
        }
        this.setState(newFields, newPrimaryKeys, null);
        return hasNext;
    }

    void emptyFields() {
        this.setState(new LinkedHashMap<String, SQLField>(), Collections.<String>emptyList(), null);
    }

    private boolean isUs(ResultSet rs) throws SQLException {
        String n = rs.getString("TABLE_NAME");
        String s = rs.getString("TABLE_SCHEM");
        return n.equals(this.getName()) && CompareUtils.equals(s, this.getSchema().getName());
    }

    void addTrigger(Map m) {
        this.addTrigger(new Trigger(this, m));
    }

    void addConstraint(Map<String, Object> m) {
        this.addConstraint(m == null ? null : new Constraint(this, m));
    }

    private int fetchUndefID() {
        Number id;
        int res = this.isRowable() ? (!SQLTable.containsUndefID(this.getSchema(), this.getName()) ? this.findMinID() : ((id = SQLTable.getUndefID(this.getSchema(), this.getName())) == null ? -1 : id.intValue())) : -1;
        return res;
    }

    private int findMinID() {
        String debugUndef = "fwk_sql.debug.undefined_id";
        if (System.getProperty("fwk_sql.debug.undefined_id") != null) {
            Log.get().warning("The system property 'fwk_sql.debug.undefined_id' is deprecated, use the 'undefined ID policy' metadata");
        }
        String policy = this.getSchema().getFwkMetadata(UNDEFINED_ID_POLICY);
        if (Boolean.getBoolean("fwk_sql.debug.undefined_id") || "min".equals(policy)) {
            SQLSelect sel = new SQLSelect(this.getBase(), true).addSelect(this.getKey(), "min");
            Number undef = (Number)this.getBase().getDataSource().executeScalar(sel.asString());
            if (undef == null) {
                throw new IllegalStateException(this + " is empty, can not infer UNDEFINED_ID");
            }
            String update = "INSERT into " + new SQLName(this.getDBRoot().getName(), undefTable) + " VALUES('" + this.getName() + "', " + undef + ");";
            Log.get().config("the first row (which should be the undefined):\n" + update);
            return undef.intValue();
        }
        if (policy != null && !"nonexistant".equals(policy)) {
            int res = Integer.parseInt(policy);
            if (res < 0) {
                throw new IllegalStateException("ID is not valid : " + res);
            }
            return res;
        }
        return -1;
    }

    void mutateTo(SQLTable table) {
        this.clearNonPersistent();
        this.setState(table.fields, table.getPKsNames(), table.undefinedID);
        this.triggers.putAll(table.triggers);
        if (table.constraints == null) {
            this.constraints = null;
        } else {
            this.constraints.addAll(table.constraints);
        }
        this.setType(table.getType());
        this.setComment(table.getComment());
    }

    private void setState(Map<String, SQLField> fields, List<String> primaryKeys, Integer undef) {
        if (!(fields instanceof LinkedHashMap) && !(fields instanceof OrderedMap)) {
            throw new IllegalArgumentException("fields is of class " + fields.getClass());
        }
        for (SQLField newField : fields.values()) {
            if (newField.getTable().getSQLName().equals(this.getSQLName())) continue;
            throw new IllegalArgumentException(newField + " is in table " + newField.getTable().getSQLName() + " not us: " + this.getSQLName());
        }
        CollectionChangeEventCreator c = this.createChildrenCreator();
        if (!fields.keySet().containsAll(this.getFieldsName())) {
            for (String removed : CollectionUtils.substract(this.getFieldsName(), fields.keySet())) {
                ((SQLField)this.fields.remove(removed)).dropped();
            }
        }
        for (SQLField newField : fields.values()) {
            if (this.getChildrenNames().contains(newField.getName())) {
                this.getField(newField.getName()).mutateTo(newField);
                continue;
            }
            SQLField fieldToAdd = newField.getTable() != this ? new SQLField(this, newField) : newField;
            this.fields.put(newField.getName(), fieldToAdd);
        }
        this.primaryKeys.clear();
        for (String pk : primaryKeys) {
            this.primaryKeys.add(this.getField(pk));
        }
        this.primaryKey = primaryKeys.size() == 1 ? this.getField(primaryKeys.get(0)) : null;
        this.primaryKeyOK = primaryKeys.size() <= 1;
        this.undefinedID = undef;
        this.fireChildrenChanged(c);
    }

    void setType(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    void setComment(String comm) {
        this.comment = comm;
    }

    public final String getComment() {
        return this.comment;
    }

    public final Trigger getTrigger(String name) {
        return this.triggers.get(name);
    }

    public final Map<String, Trigger> getTriggers() {
        return Collections.unmodifiableMap(this.triggers);
    }

    public final Set<Constraint> getAllConstraints() {
        return this.constraints == null ? null : Collections.unmodifiableSet(this.constraints);
    }

    public final Set<Constraint> getConstraints() {
        if (this.constraints == null) {
            return null;
        }
        HashSet<Constraint> res = new HashSet<Constraint>();
        for (Constraint c : this.constraints) {
            if (c.getType() == SQLSyntax.ConstraintType.FOREIGN_KEY || c.getType() == SQLSyntax.ConstraintType.PRIMARY_KEY) continue;
            res.add(c);
        }
        return res;
    }

    public final Constraint getConstraint(SQLSyntax.ConstraintType type, List<String> cols) {
        if (this.constraints == null) {
            return null;
        }
        for (Constraint c : this.constraints) {
            if (c.getType() != type || !c.getCols().equals(cols)) continue;
            return c;
        }
        return null;
    }

    public boolean isRowable() {
        return this.getPrimaryKeys().size() == 1 && Number.class.isAssignableFrom(this.getKey().getType().getJavaType());
    }

    public SQLSchema getSchema() {
        return (SQLSchema)this.getParent();
    }

    public SQLBase getBase() {
        return this.getSchema().getBase();
    }

    public SQLField getKey() {
        if (!this.primaryKeyOK) {
            throw new IllegalStateException(this + " has more than 1 primary key: " + this.getPrimaryKeys());
        }
        return this.primaryKey;
    }

    public Set<SQLField> getPrimaryKeys() {
        return Collections.unmodifiableSet(this.primaryKeys);
    }

    public Set<SQLField> getForeignKeys() {
        return this.getDBSystemRoot().getGraph().getForeignKeys(this);
    }

    public Set<String> getForeignKeysNames() {
        return DatabaseGraph.getNames(this.getDBSystemRoot().getGraph().getForeignLinks(this));
    }

    public Set<List<SQLField>> getForeignKeysFields() {
        return this.getDBSystemRoot().getGraph().getForeignKeysFields(this);
    }

    public Set<SQLField> getForeignKeys(String foreignTable) {
        return this.getForeignKeys(this.getTable(foreignTable));
    }

    public Set<SQLField> getForeignKeys(SQLTable foreignTable) {
        return this.getDBSystemRoot().getGraph().getForeignFields(this, foreignTable);
    }

    public SQLTable getForeignTable(String foreignField) {
        return this.getDBSystemRoot().getGraph().getForeignTable(this.getField(foreignField));
    }

    public SQLTable findReferentTable(String tableName) {
        return this.getDBSystemRoot().getGraph().findReferentTable(this, tableName, new String[0]);
    }

    public Set<SQLField> getKeys() {
        if (this.keys == null) {
            this.keys = this.getForeignKeys();
            this.keys.addAll(this.getPrimaryKeys());
        }
        return this.keys;
    }

    public String toString() {
        return "/" + this.getName() + "/";
    }

    public SQLField getField(String fieldName) {
        SQLField res = this.getFieldRaw(fieldName);
        if (res == null) {
            throw new IllegalArgumentException("unknown field " + fieldName + " in " + this.getName() + ". The table " + this.getName() + " contains the followins fields: " + this.fields.asList());
        }
        return res;
    }

    public SQLField getFieldRaw(String fieldName) {
        return (SQLField)this.fields.get(fieldName);
    }

    public Set<SQLField> getFields() {
        return new HashSet<SQLField>(this.fields.values());
    }

    public Set<SQLField> getContentFields() {
        return this.getContentFields(false);
    }

    public Set<SQLField> getContentFields(boolean includeMetadata) {
        Set<SQLField> res = this.getFields();
        res.removeAll(this.getPrimaryKeys());
        res.remove(this.getArchiveField());
        res.remove(this.getOrderField());
        if (!includeMetadata) {
            res.remove(this.getCreationDateField());
            res.remove(this.getCreationUserField());
            res.remove(this.getModifDateField());
            res.remove(this.getModifUserField());
        }
        return res;
    }

    public Set<SQLField> getLocalContentFields() {
        Set<SQLField> res = this.getContentFields();
        res.removeAll(this.getForeignKeys());
        return res;
    }

    public Set<String> getFieldsName() {
        return this.fields.keySet();
    }

    public List<SQLField> getOrderedFields() {
        return new ArrayList<SQLField>(this.fields.values());
    }

    @Override
    public SQLIdentifier getChild(String name) {
        return this.getField(name);
    }

    @Override
    public Set<String> getChildrenNames() {
        return this.getFieldsName();
    }

    public final SQLTable getTable(String name) {
        return this.getDesc(name, SQLTable.class);
    }

    public int getRowCount() {
        SQLSelect sel = new SQLSelect(this.getBase(), true).addSelectFunctionStar("count").addFrom(this);
        Number count = (Number)this.getBase().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        return count.intValue();
    }

    public BigDecimal getMaxOrder() {
        return this.getMaxOrder(true);
    }

    BigDecimal getMaxOrder(Boolean useCache) {
        if (!this.isOrdered()) {
            throw new IllegalStateException(this + " is not ordered");
        }
        SQLSelect sel = new SQLSelect(this.getBase(), true).addSelect(this.getOrderField(), "max");
        try {
            BigDecimal maxOrder = (BigDecimal)this.getBase().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, useCache));
            return maxOrder == null ? BigDecimal.ONE.negate() : maxOrder;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(this.getOrderField().getSQLName() + " must be " + SQLSyntax.get(this).getOrderDefinition(), e);
        }
    }

    public SQLRow getRow(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.exists() ? row : null;
    }

    private SQLRow getUncheckedRow(int ID) {
        return new SQLRow(this, ID);
    }

    public SQLRow getValidRow(int ID) {
        SQLRow row = this.getRow(ID);
        return row.isValid() ? row : null;
    }

    public SQLRow checkValidity(int ID) {
        SQLRow row = this.getUncheckedRow(ID);
        return row.isValid() ? null : row;
    }

    public List<Object> checkIntegrity() {
        final ArrayList<Object> inconsistencies = new ArrayList<Object>();
        if (!this.getKeys().isEmpty()) {
            SQLSelect sel = new SQLSelect(this.getBase());
            sel.setExcludeUndefined(false);
            sel.addAllSelect(this.getKeys());
            this.getBase().getDataSource().execute(sel.asString(), new ResultSetHandler(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    while (rs.next()) {
                        for (SQLField fk : SQLTable.this.getForeignKeys()) {
                            SQLRow pb = SQLTable.this.checkValidity(fk.getName(), rs.getInt(fk.getFullName()));
                            if (pb == null) continue;
                            inconsistencies.add(SQLTable.this.getRow(rs.getInt(SQLTable.this.getKey().getFullName())));
                            inconsistencies.add(fk);
                            inconsistencies.add(pb);
                        }
                    }
                    return null;
                }
            });
        }
        return inconsistencies;
    }

    public SQLRow checkValidity(String foreignKey, int foreignID) {
        SQLField fk = this.getField(foreignKey);
        SQLTable foreignTable = this.getDBSystemRoot().getGraph().getForeignTable(fk);
        if (foreignTable == null) {
            throw new IllegalArgumentException("Impossible de tester '" + foreignKey + "' avec " + foreignID + " dans " + this + ". Ce n'est pas une clef \u00e9trang\u00e8re.");
        }
        return foreignTable.checkValidity(foreignID);
    }

    public SQLRow checkValidity(String foreignKey, Number foreignID) {
        if (foreignID == null) {
            return null;
        }
        return this.checkValidity(foreignKey, foreignID.intValue());
    }

    public boolean isOrdered() {
        return this.getOrderField() != null;
    }

    public SQLField getOrderField() {
        return this.getFieldRaw(orderField);
    }

    public final int getOrderDecimalDigits() {
        return this.getOrderField().getType().getDecimalDigits();
    }

    public final BigDecimal getOrderULP() {
        return BigDecimal.ONE.scaleByPowerOfTen(-this.getOrderDecimalDigits());
    }

    public boolean isArchivable() {
        return this.getArchiveField() != null;
    }

    public SQLField getArchiveField() {
        return this.getFieldRaw(archiveField);
    }

    public SQLField getCreationDateField() {
        return this.getFieldRaw("CREATION_DATE");
    }

    public SQLField getCreationUserField() {
        return this.getFieldRaw("ID_USER_COMMON_CREATE");
    }

    public SQLField getModifDateField() {
        return this.getFieldRaw("MODIFICATION_DATE");
    }

    public SQLField getModifUserField() {
        return this.getFieldRaw("ID_USER_COMMON_MODIFY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getUndefinedID() {
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            if (this.undefinedID == null) {
                if (this.getSchema().isFetchAllUndefinedIDs()) {
                    for (SQLTable sibling : this.getSchema().getTables()) {
                        if (sibling.undefinedID != null) continue;
                        sibling.undefinedID = sibling.fetchUndefID();
                    }
                    this.getBase().save(this.getSchema().getName());
                } else {
                    this.undefinedID = this.fetchUndefID();
                    this.save();
                }
            }
            return this.undefinedID;
        }
    }

    public final Number getUndefinedIDNumber() {
        int res = this.getUndefinedID();
        if (res == -1) {
            return null;
        }
        return res;
    }

    private final void save() {
        this.getBase().save(this.getSchema().getName());
    }

    public void addTableModifiedListener(SQLTableModifiedListener l) {
        this.addTableModifiedListener(l, false);
    }

    public void addPremierTableModifiedListener(SQLTableModifiedListener l) {
        this.addTableModifiedListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTableModifiedListener(SQLTableModifiedListener l, boolean before) {
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            ArrayList<SQLTableModifiedListener> newListeners = new ArrayList<SQLTableModifiedListener>(this.tableModifiedListeners.size() + 1);
            if (before) {
                newListeners.add(l);
            }
            newListeners.addAll(this.tableModifiedListeners);
            if (!before) {
                newListeners.add(l);
            }
            this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTableModifiedListener(SQLTableModifiedListener l) {
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            ArrayList<SQLTableModifiedListener> newListeners = new ArrayList<SQLTableModifiedListener>(this.tableModifiedListeners);
            if (newListeners.remove(l)) {
                this.tableModifiedListeners = Collections.unmodifiableList(newListeners);
            }
        }
    }

    public void addTableListener(SQLTableListener l) {
        this.addTableModifiedListener(new BridgeListener(l));
    }

    public void removeTableListener(SQLTableListener l) {
        this.removeTableModifiedListener(new BridgeListener(l));
    }

    public void fireTableModified(int id) {
        this.fire(SQLTableEvent.Mode.ROW_UPDATED, id);
    }

    public void fireRowAdded(int id) {
        this.fire(SQLTableEvent.Mode.ROW_ADDED, id);
    }

    public void fireRowDeleted(int id) {
        this.fire(SQLTableEvent.Mode.ROW_DELETED, id);
    }

    public void fireTableModified(int id, Collection<String> fields) {
        this.fire(new SQLTableEvent(this, id, SQLTableEvent.Mode.ROW_UPDATED, fields));
    }

    private void fire(SQLTableEvent.Mode mode, int id) {
        this.fire(new SQLTableEvent(this, id, mode, null));
    }

    public final void fire(SQLTableEvent evt) {
        this.fireTableModified(evt);
    }

    private static void fireTableModified(Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent> newTuple) {
        Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent> currentTuple;
        LinkedList<Tuple2<Iterator<SQLTableModifiedListener>, SQLTableEvent>> linkedList = events.get();
        linkedList.addLast(newTuple);
        while ((currentTuple = linkedList.peekFirst()) != null) {
            Iterator<SQLTableModifiedListener> iter = currentTuple.get0();
            SQLTableEvent currentEvt = currentTuple.get1();
            while (iter.hasNext()) {
                SQLTableModifiedListener l = iter.next();
                l.tableModified(currentEvt);
            }
            linkedList.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableModified(SQLTableEvent evt) {
        List<SQLTableModifiedListener> dispatchingListeners;
        SQLTable sQLTable = this;
        synchronized (sQLTable) {
            dispatchingListeners = this.tableModifiedListeners;
        }
        SQLTable.fireTableModified(Tuple2.create(dispatchingListeners.iterator(), evt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder sb = new StringBuilder(16000);
        sb.append("<table name=\"");
        sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getName()));
        sb.append("\"");
        String schemaName = this.getSchema().getName();
        if (schemaName != null) {
            sb.append(" schema=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(schemaName));
            sb.append('\"');
        }
        Map<SQLSchema, Map<String, Number>> map = UNDEFINED_IDs;
        synchronized (map) {
            if (this.undefinedID != null) {
                sb.append(" undefID=\"");
                sb.append(this.undefinedID);
                sb.append('\"');
            }
        }
        if (this.getType() != null) {
            sb.append(" type=\"");
            sb.append(JDOMUtils.OUTPUTTER.escapeAttributeEntities(this.getType()));
            sb.append('\"');
        }
        sb.append(">\n");
        if (this.getComment() != null) {
            sb.append("<comment>");
            sb.append(JDOMUtils.OUTPUTTER.escapeElementEntities(this.getComment()));
            sb.append("</comment>\n");
        }
        for (SQLField sQLField : this.fields.values()) {
            sb.append(sQLField.toXML());
        }
        sb.append("<primary>\n");
        for (SQLField sQLField : this.primaryKeys) {
            sb.append(sQLField.toXML());
        }
        sb.append("</primary>\n");
        if (this.triggers.size() > 0) {
            sb.append("<triggers>\n");
            for (Trigger trigger : this.triggers.values()) {
                sb.append(trigger.toXML());
            }
            sb.append("</triggers>\n");
        }
        if (this.constraints != null) {
            sb.append("<constraints>\n");
            for (Constraint constraint : this.constraints) {
                sb.append(constraint.toXML());
            }
            sb.append("</constraints>\n");
        }
        sb.append("</table>");
        return sb.toString();
    }

    @Override
    public SQLTableModifiedListener createTableListener(final SQLDataListener l) {
        return new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                l.dataChanged();
            }
        };
    }

    @Override
    public SQLTable getTable() {
        return this;
    }

    public boolean equalsDesc(SQLTable o) {
        return this.equalsDesc(o, true) == null;
    }

    public String equalsDesc(SQLTable o, boolean compareName) {
        return this.equalsDesc(o, null, compareName);
    }

    public String equalsDesc(SQLTable o, SQLSystem otherSystem, boolean compareName) {
        boolean checkComment;
        boolean name;
        if (o == null) {
            return "other table is null";
        }
        boolean bl = name = !compareName || this.getName().equals(o.getName());
        if (!name) {
            return "name unequal : " + this.getName() + " " + o.getName();
        }
        boolean bl2 = checkComment = otherSystem == null || this.getServer().getSQLSystem().isTablesCommentSupported() && otherSystem.isTablesCommentSupported();
        if (checkComment && !CompareUtils.equals(this.getComment(), o.getComment())) {
            return "comment unequal : '" + this.getComment() + "' != '" + o.getComment() + "'";
        }
        if (!CompareUtils.equals(this.getConstraints(), o.getConstraints())) {
            return "constraints unequal : '" + this.getConstraints() + "' != '" + o.getConstraints() + "'";
        }
        return this.equalsChildren(o, otherSystem);
    }

    private String equalsChildren(SQLTable o, SQLSystem otherSystem) {
        if (!this.getChildrenNames().equals(o.getChildrenNames())) {
            return "fields differences: " + this.getChildrenNames() + "\n" + o.getChildrenNames();
        }
        String noLink = this.equalsChildrenNoLink(o, otherSystem);
        if (noLink != null) {
            return noLink;
        }
        Set<Link> thisLinks = this.getDBSystemRoot().getGraph().getForeignLinks(this);
        Set<Link> oLinks = o.getDBSystemRoot().getGraph().getForeignLinks(o);
        if (thisLinks.size() != oLinks.size()) {
            return "different number of foreign keys " + thisLinks + " != " + oLinks;
        }
        for (Link l : thisLinks) {
            Link ol = o.getDBSystemRoot().getGraph().getForeignLink(o, l.getCols());
            if (ol == null) {
                return "no foreign key for " + l.getLabel();
            }
            SQLName thisPath = ((SQLTable)l.getTarget()).getContextualSQLName(this);
            SQLName oPath = ((SQLTable)ol.getTarget()).getContextualSQLName(o);
            if (thisPath.getItemCount() != oPath.getItemCount()) {
                return "unequal path size : " + thisPath + " != " + oPath;
            }
            if (thisPath.getName().equals(oPath.getName())) continue;
            return "unequal referenced table name : " + thisPath.getName() + " != " + oPath.getName();
        }
        try {
            HashSet<Index> thisIndexesSet = new HashSet<Index>(this.getIndexes());
            HashSet<Index> oIndexesSet = new HashSet<Index>(o.getIndexes());
            if (!thisIndexesSet.equals(oIndexesSet)) {
                return "indexes differences: " + thisIndexesSet + "\n" + oIndexesSet;
            }
        }
        catch (SQLException e) {
            return "couldn't get indexes: " + ExceptionUtils.getStackTrace(e);
        }
        return null;
    }

    public final String equalsChildrenNoLink(SQLTable o, SQLSystem otherSystem) {
        for (SQLField f : this.getFields()) {
            SQLField oField = o.getField(f.getName());
            boolean isPrimary = this.getPrimaryKeys().contains(f);
            if (isPrimary != o.getPrimaryKeys().contains(oField)) {
                return f + " is a primary not in " + o.getPrimaryKeys();
            }
            String equalsDesc = f.equalsDesc(oField, otherSystem, !isPrimary);
            if (equalsDesc == null) continue;
            return equalsDesc;
        }
        return null;
    }

    public final SQLCreateMoveableTable getCreateTable() {
        return this.getCreateTable(this.getServer().getSQLSystem());
    }

    public final SQLCreateMoveableTable getCreateTable(SQLSystem system) {
        SQLSyntax syntax = SQLSyntax.get(system);
        SQLCreateMoveableTable res = new SQLCreateMoveableTable(syntax, this.getName());
        for (SQLField f : this.getOrderedFields()) {
            res.addColumn(f);
        }
        res.setPrimaryKey(this.getPKsNames());
        for (Link l : this.getDBSystemRoot().getGraph().getForeignLinks(this)) {
            res.addForeignConstraint(l, false);
        }
        if (this.constraints != null) {
            for (Constraint added : this.getConstraints()) {
                if (added.getType() == SQLSyntax.ConstraintType.UNIQUE) {
                    res.addUniqueConstraint(added.getName(), added.getCols());
                    continue;
                }
                throw new UnsupportedOperationException("unsupported constraint: " + added);
            }
        }
        try {
            IPredicate<Index> pred = system.autoCreatesFKIndex() ? new IPredicate<Index>(){

                @Override
                public boolean evaluateChecked(Index i) {
                    return !SQLTable.this.getForeignKeysFields().contains(i.getFields());
                }
            } : null;
            for (ChangeTable.OutsideClause c : syntax.getCreateIndexes(this, pred)) {
                res.addOutsideClause(c);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("could not get indexes", e);
        }
        if (this.getComment() != null) {
            res.addOutsideClause(syntax.getSetTableComment(this.getComment()));
        }
        return res;
    }

    public final List<String> getPKsNames() {
        return this.getPKsNames(new ArrayList());
    }

    public final <C extends Collection<String>> C getPKsNames(C pks) {
        for (SQLField f : this.getPrimaryKeys()) {
            pks.add((String)f.getName());
        }
        return pks;
    }

    public final String[] getPKsNamesArray() {
        return this.getPKsNames().toArray(new String[0]);
    }

    public final CollectionMap<String, Index> getIndexesByField() throws SQLException {
        List<Index> indexes = this.getIndexes();
        CollectionMap<String, Index> res = new CollectionMap<String, Index>(new HashSet(4), indexes.size());
        for (Index i : indexes) {
            for (String col : i.getCols()) {
                res.put((Object)col, (Object)i);
            }
        }
        return res;
    }

    public final List<Index> getIndexes() throws SQLException {
        Set<List<String>> uniqConstraints;
        if (this.constraints != null) {
            uniqConstraints = new HashSet();
            for (Constraint c : this.constraints) {
                if (c.getType() != SQLSyntax.ConstraintType.UNIQUE) continue;
                uniqConstraints.add(c.getCols());
            }
        } else {
            uniqConstraints = Collections.emptySet();
        }
        ArrayList<Index> indexes = new ArrayList<Index>();
        Index currentIndex = null;
        for (Map<String, Object> norm : this.getServer().getSQLSystem().getSyntax().getIndexInfo(this)) {
            Index index = new Index(norm);
            short seq = ((Number)norm.get("ORDINAL_POSITION")).shortValue();
            if (seq == 1) {
                if (this.canAdd(currentIndex, uniqConstraints)) {
                    indexes.add(currentIndex);
                }
                currentIndex = index;
                continue;
            }
            currentIndex.add(index);
        }
        if (this.canAdd(currentIndex, uniqConstraints)) {
            indexes.add(currentIndex);
        }
        return indexes;
    }

    private boolean canAdd(Index currentIndex, Set<List<String>> uniqConstraints) {
        if (currentIndex == null || currentIndex.isPKIndex()) {
            return false;
        }
        return !currentIndex.isUnique() || !uniqConstraints.contains(currentIndex.getCols());
    }

    private static final class BridgeListener
    implements SQLTableModifiedListener {
        private final SQLTableListener l;

        private BridgeListener(SQLTableListener l) {
            this.l = l;
        }

        @Override
        public void tableModified(SQLTableEvent evt) {
            SQLTableEvent.Mode mode = evt.getMode();
            if (mode == SQLTableEvent.Mode.ROW_ADDED) {
                this.l.rowAdded(evt.getTable(), evt.getId());
            } else if (mode == SQLTableEvent.Mode.ROW_UPDATED) {
                this.l.rowModified(evt.getTable(), evt.getId());
            } else if (mode == SQLTableEvent.Mode.ROW_DELETED) {
                this.l.rowDeleted(evt.getTable(), evt.getId());
            }
        }

        public int hashCode() {
            return this.l.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof BridgeListener && this.l.equals(((BridgeListener)obj).l);
        }
    }

    public final class Index {
        private final String name;
        private final List<String> attrs;
        private final List<String> cols;
        private final boolean unique;
        private String method;
        private String filter;

        Index(Map<String, Object> row) {
            this((String)row.get("INDEX_NAME"), (String)row.get("COLUMN_NAME"), (Boolean)row.get("NON_UNIQUE"), (String)row.get("FILTER_CONDITION"));
        }

        Index(String name, String col, Boolean nonUnique, String filter) {
            this.name = name;
            this.attrs = new ArrayList<String>();
            this.cols = new ArrayList<String>();
            this.unique = nonUnique == false;
            this.method = null;
            this.filter = filter;
            this.add(this.name, col, this.unique);
        }

        public final SQLTable getTable() {
            return SQLTable.this;
        }

        final void add(String name, String col, boolean unique) {
            if (!name.equals(this.name) || this.unique != unique) {
                throw new IllegalStateException("incoherence");
            }
            this.attrs.add(col);
            if (this.getTable().contains(col)) {
                this.cols.add(col);
            }
        }

        final void add(Index o) {
            this.add(o.getName(), o.cols.get(0), o.unique);
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isUnique() {
            return this.unique;
        }

        public final List<String> getAttrs() {
            return this.attrs;
        }

        public final List<String> getCols() {
            return this.cols;
        }

        public final List<SQLField> getFields() {
            ArrayList<SQLField> res = new ArrayList<SQLField>(this.getCols().size());
            for (String f : this.getCols()) {
                res.add(this.getTable().getField(f));
            }
            return res;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getMethod() {
            return this.method;
        }

        public final String getFilter() {
            return this.filter;
        }

        final boolean isPKIndex() {
            return this.isUnique() && this.getAttrs().equals(SQLTable.this.getPKsNames());
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " " + this.getName() + " unique: " + this.isUnique() + " cols: " + this.getAttrs();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Index) {
                Index o = (Index)obj;
                return this.isUnique() == o.isUnique() && this.getAttrs().equals(o.getAttrs());
            }
            return false;
        }

        public int hashCode() {
            return this.getAttrs().hashCode() + Boolean.valueOf(this.isUnique()).hashCode();
        }
    }
}

