/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import com.mysql.jdbc.Connection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbcp.DelegatingConnection;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.MySQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Trigger;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

class SQLSyntaxMySQL
extends SQLSyntax {
    SQLSyntaxMySQL() {
        super(SQLSystem.MYSQL);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Integer.class, "integer", "int");
        this.typeNames.putAll(Long.class, "bigint");
        this.typeNames.putAll(BigInteger.class, "bigint");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.putAll(Float.class, "float");
        this.typeNames.putAll(Double.class, "double precision", "real");
        this.typeNames.putAll(Timestamp.class, "timestamp");
        this.typeNames.putAll(Date.class, "time");
        this.typeNames.putAll(Blob.class, "blob", "tinyblob", "mediumblob", "longblob", "varbinary", "binary");
        this.typeNames.putAll(Clob.class, "text", "tinytext", "mediumtext", "longtext", "varchar", "char");
        this.typeNames.putAll(String.class, "varchar", "char");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public boolean isAuto(SQLField f) {
        return "YES".equals(f.getMetadata("IS_AUTOINCREMENT"));
    }

    @Override
    public String getAuto() {
        return String.valueOf(this.getIDType()) + " AUTO_INCREMENT NOT NULL";
    }

    @Override
    public String getDateAndTimeType() {
        return "datetime";
    }

    @Override
    protected String getAutoDateType(SQLField f) {
        return "timestamp";
    }

    @Override
    protected Tuple2<Boolean, String> getCast() {
        return null;
    }

    @Override
    protected boolean supportsDefault(String typeName) {
        return !typeName.contains("text") && !typeName.contains("blob");
    }

    @Override
    public String transfDefaultJDBC2SQL(SQLField f) {
        Class<?> javaType = f.getType().getJavaType();
        String res = (String)f.getDefaultValue();
        if (res == null) {
            res = Boolean.FALSE.equals(f.isNullable()) ? null : "NULL";
        } else if (javaType == String.class) {
            res = SQLBase.quoteStringStd(res);
        } else if (res.length() == 0) {
            res = null;
        } else if (Date.class.isAssignableFrom(javaType) && !res.trim().endsWith("()") && !res.toLowerCase().contains("timestamp")) {
            res = SQLBase.quoteStringStd(res);
        } else if (javaType == Boolean.class) {
            res = res.equals("0") ? "FALSE" : "TRUE";
        }
        return res;
    }

    @Override
    public String getCreateTableSuffix() {
        return " ENGINE = InnoDB ";
    }

    @Override
    public String disableFKChecks(DBRoot b) {
        return "SET FOREIGN_KEY_CHECKS=0;";
    }

    @Override
    public String enableFKChecks(DBRoot b) {
        return "SET FOREIGN_KEY_CHECKS=1;";
    }

    @Override
    public String getDropFK() {
        return "DROP FOREIGN KEY ";
    }

    @Override
    public String getDropConstraint() {
        return "DROP INDEX ";
    }

    public Map<String, Object> normalizeIndexInfo(Map m) {
        Map<String, Object> res;
        Object nonUnique = (res = this.copyIndexInfoMap(m)).get("NON_UNIQUE");
        res.put("NON_UNIQUE", nonUnique instanceof Boolean ? nonUnique : Boolean.valueOf((String)nonUnique));
        res.put("COLUMN_NAME", res.get("COLUMN_NAME"));
        return res;
    }

    @Override
    public String getDropIndex(String name, SQLName tableName) {
        return "DROP INDEX " + SQLBase.quoteIdentifier(name) + " on " + tableName.quote() + ";";
    }

    @Override
    protected String getCreateIndex(String cols, SQLName tableName, SQLTable.Index i) {
        String method = i.getMethod() != null ? " USING " + i.getMethod() : "";
        return String.valueOf(super.getCreateIndex(cols, tableName, i)) + method;
    }

    @Override
    public List<String> getAlterField(SQLField f, Set<SQLField.Properties> toAlter, String type, String defaultVal, Boolean nullable) {
        boolean newNullable = toAlter.contains((Object)SQLField.Properties.NULLABLE) ? nullable.booleanValue() : this.getNullable(f);
        String newType = toAlter.contains((Object)SQLField.Properties.TYPE) ? type : this.getType(f);
        String newDef = toAlter.contains((Object)SQLField.Properties.DEFAULT) ? defaultVal : this.getDefault(f, newType);
        return Collections.singletonList(SQLSelect.quote("MODIFY COLUMN %n " + newType + this.getNullableClause(newNullable) + this.getDefaultClause(newDef), f));
    }

    @Override
    public String getDropRoot(String name) {
        return SQLSelect.quote("DROP DATABASE IF EXISTS %i ;", name);
    }

    @Override
    public String getCreateRoot(String name) {
        return SQLSelect.quote("CREATE DATABASE %i ;", name);
    }

    @Override
    protected void _storeData(SQLTable t, File file) {
        this.checkServerLocalhost(t);
        CollectionMap charsets = new CollectionMap();
        for (SQLField f : t.getFields()) {
            Object charset = f.getInfoSchema().get("CHARACTER_SET_NAME");
            if (charset == null) continue;
            charsets.put(charset, f.getName());
        }
        if (charsets.size() > 1) {
            throw new IllegalArgumentException(t + " has more than on character set : " + charsets);
        }
        String charset = charsets.size() == 0 ? "UTF8" : (String)charsets.keySet().iterator().next();
        String cols = CollectionUtils.join(t.getOrderedFields(), ",", new ITransformer<SQLField, String>(){

            @Override
            public String transformChecked(SQLField input) {
                return SQLBase.quoteStringStd(input.getName());
            }
        });
        try {
            int count;
            File tmp = File.createTempFile(String.valueOf(SQLSyntaxMySQL.class.getSimpleName()) + "storeData", ".txt");
            tmp.delete();
            SQLSelect sel = new SQLSelect(t.getBase(), true).addSelectStar(t);
            t.getBase().getDataSource().execute(t.getBase().quote("SELECT " + cols + " UNION " + sel.asString() + " INTO OUTFILE %s " + SQLSyntaxMySQL.getDATA_OPTIONS(t) + ";", tmp.getAbsolutePath()));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmp), charset));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            char[] buf = new char[1024000];
            int offset = 0;
            char[] wbuf = new char[buf.length];
            boolean wasBackslash = false;
            while ((count = r.read(buf, offset, buf.length - offset)) != -1) {
                int wbufLength = 0;
                int i = 0;
                while (i < count) {
                    char c = buf[i];
                    if (wasBackslash && c == '\n') {
                        wbuf[wbufLength - 1] = c;
                    } else {
                        wbuf[wbufLength++] = c;
                    }
                    wasBackslash = c == '\\';
                    ++i;
                }
                if (wasBackslash) {
                    wasBackslash = wbuf[--wbufLength - 1] == '\\';
                    buf[0] = 92;
                    offset = 1;
                } else {
                    offset = 0;
                }
                ((Writer)w).write(wbuf, 0, wbufLength);
            }
            r.close();
            ((Writer)w).close();
            tmp.delete();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getDATA_OPTIONS(DBStructureItem<?> i) {
        return i.getAnc(SQLBase.class).quote("FIELDS TERMINATED BY ',' ENCLOSED BY '\"' ESCAPED BY %s LINES TERMINATED BY '\n' ", "\\");
    }

    @Override
    public void _loadData(final File f, final SQLTable t) {
        final SQLDataSource ds = t.getDBSystemRoot().getDataSource();
        try {
            SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    String charsetClause;
                    java.sql.Connection conn = ((DelegatingConnection)ds.getConnection()).getInnermostDelegate();
                    if (((Connection)conn).versionMeetsMinimum(5, 0, 38)) {
                        charsetClause = "CHARACTER SET utf8 ";
                    } else {
                        String dbCharset = ds.executeA1("show variables like 'character_set_database'")[1].toString().trim().toLowerCase();
                        if (dbCharset.equals("utf8")) {
                            charsetClause = "";
                        } else {
                            throw new IllegalStateException("the database charset is not utf8 and this version doesn't support specifying another one : " + dbCharset);
                        }
                    }
                    ds.execute(t.getBase().quote("LOAD DATA LOCAL INFILE %s INTO TABLE %f " + charsetClause + SQLSyntaxMySQL.getDATA_OPTIONS(t) + " IGNORE 1 LINES;", f.getAbsolutePath(), t));
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't load " + f + " into " + t, e);
        }
    }

    @Override
    public SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new MySQLBase(server, name, login, pass, dsInit);
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        String nullSafe = String.valueOf(x) + " <=> " + y;
        if (eq) {
            return nullSafe;
        }
        return "NOT (" + nullSafe + ")";
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT null as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG is null and ROUTINE_SCHEMA = '" + b.getMDName() + "'";
    }

    @Override
    public String getTriggerQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT \"TRIGGER_NAME\", null as \"TABLE_SCHEMA\", EVENT_OBJECT_TABLE as \"TABLE_NAME\", ACTION_STATEMENT as \"ACTION\", null as \"SQL\" from INFORMATION_SCHEMA.TRIGGERS where " + this.getInfoSchemaWhere("\"EVENT_OBJECT_CATALOG\"", b, "EVENT_OBJECT_SCHEMA", schemas, "EVENT_OBJECT_TABLE", tables);
    }

    private final String getInfoSchemaWhere(String catCol, SQLBase b, String schemaCol, Set<String> schemas, String tableCol, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and " + tableCol + " in (" + SQLSyntaxMySQL.quoteStrings(b, tables) + ")";
        return String.valueOf(catCol) + " is null and " + schemaCol + " = '" + b.getMDName() + "' " + tableWhere;
    }

    @Override
    public String getColumnsQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT null as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , \"CHARACTER_SET_NAME\", \"COLLATION_NAME\" from INFORMATION_SCHEMA.\"COLUMNS\" where " + this.getInfoSchemaWhere("\"TABLE_CATALOG\"", b, "TABLE_SCHEMA", schemas, "TABLE_NAME", tables);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        String sel = "SELECT null as \"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", tc.\"CONSTRAINT_TYPE\", \"COLUMN_NAME\", c.\"ORDINAL_POSITION\"\n FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE c\nJOIN (SELECT * FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS T where " + this.getInfoSchemaWhere("\"CONSTRAINT_CATALOG\"", b, "TABLE_SCHEMA", schemas, "TABLE_NAME", tables) + ") tc on tc.\"TABLE_SCHEMA\" = c.\"TABLE_SCHEMA\" and tc.\"TABLE_NAME\"=c.\"TABLE_NAME\" and tc.\"CONSTRAINT_NAME\"=c.\"CONSTRAINT_NAME\"\n" + " where " + this.getInfoSchemaWhere("c.\"TABLE_CATALOG\"", b, "c.TABLE_SCHEMA", schemas, "c.TABLE_NAME", tables) + "order by c.\"TABLE_SCHEMA\", c.\"TABLE_NAME\", c.\"CONSTRAINT_NAME\", c.\"ORDINAL_POSITION\"";
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    static void mergeColumnNames(List<Map<String, Object>> res) {
        Iterator<Map<String, Object>> listIter = res.iterator();
        ArrayList<String> l = null;
        while (listIter.hasNext()) {
            Map<String, Object> m = listIter.next();
            int pos = ((Number)m.remove("ORDINAL_POSITION")).intValue();
            if (pos == 1) {
                l = new ArrayList<String>();
                m.put("COLUMN_NAMES", l);
            } else {
                listIter.remove();
            }
            l.add((String)m.remove("COLUMN_NAME"));
        }
    }

    @Override
    public String getDropTrigger(Trigger t) {
        return SQLBase.quoteStd("DROP TRIGGER %i", new SQLName(t.getTable().getSchema().getName(), t.getName()));
    }

    @Override
    public String getUpdate(final SQLTable t, List<String> tables, Map<String, String> setPart) {
        ArrayList<String> l = new ArrayList<String>(tables);
        l.add(0, t.getSQLName().quote());
        return String.valueOf(CollectionUtils.join(l, ", ")) + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(t.getField(input.getKey()).getSQLName(t).quote()) + " = " + input.getValue();
            }
        });
    }

    @Override
    public ChangeTable.OutsideClause getSetTableComment(final String comment) {
        return new ChangeTable.OutsideClause(){

            @Override
            public ChangeTable.ClauseType getType() {
                return ChangeTable.ClauseType.OTHER;
            }

            @Override
            public String asString(SQLName tableName) {
                return "ALTER TABLE " + tableName.quote() + " COMMENT = " + SQLBase.quoteStringStd(comment) + ";";
            }
        };
    }
}

