/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLTable;

public class SQLBackgroundTableCache {
    private static SQLBackgroundTableCache instance;
    private Map<SQLTable, SQLBackgroundTableCacheItem> list = new HashMap<SQLTable, SQLBackgroundTableCacheItem>();

    public static void main(String[] args) {
        SQLBackgroundTableCache cache = SQLBackgroundTableCache.getInstance();
        SQLTable t = new SQLTable(null, "test");
        cache.add(t, 30);
    }

    public SQLBackgroundTableCache() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        SQLBackgroundTableCache sQLBackgroundTableCache = SQLBackgroundTableCache.this;
                        synchronized (sQLBackgroundTableCache) {
                            Set set = SQLBackgroundTableCache.this.list.keySet();
                            for (SQLTable table : set) {
                                SQLBackgroundTableCache.this.getCacheForTable(table);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(60000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        t.setName("SQLBackgroundTableCache");
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public static synchronized SQLBackgroundTableCache getInstance() {
        if (instance == null) {
            instance = new SQLBackgroundTableCache();
        }
        return instance;
    }

    public synchronized void add(SQLTable t, int second) {
        if (!this.isCached(t)) {
            SQLBackgroundTableCacheItem item = new SQLBackgroundTableCacheItem(t, second);
            this.list.put(t, item);
        }
    }

    public synchronized boolean isCached(SQLTable t) {
        return this.list.containsKey(t);
    }

    public synchronized SQLBackgroundTableCacheItem getCacheForTable(SQLTable t) {
        SQLBackgroundTableCacheItem item = this.list.get(t);
        if (item != null) {
            item.reloadFromDbIfNeeded();
        }
        return item;
    }
}

