/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.change.AddAllCreator;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public abstract class DBStructureItemJDBC
extends DBStructureItem<DBStructureItemJDBC> {
    private static final String CHILDREN = "children";
    private DBStructureItemDB alterEgo = null;
    private boolean alterEgoCreated = false;
    private boolean dropped = false;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    protected DBStructureItemJDBC(DBStructureItemJDBC parent, String name) {
        super(parent, name);
    }

    final void dropped() {
        this.dropped = true;
        for (DBStructureItemJDBC child : this.getChildren()) {
            child.dropped();
        }
        if (this.alterEgo != null) {
            this.alterEgo.onDrop();
        }
        this.onDrop();
    }

    @Override
    public boolean isDropped() {
        return this.dropped;
    }

    @Override
    public final void addChildrenListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(CHILDREN, l);
    }

    @Override
    public final void rmChildrenListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(CHILDREN, l);
    }

    protected final CollectionChangeEventCreator createChildrenCreator() {
        return new AddAllCreator(this, CHILDREN, this.getChildrenNames());
    }

    protected final void fireChildrenChanged(CollectionChangeEventCreator cc) {
        if (!cc.getName().equals(CHILDREN)) {
            throw new IllegalArgumentException("wrong name: " + cc.getName() + " ; should use createChildrenCreator()");
        }
        this.supp.firePropertyChange(cc.create(this.getChildrenNames()));
    }

    private final HierarchyLevel getNextLevel() {
        return this.getLevels().getNext(this.getLevel());
    }

    final DBStructureItemJDBC getNonNullDBParent() {
        HierarchyLevel nextLevel = this.getNextLevel();
        if (nextLevel == null || this.getDB().getLevels().contains(nextLevel)) {
            return this;
        }
        if (this.getChildrenNames().contains(null)) {
            return ((DBStructureItemJDBC)this.getChild(null)).getNonNullDBParent();
        }
        return null;
    }

    @Override
    protected final EnumOrderedSet<HierarchyLevel> getLevels() {
        return HierarchyLevel.getAll();
    }

    final DBStructureItemDB getRawAlterEgo() {
        if (!this.alterEgoCreated) {
            this.alterEgo = DBStructureItemDB.create(this);
            this.alterEgoCreated = true;
        }
        return this.alterEgo;
    }

    @Override
    public final DBStructureItemDB getDB() {
        if (this.getRawAlterEgo() != null) {
            return this.getRawAlterEgo();
        }
        return ((DBStructureItemJDBC)this.getParent()).getDB();
    }

    @Override
    protected DBStructureItemJDBC getJDBC() {
        return this;
    }
}

