/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.HashSet;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;

public final class UpdateScript {
    private final SQLRowValues updateRow;
    private final CollectionMap<SQLElement, SQLRowValues> toArchive;

    UpdateScript(SQLTable t) {
        this.updateRow = new SQLRowValues(t);
        this.toArchive = new CollectionMap(HashSet.class);
    }

    final SQLRowValues getUpdateRow() {
        return this.updateRow;
    }

    final void addToArchive(SQLElement elem, SQLRowValues r) {
        this.toArchive.put((Object)elem, (Object)r);
    }

    final void put(String field, UpdateScript s) {
        this.getUpdateRow().put(field, s.getUpdateRow());
        this.toArchive.merge(s.toArchive);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getUpdateRow() + " toArchive: " + this.toArchive;
    }

    public final void exec() throws SQLException {
        this.getUpdateRow().commit();
        for (SQLElement elem : this.toArchive.keySet()) {
            for (SQLRowValues v : this.toArchive.getNonNull(elem)) {
                elem.archive(v.getID());
            }
        }
    }
}

