/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutFocusTraversalPolicy;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.FormLayouter;

public abstract class UISQLComponent
extends BaseSQLComponent {
    public static final String REQUIRED_SUFFIX_PROP = "org.openconcerto.sql.requiredSuffix";
    private static final String REQ_SUFFIX = System.getProperty("org.openconcerto.sql.requiredSuffix", " *");
    private FormLayouter autoLayouter;
    private JPanel currentPanel;
    private JTabbedPane tabbedPane;
    private final int width;
    private final int def;

    public UISQLComponent(SQLElement element) {
        this(element, 2);
    }

    public UISQLComponent(SQLElement element, int width) {
        this(element, width, 0);
    }

    public UISQLComponent(SQLElement element, int width, int def) {
        super(element);
        this.width = width;
        this.def = def;
        this.tabbedPane = null;
        this.currentPanel = this;
        this.autoLayouter = null;
    }

    @Override
    protected void addToUI(SQLRowItemView obj, String where) {
        String desc = UISQLComponent.getDesc(obj);
        if (this.getRequired().contains(obj)) {
            desc = String.valueOf(desc) + REQ_SUFFIX;
        }
        if (where == null) {
            where = this.getDefaultWhere(obj);
        }
        if (where == null) {
            this.getLayouter().add(desc, obj.getComp());
        } else if (where.equals("bordered")) {
            this.getLayouter().addBordered(desc, obj.getComp(), 0);
        } else if (where.equals("left")) {
            this.getLayouter().newLine();
            this.getLayouter().add(desc, obj.getComp(), this.getLayouter().getWidth() / 2);
        } else if (where.equals("right")) {
            this.getLayouter().add(desc, obj.getComp(), (this.getLayouter().getWidth() + 1) / 2);
        } else {
            int aWidth = Integer.parseInt(where);
            this.getLayouter().add(desc, obj.getComp(), aWidth);
        }
    }

    private String getDefaultWhere(SQLRowItemView obj) {
        if (this.getElement().getPrivateForeignFields().contains(obj.getField().getName())) {
            return "bordered";
        }
        return null;
    }

    protected void addUITitle(String title) {
        this.getLayouter().add(title, null);
    }

    protected final void addTab() {
        this.addTab("G\u00e9n\u00e9ral");
    }

    protected final void addTab(String tabTitle) {
        this.addTab(tabTitle, this.width, this.def);
    }

    protected final void addTab(String tabTitle, int w, int d) {
        if (this.tabbedPane == null) {
            if (this.getComponentCount() > 0) {
                throw new IllegalStateException("you cannot create a tab after adding views");
            }
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setFocusCycleRoot(true);
            this.tabbedPane.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){
                private final JTabbedPane tab;
                {
                    this.tab = UISQLComponent.this.tabbedPane;
                }

                @Override
                public Component getComponentAfter(Container container, Component component) {
                    if (component == this.getLastComponent(this.tab)) {
                        this.tab.setSelectedIndex((this.tab.getSelectedIndex() + 1) % this.tab.getTabCount());
                        return this.getFirstComponent((Container)this.tab.getSelectedComponent());
                    }
                    return super.getComponentAfter(container, component);
                }

                @Override
                public Component getComponentBefore(Container container, Component component) {
                    if (component == this.getFirstComponent(this.tab)) {
                        int index = (this.tab.getTabCount() + this.tab.getSelectedIndex() - 1) % this.tab.getTabCount();
                        this.tab.setSelectedIndex(index);
                        return this.getLastComponent((Container)this.tab.getSelectedComponent());
                    }
                    return super.getComponentBefore(container, component);
                }

                @Override
                protected boolean accept(Component component) {
                    if (component == this.tab) {
                        return false;
                    }
                    return super.accept(component);
                }
            });
            this.setLayout(new GridLayout(1, 1));
            this.add(this.tabbedPane);
        }
        this.currentPanel = new JPanel();
        this.currentPanel.setOpaque(false);
        this.tabbedPane.addTab(tabTitle, this.currentPanel);
        this.setLayouter(w, d);
    }

    private void setLayouter(int w, int d) {
        this.autoLayouter = new FormLayouter(this.currentPanel, w, d);
        this.setAdditionalFieldsPanel(this.autoLayouter);
    }

    protected final FormLayouter getLayouter() {
        if (this.autoLayouter == null) {
            this.setLayouter(this.width, this.def);
        }
        return this.autoLayouter;
    }
}

