/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EntrySetMapIterator;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.DeletionMode;
import org.openconcerto.sql.element.RowBacked;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementRowR;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.element.UpdateScript;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLFieldsSet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowMode;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.DatabaseGraph;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.sqlobject.SQLTextCombo;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.change.ListChangeIndex;
import org.openconcerto.utils.change.ListChangeRecorder;

public abstract class SQLElement {
    private static final Set<String> computingFF = Collections.unmodifiableSet(new HashSet());
    private static final Set<SQLField> computingRF = Collections.unmodifiableSet(new HashSet());
    public static final String DEFAULT_COMP_ID = "default component code";
    private final String singular;
    private final String plural;
    private final SQLTable primaryTable;
    private final String code;
    private ComboSQLRequest combo;
    private ListSQLRequest list;
    private SQLTableModelSourceOnline tableSrc;
    private final ListChangeRecorder<IListeAction> rowActions;
    private final CollectionMap<String, ITransformer<Tuple2<SQLElement, String>, SQLComponent>> components;
    private Set<String> normalFF;
    private String parentFF;
    private Set<String> sharedFF;
    private Map<String, SQLElement> privateFF;
    private final Map<String, ReferenceAction> actions;
    private Set<SQLField> childRF;
    private Set<SQLField> privateParentRF;
    private Set<SQLField> otherRF;
    private SQLCache<SQLRowAccessor, Object> modelCache;
    private final Map<String, JComponent> additionalFields;
    private final List<SQLTableModelColumn> additionalListCols;

    public SQLElement(String singular, String plural, SQLTable primaryTable) {
        this(singular, plural, primaryTable, null);
    }

    public SQLElement(String singular, String plural, SQLTable primaryTable, String code) {
        this.singular = singular;
        this.plural = plural;
        if (primaryTable == null) {
            throw new DBStructureItemNotFound("table is null for " + this);
        }
        this.primaryTable = primaryTable;
        this.code = code == null ? this.createCode() : code;
        this.combo = null;
        this.list = null;
        this.rowActions = new ListChangeRecorder(new ArrayList());
        this.actions = new HashMap<String, ReferenceAction>();
        this.resetRelationships();
        this.components = new CollectionMap(new LinkedList());
        this.modelCache = null;
        this.additionalFields = new LinkedHashMap<String, JComponent>();
        this.additionalListCols = new ArrayList<SQLTableModelColumn>();
    }

    protected String createCode() {
        return String.valueOf(this.getClass().getName()) + "-" + this.getTable().getName();
    }

    public synchronized void resetRelationships() {
        this.privateFF = null;
        this.parentFF = null;
        this.normalFF = null;
        this.sharedFF = null;
        this.actions.clear();
        this.childRF = null;
        this.privateParentRF = null;
        this.otherRF = null;
    }

    private void checkSelfCall(boolean check, String methodName) {
        assert (check) : this + " " + methodName + "() is calling itself, and thus the caller will only see a partial state";
    }

    private synchronized void initFF() {
        this.checkSelfCall(this.sharedFF != computingFF, "initFF");
        if (this.sharedFF != null) {
            return;
        }
        this.sharedFF = computingFF;
        HashSet<String> privates = new HashSet<String>(this.getPrivateFields());
        this.privateFF = new HashMap<String, SQLElement>(privates.size());
        HashSet<String> parents = new HashSet<String>();
        this.normalFF = new HashSet<String>();
        HashSet<String> tmpSharedFF = new HashSet<String>();
        for (SQLField ff : this.getTable().getForeignKeys()) {
            String fieldName = ff.getName();
            SQLElement foreignElement = this.getForeignElement(fieldName);
            if (privates.contains(fieldName)) {
                privates.remove(fieldName);
                this.privateFF.put(fieldName, foreignElement);
                continue;
            }
            if (foreignElement.isShared()) {
                tmpSharedFF.add(fieldName);
                continue;
            }
            if (foreignElement.getChildrenReferentFields().contains(ff)) {
                parents.add(fieldName);
                continue;
            }
            this.normalFF.add(fieldName);
        }
        if (parents.size() > 1) {
            throw new IllegalStateException("for " + this + " more than one parent :" + parents);
        }
        String string = this.parentFF = parents.size() == 0 ? null : (String)parents.iterator().next();
        if (privates.size() > 0) {
            throw new IllegalStateException("for " + this + " these private foreign fields are not valid :" + privates);
        }
        this.sharedFF = tmpSharedFF;
        this.actions.put(this.parentFF, ReferenceAction.CASCADE);
        for (String s : this.privateFF.keySet()) {
            this.actions.put(s, ReferenceAction.SET_EMPTY);
        }
        for (String s : this.normalFF) {
            this.actions.put(s, ReferenceAction.SET_EMPTY);
        }
        for (String s : this.sharedFF) {
            this.actions.put(s, ReferenceAction.RESTRICT);
        }
        this.ffInited();
    }

    protected void ffInited() {
    }

    private synchronized Set<SQLField> computeChildrenRF() {
        HashSet<SQLField> res = new HashSet<SQLField>();
        for (String child : this.getChildren()) {
            SQLField childField;
            int comma = child.indexOf(44);
            String tableName = comma < 0 ? child : child.substring(0, comma);
            SQLTable childTable = this.getTable().getTable(tableName);
            if (comma < 0) {
                Set<SQLField> keys = childTable.getForeignKeys(this.getTable());
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("cannot find a foreign from " + child + " to " + this.getTable());
                }
                childField = keys.iterator().next();
            } else {
                childField = childTable.getField(child.substring(comma + 1));
                SQLTable foreignTable = childField.getDBSystemRoot().getGraph().getForeignTable(childField);
                if (!foreignTable.equals(this.getTable())) {
                    throw new IllegalArgumentException(childField + " doesn't point to " + this.getTable());
                }
            }
            res.add(childField);
        }
        return res;
    }

    private synchronized void initRF() {
        this.checkSelfCall(this.otherRF != computingRF, "initRF");
        if (this.otherRF != null) {
            return;
        }
        this.otherRF = computingRF;
        this.privateParentRF = new HashSet<SQLField>();
        HashSet<SQLField> tmpOtherRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLElement refElem = this.getElementLenient(refField.getTable());
            if (refElem != null && refElem.getPrivateForeignFields().contains(refField.getName())) {
                this.privateParentRF.add(refField);
                continue;
            }
            if (this.getChildrenReferentFields().contains(refField)) continue;
            tmpOtherRF.add(refField);
        }
        this.otherRF = tmpOtherRF;
    }

    private synchronized void initChildRF() {
        this.checkSelfCall(this.childRF != computingRF, "initFF");
        if (this.childRF != null) {
            return;
        }
        this.childRF = computingRF;
        Set<SQLField> children = this.computeChildrenRF();
        HashSet<SQLField> tmpChildRF = new HashSet<SQLField>();
        for (SQLField refField : this.getTable().getBase().getGraph().getReferentKeys(this.getTable())) {
            SQLField refParentFF;
            SQLElement refElem = this.getElementLenient(refField.getTable());
            SQLField sQLField = refParentFF = refElem == null ? null : refElem.getParentFF();
            if (refParentFF != null && children.contains(refField)) {
                throw new IllegalStateException(refElem + " specifies this as its parent: " + refParentFF + " and is also mentioned as our (" + this + ") child: " + refField);
            }
            if (!children.contains(refField) && refParentFF != refField) continue;
            tmpChildRF.add(refField);
        }
        this.childRF = tmpChildRF;
    }

    final SQLElement getElement(SQLTable table) {
        SQLElement res = this.getElementLenient(table);
        if (res == null) {
            throw new IllegalStateException("no element for " + table.getSQLName());
        }
        return res;
    }

    final SQLElement getElementLenient(SQLTable table) {
        return Configuration.getInstance().getDirectory().getElement(table);
    }

    public final SQLElement getForeignElement(String foreignField) {
        try {
            return this.getElement(this.getForeignTable(foreignField));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("no element for " + foreignField + " in " + this, e);
        }
    }

    private final SQLTable getForeignTable(String foreignField) {
        return this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(foreignField));
    }

    public String getPluralName() {
        return this.plural;
    }

    public String getSingularName() {
        return this.singular;
    }

    public CollectionMap<String, String> getShowAs() {
        return null;
    }

    public Set<String> getReadOnlyFields() {
        return Collections.emptySet();
    }

    public Set<String> getInsertOnlyFields() {
        return Collections.emptySet();
    }

    private final SQLCache<SQLRowAccessor, Object> getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = new SQLCache(60, -1, "modelObjects of " + this.getSingularName());
        }
        return this.modelCache;
    }

    public void unarchiveNonRec(int id) throws SQLException {
        this.unarchiveNonRec(this.getTable().getRow(id));
    }

    private void unarchiveNonRec(SQLRow row) throws SQLException {
        this.checkUndefined(row);
        if (!row.isArchived()) {
            return;
        }
        Set<SQLRow> connectedRows = this.getArchivedConnectedRows(Collections.singleton(row));
        for (SQLRow desc : connectedRows) {
            this.getElement(desc.getTable()).unarchiveSingle(desc);
        }
        for (SQLRow desc : connectedRows) {
            DeletionMode.UnArchiveMode.fireChange(desc);
        }
    }

    private Set<SQLRow> getArchivedConnectedRows(Collection<SQLRow> rows) throws SQLException {
        HashSet<SQLRow> res = new HashSet<SQLRow>();
        for (SQLRow row : rows) {
            this.getElement(row.getTable()).getArchivedConnectedRows(row, res);
        }
        return res;
    }

    private void getArchivedConnectedRows(SQLRow row, Set<SQLRow> rows) throws SQLException {
        this.check(row);
        if (!rows.add(row)) {
            return;
        }
        SQLRowMode mode = new SQLRowMode(SQLSelect.ArchiveMode.ARCHIVED, true, true);
        HashSet<SQLRow> foreigns = new HashSet<SQLRow>(this.getNormalForeigns(row, mode).values());
        SQLRow parent = this.getParent(row, mode);
        if (parent != null) {
            foreigns.add(parent);
        }
        for (SQLRow foreign : foreigns) {
            this.getElement(foreign.getTable()).getArchivedConnectedRows(foreign, rows);
        }
    }

    public final UpdateScript update(SQLRowValues from, SQLRowValues to) {
        this.check(from);
        this.check(to);
        if (!from.hasID()) {
            throw new IllegalArgumentException("missing id in " + from);
        }
        if (from.getID() != to.getID()) {
            throw new IllegalArgumentException("not the same row: " + from + " != " + to);
        }
        Set<SQLField> fks = this.getTable().getForeignKeys();
        UpdateScript res = new UpdateScript(this.getTable());
        for (String field : to.getFields()) {
            if (!fks.contains(this.getTable().getField(field))) {
                res.getUpdateRow().put(field, to.getObject(field));
                continue;
            }
            Object fromPrivate = from.getObject(field);
            Object toPrivate = to.getObject(field);
            if (!fromPrivate.getClass().equals(toPrivate.getClass())) {
                throw new IllegalArgumentException("asymmetric tree " + fromPrivate + " != " + toPrivate);
            }
            boolean isPrivate = this.getPrivateForeignFields().contains(field);
            if (fromPrivate instanceof SQLRowValues) {
                SQLRowValues fromPR = (SQLRowValues)fromPrivate;
                SQLRowValues toPR = (SQLRowValues)toPrivate;
                if (isPrivate) {
                    if (from.isForeignEmpty(field) && to.isForeignEmpty(field)) continue;
                    if (from.isForeignEmpty(field)) {
                        res.getUpdateRow().put(field, toPR.deepCopy().clearReferents());
                        continue;
                    }
                    if (to.isForeignEmpty(field)) {
                        res.addToArchive(this.getForeignElement(field), fromPR);
                        continue;
                    }
                    if (fromPR.getID() != toPR.getID()) {
                        throw new IllegalArgumentException("private have changed: " + fromPR + " != " + toPR);
                    }
                    res.put(field, this.getForeignElement(field).update(fromPR, toPR));
                    continue;
                }
                res.getUpdateRow().put(field, toPR.getID());
                continue;
            }
            Number fromP_ID = (Number)fromPrivate;
            Number toP_ID = (Number)toPrivate;
            if (isPrivate) {
                if (fromP_ID.longValue() == toP_ID.longValue()) continue;
                throw new IllegalArgumentException("cannot change private ID");
            }
            res.getUpdateRow().put(field, toP_ID);
        }
        return res;
    }

    public final void unarchive(int id) throws SQLException {
        this.unarchive(this.getTable().getRow(id));
    }

    public void unarchive(SQLRow row) throws SQLException {
        this.checkUndefined(row);
        List<SQLRow> descsAndMe = this.getTree(row, true);
        final Set<SQLRow> connectedRows = this.getArchivedConnectedRows(descsAndMe);
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                for (SQLRow desc : connectedRows) {
                    SQLElement.this.getElement(desc.getTable()).unarchiveSingle(desc);
                }
                for (SQLRow desc : connectedRows) {
                    DeletionMode.UnArchiveMode.fireChange(desc);
                }
                return null;
            }
        });
    }

    public final void archive(int id) throws SQLException {
        this.archive(this.getTable().getRow(id));
    }

    public final void archive(SQLRow row) throws SQLException {
        this.archive(row, true);
    }

    public final void archiveNoCut(int id) throws SQLException {
        this.archive(this.getTable().getRow(id), false);
    }

    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        this.archive(new TreesOfSQLRows(this, row), cutLinks);
    }

    protected void archive(final TreesOfSQLRows trees, final boolean cutLinks) throws SQLException {
        if (trees.getElem() != this) {
            throw new IllegalArgumentException(this + " != " + trees.getElem());
        }
        for (SQLRow row : trees.getRows()) {
            this.checkUndefined(row);
        }
        SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                if (cutLinks) {
                    CollectionMap<SQLField, SQLRow> externReferences = trees.getExternReferences();
                    if (Log.get().isLoggable(Level.FINEST)) {
                        Log.get().finest("will cut : " + externReferences);
                    }
                    EntrySetMapIterator refIter = new EntrySetMapIterator(externReferences);
                    while (refIter.hasNext()) {
                        SQLField refKey = (SQLField)refIter.next();
                        Collection refList = (Collection)refIter.getValue();
                        for (SQLRow ref : refList) {
                            ref.createEmptyUpdateRow().putEmptyLink(refKey.getName()).update();
                        }
                    }
                    Log.get().finest("done cutting links");
                }
                for (SQLRowAccessor desc : trees.getFlatDescendants()) {
                    SQLElement.this.getElement(desc.getTable()).archiveSingle(desc);
                    DeletionMode.ArchiveMode.fireChange(desc);
                }
                return null;
            }
        });
    }

    private final void archiveSingle(SQLRowAccessor r) throws SQLException {
        this.changeSingle(r, DeletionMode.ArchiveMode);
    }

    private final void unarchiveSingle(SQLRowAccessor r) throws SQLException {
        this.changeSingle(r, DeletionMode.UnArchiveMode);
    }

    private final void changeSingle(SQLRowAccessor r, DeletionMode m) throws SQLException {
        m.execute(this, r);
    }

    public void delete(SQLRowAccessor r) throws SQLException {
        this.check(r);
        throw new UnsupportedOperationException("not yet implemented.");
    }

    public final SQLTable getTable() {
        return this.primaryTable;
    }

    public final String getCode() {
        return this.code;
    }

    public boolean isShared() {
        return false;
    }

    public boolean dontDeepCopy() {
        return false;
    }

    public final synchronized Set<SQLField> getOtherReferentFields() {
        this.initRF();
        return this.otherRF;
    }

    public final synchronized Set<SQLField> getChildrenReferentFields() {
        this.initChildRF();
        return this.childRF;
    }

    public final synchronized Set<SQLField> getPrivateParentReferentFields() {
        this.initRF();
        return this.privateParentRF;
    }

    protected Set<String> getChildren() {
        return Collections.emptySet();
    }

    public final synchronized Set<String> getNormalForeignFields() {
        this.initFF();
        return this.normalFF;
    }

    public final synchronized Set<String> getSharedForeignFields() {
        this.initFF();
        return this.sharedFF;
    }

    public final synchronized String getParentForeignField() {
        this.initFF();
        return this.parentFF;
    }

    private final SQLField getParentFF() {
        String name = this.getParentFFName();
        return name == null ? null : this.getTable().getField(name);
    }

    protected String getParentFFName() {
        return null;
    }

    public final SQLElement getParentElement() {
        if (this.getParentForeignField() == null) {
            return null;
        }
        return this.getForeignElement(this.getParentForeignField());
    }

    private final synchronized Map<String, SQLElement> getPrivateFF() {
        this.initFF();
        return this.privateFF;
    }

    public final Set<String> getPrivateForeignFields() {
        return Collections.unmodifiableSet(this.getPrivateFF().keySet());
    }

    public final SQLElement getPrivateElement(String foreignField) {
        return this.getPrivateFF().get(foreignField);
    }

    public final SQLRowValues getPrivateGraph() {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.setAllToNull();
        for (Map.Entry<String, SQLElement> e : this.getPrivateFF().entrySet()) {
            res.put(e.getKey(), e.getValue().getPrivateGraph());
        }
        return res;
    }

    protected List<String> getPrivateFields() {
        return Collections.emptyList();
    }

    public final void clearPrivateFields(SQLRowValues rowVals) {
        for (String s : this.getPrivateFF().keySet()) {
            rowVals.remove(s);
        }
    }

    final Map<String, ReferenceAction> getActions() {
        this.initFF();
        return this.actions;
    }

    public final void setAction(String ff, ReferenceAction action) throws IllegalArgumentException {
        if (action.compareTo(ReferenceAction.RESTRICT) < 0 && !this.getNormalForeignFields().contains(ff)) {
            throw new IllegalArgumentException(this.getTable().getField(ff).getSQLName() + " is not a normal foreign field : " + this.getNormalForeignFields());
        }
        this.getActions().put(ff, action);
    }

    public final Set<Link> getParentsLinks() {
        Set<SQLField> refFields = this.getPrivateParentReferentFields();
        HashSet<Link> res = new HashSet<Link>(refFields.size());
        DatabaseGraph graph = this.getTable().getDBSystemRoot().getGraph();
        for (SQLField refField : refFields) {
            res.add(graph.getForeignLink(refField));
        }
        if (this.getParentForeignField() != null) {
            res.add(graph.getForeignLink(this.getTable().getField(this.getParentForeignField())));
        }
        return res;
    }

    public final Set<SQLElement> getChildrenElements() {
        HashSet<SQLElement> res = new HashSet<SQLElement>();
        res.addAll(this.getPrivateFF().values());
        for (SQLTable child : new SQLFieldsSet(this.getChildrenReferentFields()).getTables()) {
            res.add(this.getElement(child));
        }
        return res;
    }

    public final SQLElement getChildElement(String tableName) {
        SQLField field = CollectionUtils.getSole(new SQLFieldsSet(this.getChildrenReferentFields()).getFields(tableName));
        if (field == null) {
            throw new IllegalStateException("no child table named " + tableName);
        }
        return this.getElement(field.getTable());
    }

    public final Set<SQLTable> getDescendantTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        this.getDescendantTables(res);
        return res;
    }

    private final void getDescendantTables(Set<SQLTable> res) {
        res.add(this.getTable());
        for (SQLElement elem : this.getChildrenElements()) {
            res.addAll(elem.getDescendantTables());
        }
    }

    public ComboSQLRequest getComboRequest() {
        if (this.combo == null) {
            this.combo = new ComboSQLRequest(this.getTable(), this.getComboFields());
        }
        return this.combo;
    }

    protected abstract List<String> getComboFields();

    public final synchronized ListSQLRequest getListRequest() {
        if (this.list == null) {
            this.list = this.createListRequest();
        }
        return this.list;
    }

    protected ListSQLRequest createListRequest() {
        return new ListSQLRequest(this.getTable(), this.getListFields());
    }

    public final SQLTableModelSourceOnline getTableSource() {
        return this.getTableSource(!this.cacheTableSource());
    }

    public final synchronized SQLTableModelSourceOnline getTableSource(boolean create) {
        if (!create) {
            if (this.tableSrc == null) {
                this.tableSrc = this.createAndInitTableSource();
            }
            return this.tableSrc;
        }
        return this.createAndInitTableSource();
    }

    public final SQLTableModelSourceOnline createTableSource(List<String> fields) {
        return this.initTableSource(new SQLTableModelSourceOnline(new ListSQLRequest(this.getTable(), fields)));
    }

    public final SQLTableModelSourceOnline createTableSource(Where w) {
        SQLTableModelSourceOnline res = this.getTableSource(true);
        res.getReq().setWhere(w);
        return res;
    }

    private final SQLTableModelSourceOnline createAndInitTableSource() {
        SQLTableModelSourceOnline res = this.createTableSource();
        res.getColumns().addAll(this.additionalListCols);
        return this.initTableSource(res);
    }

    protected synchronized void _initTableSource(SQLTableModelSourceOnline res) {
    }

    public final synchronized SQLTableModelSourceOnline initTableSource(SQLTableModelSourceOnline res) {
        this._initTableSource(res);
        Set<String> dontModif = CollectionUtils.union(this.getReadOnlyFields(), this.getInsertOnlyFields());
        for (String f : dontModif) {
            for (SQLTableModelColumn col : res.getColumns(this.getTable().getField(f))) {
                if (!(col instanceof SQLTableModelColumnPath)) continue;
                ((SQLTableModelColumnPath)col).setEditable(false);
            }
        }
        return res;
    }

    protected SQLTableModelSourceOnline createTableSource() {
        return new SQLTableModelSourceOnline(this.createListRequest());
    }

    protected boolean cacheTableSource() {
        return true;
    }

    protected abstract List<String> getListFields();

    public final void addListFields(List<String> fields) {
        for (String f : fields) {
            this.addListColumn(new SQLTableModelColumnPath(this.getTable().getField(f)));
        }
    }

    public final void addListColumn(SQLTableModelColumn col) {
        this.additionalListCols.add(col);
    }

    public final Collection<IListeAction> getRowActions() {
        return this.rowActions;
    }

    public final void addRowActionsListener(IClosure<ListChangeIndex<IListeAction>> listener) {
        this.rowActions.getRecipe().addListener(listener);
    }

    public final void removeRowActionsListener(IClosure<ListChangeIndex<IListeAction>> listener) {
        this.rowActions.getRecipe().rmListener(listener);
    }

    public String getDescription(SQLRow fromRow) {
        return fromRow.toString();
    }

    private <R extends SQLRowAccessor> void forChildrenDo(R row, ChildProcessor<? super R> c, boolean deep, boolean archived) throws SQLException {
        for (SQLField childField : this.getChildrenReferentFields()) {
            if (!deep && this.getElement(childField.getTable()).dontDeepCopy()) continue;
            List<SQLRow> children = row.asRow().getReferentRows(childField, archived ? SQLSelect.ARCHIVED : SQLSelect.UNARCHIVED);
            for (SQLRow child : children) {
                c.process(row, childField, this.convert(child, row));
            }
        }
    }

    private <R extends SQLRowAccessor> R convert(SQLRow toConv, R row) {
        SQLRowAccessor ch;
        if (row instanceof SQLRow) {
            ch = toConv;
        } else if (row instanceof SQLRowValues) {
            ch = toConv.createUpdateRow();
        } else {
            throw new IllegalStateException("SQLRowAccessor is neither SQLRow nor SQLRowValues: " + toConv);
        }
        return (R)ch;
    }

    private void forDescendantsDo(SQLRow row, ChildProcessor<SQLRow> c, boolean deep) throws SQLException {
        this.forDescendantsDo(row, c, deep, true, false);
    }

    <R extends SQLRowAccessor> void forDescendantsDo(R row, final ChildProcessor<R> c, final boolean deep, final boolean leavesFirst, final boolean archived) throws SQLException {
        this.check(row);
        this.forChildrenDo(row, new ChildProcessor<R>(){

            @Override
            public void process(R parent, SQLField joint, R child) throws SQLException {
                if (!leavesFirst) {
                    c.process(parent, joint, child);
                }
                SQLElement.this.getElement(((SQLRowAccessor)child).getTable()).forDescendantsDo(child, c, deep, leavesFirst, archived);
                if (leavesFirst) {
                    c.process(parent, joint, child);
                }
            }
        }, deep, archived);
    }

    void check(SQLRowAccessor row) {
        if (!row.getTable().equals(this.getTable())) {
            throw new IllegalArgumentException("row must of table " + this.getTable() + " : " + row);
        }
    }

    private void checkUndefined(SQLRow row) {
        this.check(row);
        if (row.isUndefined()) {
            throw new IllegalArgumentException("row is undefined: " + row);
        }
    }

    public final SQLRow copyRecursive(int id) throws SQLException {
        return this.copyRecursive(this.getTable().getRow(id));
    }

    public final SQLRow copyRecursive(SQLRow row) throws SQLException {
        return this.copyRecursive(row, null);
    }

    public SQLRow copyRecursive(SQLRow row, SQLRow parent) throws SQLException {
        return this.copyRecursive(row, parent, null);
    }

    public SQLRow copyRecursive(final SQLRow row, final SQLRow parent, final IClosure<SQLRowValues> c) throws SQLException {
        this.check(row);
        if (row.isUndefined()) {
            return row;
        }
        final HashMap copies = new HashMap();
        return SQLUtils.executeAtomic(this.getTable().getBase().getDataSource(), new SQLUtils.SQLFactory<SQLRow>(){

            @Override
            public SQLRow create() throws SQLException {
                SQLRowValues copy2 = SQLElement.this.createTransformedCopy(row, parent, c);
                copies.put(row, copy2);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        SQLRowValues parentCopy = (SQLRowValues)copies.get(parent);
                        if (parentCopy == null) {
                            throw new IllegalStateException("null copy of " + parent);
                        }
                        SQLRowValues descCopy = SQLElement.this.createTransformedCopy(desc, null, c);
                        descCopy.put(joint.getName(), parentCopy);
                        copies.put(desc, descCopy);
                    }
                }, false, false, false);
                SQLElement.this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                    @Override
                    public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                        CollectionMap<SQLField, SQLRow> normalReferents = SQLElement.this.getElement(desc.getTable()).getNonChildrenReferents(desc);
                        for (Map.Entry<SQLField, Collection<SQLRow>> e : normalReferents.entrySet()) {
                            SQLField refField = e.getKey();
                            for (SQLRow ref : e.getValue()) {
                                SQLRowValues refCopy = (SQLRowValues)copies.get(ref);
                                if (refCopy == null) continue;
                                SQLRowValues referencedCopy = (SQLRowValues)copies.get(desc);
                                refCopy.put(refField.getName(), referencedCopy);
                            }
                        }
                    }
                }, false);
                return copy2.insert();
            }
        });
    }

    private final SQLRowValues createTransformedCopy(SQLRow desc, SQLRow parent, IClosure<SQLRowValues> c) throws SQLException {
        SQLRowValues copiedVals = this.getElement(desc.getTable()).createCopy(desc, parent);
        assert (copiedVals != null) : "failed to copy " + desc;
        if (c != null) {
            c.executeChecked(copiedVals);
        }
        return copiedVals;
    }

    public final SQLRow copy(int id) throws SQLException {
        return this.copy(this.getTable().getRow(id));
    }

    public final SQLRow copy(SQLRow row) throws SQLException {
        return this.copy(row, null);
    }

    public final SQLRow copy(SQLRow row, SQLRow parent) throws SQLException {
        SQLRowValues copy2 = this.createCopy(row, parent);
        return copy2 == null ? row : copy2.insert();
    }

    public final SQLRowValues createCopy(int id) {
        SQLRow row = this.getTable().getRow(id);
        return this.createCopy(row, null);
    }

    public SQLRowValues createCopy(SQLRow row, SQLRow parent) {
        if (row == null || row.isUndefined()) {
            return null;
        }
        this.check(row);
        SQLRowValues copy2 = new SQLRowValues(this.getTable());
        copy2.loadAllSafe(row);
        for (String privateName : this.getPrivateForeignFields()) {
            SQLElement privateElement = this.getPrivateElement(privateName);
            if (!privateElement.dontDeepCopy() && !row.isForeignEmpty(privateName)) {
                SQLRowValues child = privateElement.createCopy(row.getInt(privateName));
                copy2.put(privateName, child);
                continue;
            }
            copy2.putEmptyLink(privateName);
        }
        if (parent != null) {
            SQLTable foreignTable = this.getTable().getBase().getGraph().getForeignTable(this.getTable().getField(this.getParentForeignField()));
            if (!parent.getTable().equals(foreignTable)) {
                throw new IllegalArgumentException(parent + " is not a parent of " + row);
            }
            copy2.put(this.getParentForeignField(), parent.getID());
        }
        return copy2;
    }

    public final CollectionMap<SQLTable, SQLRow> getDescendants(SQLRow row) {
        this.check(row);
        final CollectionMap<SQLTable, SQLRow> mm = new CollectionMap<SQLTable, SQLRow>();
        try {
            this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.put(joint.getTable(), child);
                }
            }, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    private List<SQLRow> getTree(SQLRow row, boolean archived) {
        this.check(row);
        final ArrayList<SQLRow> descsAndMe = new ArrayList<SQLRow>();
        try {
            this.forDescendantsDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow desc) throws SQLException {
                    descsAndMe.add(desc);
                }
            }, true, true, archived);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (row.isArchived() == archived) {
            descsAndMe.add(row);
        }
        return descsAndMe;
    }

    public CollectionMap<SQLTable, SQLRow> getChildrenRows(SQLRow row) {
        this.check(row);
        final CollectionMap<SQLTable, SQLRow> mm = new CollectionMap<SQLTable, SQLRow>();
        try {
            this.forChildrenDo(row, new ChildProcessor<SQLRow>(){

                @Override
                public void process(SQLRow parent, SQLField joint, SQLRow child) throws SQLException {
                    mm.put(child.getTable(), child);
                }
            }, true, false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return mm;
    }

    public SQLRow getParent(SQLRow row) {
        return this.getParent(row, SQLRowMode.VALID);
    }

    private SQLRow getParent(SQLRow row, SQLRowMode mode) {
        this.check(row);
        return this.getParentForeignField() == null ? null : row.getForeignRow(this.getParentForeignField(), mode);
    }

    CollectionMap<SQLField, SQLRow> getNonChildrenReferents(SQLRow row) {
        this.check(row);
        CollectionMap<SQLField, SQLRow> mm = new CollectionMap<SQLField, SQLRow>();
        HashSet<SQLField> nonChildren = new HashSet<SQLField>(row.getTable().getDBSystemRoot().getGraph().getReferentKeys(row.getTable()));
        nonChildren.removeAll(this.getChildrenReferentFields());
        for (SQLField refField : nonChildren) {
            mm.putAll((Object)refField, row.getReferentRows(refField));
        }
        return mm;
    }

    public Map<String, SQLRow> getNormalForeigns(SQLRow row) {
        return this.getNormalForeigns(row, SQLRowMode.DEFINED);
    }

    private Map<String, SQLRow> getNormalForeigns(SQLRow row, SQLRowMode mode) {
        this.check(row);
        HashMap<String, SQLRow> mm = new HashMap<String, SQLRow>();
        for (String ff : this.getNormalForeignFields()) {
            SQLRow foreignRow = row.getForeignRow(ff, mode);
            if (foreignRow == null) continue;
            mm.put(ff, foreignRow);
        }
        return mm;
    }

    public Object getModelObject(SQLRowAccessor row) {
        Object res;
        this.check(row);
        if (this.getModelClass() == null) {
            return null;
        }
        if (row instanceof SQLRow) {
            CacheResult cached = this.getModelCache().check(row);
            if (cached.getState() == CacheResult.State.NOT_IN_CACHE) {
                res = this.createModelObject(row);
                this.getModelCache().put(row, res, Collections.singleton(row));
            } else {
                res = cached.getRes();
            }
        } else {
            res = this.createModelObject(row);
        }
        return res;
    }

    private final Object createModelObject(SQLRowAccessor row) {
        Constructor<? extends RowBacked> ctor;
        if (!RowBacked.class.isAssignableFrom(this.getModelClass())) {
            throw new IllegalStateException("modelClass must inherit from RowBacked: " + this.getModelClass());
        }
        try {
            ctor = this.getModelClass().getConstructor(SQLRowAccessor.class);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "no SQLRowAccessor constructor", e);
        }
        try {
            return ctor.newInstance(row);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(RuntimeException.class, "pb creating instance", e);
        }
    }

    protected Class<? extends RowBacked> getModelClass() {
        return null;
    }

    public boolean equals(SQLRow row, SQLRow row2) throws SQLException {
        this.check(row);
        if (!row2.getTable().equals(this.getTable())) {
            return false;
        }
        if (row.equals(row2)) {
            return true;
        }
        if (!row.getAllValues().equals(row2.getAllValues())) {
            return false;
        }
        for (String shared : this.getSharedForeignFields()) {
            if (row.getInt(shared) == row2.getInt(shared)) continue;
            return false;
        }
        for (String prvt : this.getPrivateForeignFields()) {
            SQLElement foreignElement = this.getForeignElement(prvt);
            if (foreignElement.dontDeepCopy() || foreignElement.equals(row.getForeignRow(prvt), row2.getForeignRow(prvt))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsRecursive(SQLRow row, SQLRow row2) throws SQLException {
        return new SQLElementRowR(this, row).equals(new SQLElementRowR(this, row2));
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SQLElement) {
            SQLElement o = (SQLElement)obj;
            boolean parentEq = CompareUtils.equals(this.getParentForeignField(), o.getParentForeignField());
            return this.getTable().equals(o.getTable()) && this.getSharedForeignFields().equals(o.getSharedForeignFields()) && parentEq && this.getPrivateForeignFields().equals(o.getPrivateForeignFields()) && this.getChildrenReferentFields().equals(o.getChildrenReferentFields());
        }
        return false;
    }

    public final int hashCode() {
        return this.getTable().hashCode() + this.getSharedForeignFields().hashCode() + this.getPrivateForeignFields().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " '" + this.plural + "'";
    }

    public final void addComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.put((Object)id, t);
    }

    public final void removeComponentFactory(String id, ITransformer<Tuple2<SQLElement, String>, SQLComponent> t) {
        if (t == null) {
            throw new NullPointerException();
        }
        this.components.remove(id, t);
    }

    private final SQLComponent createComponent(String id, boolean defaultItem) {
        String actualID = defaultItem ? DEFAULT_COMP_ID : id;
        Tuple2<SQLElement, String> t = Tuple2.create(this, id);
        Iterator iter = ((LinkedList)this.components.getNonNull(actualID)).descendingIterator();
        while (iter.hasNext()) {
            SQLComponent res = (SQLComponent)((ITransformer)iter.next()).transformChecked(t);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public final SQLComponent createDefaultComponent() {
        return this.createComponent(DEFAULT_COMP_ID);
    }

    public final SQLComponent createComponent(String id) {
        SQLComponent res = this.createComponent(id, false);
        if (res == null) {
            res = CompareUtils.equals(id, DEFAULT_COMP_ID) ? this.createComponent() : this.createComponent(id, true);
        }
        res.setCode(id);
        return res;
    }

    protected abstract SQLComponent createComponent();

    public final boolean putAdditionalField(String field) {
        return this.putAdditionalField(field, (JComponent)null);
    }

    public final boolean putAdditionalField(String field, JTextComponent comp) {
        return this.putAdditionalField(field, (JComponent)comp);
    }

    public final boolean putAdditionalField(String field, SQLTextCombo comp) {
        return this.putAdditionalField(field, (JComponent)comp);
    }

    private final boolean putAdditionalField(String field, JComponent comp) {
        if (this.additionalFields.containsKey(field)) {
            return false;
        }
        this.additionalFields.put(field, comp);
        return true;
    }

    public final Map<String, JComponent> getAdditionalFields() {
        return Collections.unmodifiableMap(this.additionalFields);
    }

    public final void removeAdditionalField(String field) {
        this.additionalFields.remove(field);
    }

    public final boolean askArchive(Component comp, Number ids) {
        return this.askArchive(comp, Collections.singleton(ids));
    }

    public boolean askArchive(Component comp, Collection<? extends Number> ids) {
        boolean shouldArchive = false;
        if (ids.isEmpty()) {
            return true;
        }
        boolean plural = ids.size() > 1;
        String lines = plural ? "ces " + ids.size() + " lignes" : "cette ligne";
        try {
            if (!UserRightsManager.getCurrentUserRights().canDelete(this.getTable())) {
                throw new SQLException("forbidden");
            }
            TreesOfSQLRows trees = TreesOfSQLRows.createFromIDs(this, ids);
            CollectionMap<SQLTable, SQLRowAccessor> descs = trees.getDescendantsByTable();
            SortedMap<SQLField, Integer> externRefs = trees.getExternReferencesCount();
            if (descs.size() + externRefs.size() > 0) {
                int i;
                String msg = "";
                if (descs.size() > 0) {
                    msg = String.valueOf(StringUtils.firstUpThenLow(lines)) + (plural ? " sont utilis\u00e9es" : " est utilis\u00e9e") + " par : \n" + this.toString(descs);
                }
                if (externRefs.size() > 0) {
                    msg = String.valueOf(msg) + (descs.size() > 0 ? "\n\nDe plus les" : "Les");
                    msg = String.valueOf(msg) + " liens suivant vont \u00eatre IRREMEDIABLEMENT d\u00e9truit :\n" + this.toStringExtern(externRefs);
                }
                if ((i = this.askSerious(comp, String.valueOf(msg) + "\n\nVoulez vous effacer " + lines + " ainsi que toutes les lignes li\u00e9es ?", "Confirmation d'effacement")) == 0) {
                    msg = "";
                    if (externRefs.size() > 0) {
                        msg = "Les liens suivant vont \u00eatre IRREMEDIABLEMENT d\u00e9truit, ils ne pourront pas \u00eatre 'd\u00e9sarchiv\u00e9s' :\n" + this.toStringExtern(externRefs) + "\n\n";
                    }
                    if ((i = this.askSerious(comp, String.valueOf(msg) + "Voulez vous VRAIMENT effacer " + lines + " ainsi que toutes les lignes li\u00e9es ?", "Confirmation d'effacement")) == 0) {
                        shouldArchive = true;
                    } else {
                        JOptionPane.showMessageDialog(comp, "Aucune ligne effac\u00e9e.", "Information", 1);
                    }
                }
            } else {
                int i = this.askSerious(comp, "Voulez vous effacer " + lines + " ?", "Confirmation d'effacement");
                if (i == 0) {
                    shouldArchive = true;
                }
            }
            if (shouldArchive) {
                this.archive(trees, true);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            ExceptionHandler.handle(comp, "Impossible d'archiver " + this + " IDs " + ids, e);
            return false;
        }
    }

    private final String toString(MultiMap descs) {
        ArrayList<String> l = new ArrayList<String>();
        for (SQLTable t : descs.keySet()) {
            Collection rows = (Collection)descs.get(t);
            SQLElement elem = this.getElement(t);
            l.add(SQLElement.elemToString(rows.size(), elem));
        }
        return CollectionUtils.join(l, "\n");
    }

    private static final String elemToString(int count, SQLElement elem) {
        return "- " + (count == 1 ? elem.getSingularName() : String.valueOf(count) + " " + elem.getPluralName());
    }

    private final String toStringExtern(SortedMap<SQLField, Integer> externRef) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<SQLField, Integer> entry : externRef.entrySet()) {
            SQLField foreignKey = entry.getKey();
            int count = entry.getValue();
            String label = Configuration.getTranslator(foreignKey.getTable()).getLabelFor(foreignKey);
            String end2 = count > 1 ? " vont perdre leurs champs '" + label + "'" : " va perdre son champ '" + label + "'";
            l.add(String.valueOf(SQLElement.elemToString(count, this.getElement(foreignKey.getTable()))) + end2);
        }
        return CollectionUtils.join(l, "\n");
    }

    private final int askSerious(Component comp, String msg, String title) {
        return JOptionPane.showConfirmDialog(comp, msg, String.valueOf(title) + " (" + this.getPluralName() + ")", 0, 2);
    }

    static interface ChildProcessor<R extends SQLRowAccessor> {
        public void process(R var1, SQLField var2, R var3) throws SQLException;
    }

    public static enum ReferenceAction {
        SET_EMPTY,
        CASCADE,
        RESTRICT;

    }
}

