/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.ExceptionHandler;

public class RowItemViewMetadata {
    private static final String METADATA_TABLENAME = "RIV_METADATA";
    private final SQLTable table;
    private List<SQLRowValues> groups;
    private Map<String, List<SQLRowValues>> metas = new HashMap<String, List<SQLRowValues>>();

    public static SQLTable getMetaTable(final DBRoot root) throws SQLException {
        if (!root.contains(METADATA_TABLENAME)) {
            final SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLCreateTable createValueT = new SQLCreateTable(root, RowItemViewMetadata.METADATA_TABLENAME);
                    createValueT.setPlain(true);
                    createValueT.addColumn("ID", createValueT.getSyntax().getPrimaryIDDefinition());
                    createValueT.addVarCharColumn("ELEMENT_ID", 80);
                    createValueT.addVarCharColumn("COMPONENT_ID", 80);
                    createValueT.addVarCharColumn("GROUP_ID", 80);
                    createValueT.addVarCharColumn("ITEM_ID", 80);
                    createValueT.addVarCharColumn("LABEL", 256);
                    createValueT.addVarCharColumn("COLUMN_TITLE", 256);
                    createValueT.addVarCharColumn("DOCUMENTATION", 8192);
                    ds.execute(createValueT.asString());
                    SQLTable.setUndefID(root.getSchema(), createValueT.getName(), null);
                    root.getSchema().updateVersion();
                    return null;
                }
            });
            root.refetch();
        }
        return root.getTable(METADATA_TABLENAME);
    }

    public RowItemViewMetadata(DBRoot root) throws SQLException {
        this.table = RowItemViewMetadata.getMetaTable(root);
        this.fetchAllGroups();
    }

    private void fetchAllGroups() {
        SQLRowValues graph = new SQLRowValues(this.table);
        graph.put("ELEMENT_ID", null);
        graph.put("COMPONENT_ID", null);
        graph.put("GROUP_ID", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
        this.groups = fetcher.fetch();
    }

    public String getLabel(String sqlComponentId, String groupId, String itemId) {
        return this.getField(sqlComponentId, groupId, itemId, "LABEL");
    }

    public String getColumnTitle(String sqlComponentId, String groupId, String itemId) {
        return this.getField(sqlComponentId, groupId, itemId, "COLUMN_TITLE");
    }

    public String getDocumentation(String sqlComponentId, String groupId, String itemId) {
        return this.getField(sqlComponentId, groupId, itemId, "DOCUMENTATION");
    }

    public String getField(String sqlComponentId, String groupId, String itemId, String field) {
        List<SQLRowValues> metas = this.getMetaForComponent(sqlComponentId);
        for (SQLRowValues sqlRowValues : metas) {
            if (!sqlRowValues.getString("GROUP_ID").equals(groupId) || !sqlRowValues.getString("ITEM_ID").equals(itemId)) continue;
            return sqlRowValues.getString(field);
        }
        return null;
    }

    private List<SQLRowValues> getMetaForComponent(String sqlComponentId) {
        List<SQLRowValues> result = this.metas.get(sqlComponentId);
        if (result == null) {
            boolean metaExists = false;
            for (SQLRowValues sqlRowValues : this.groups) {
                if (!sqlRowValues.getString("COMPONENT_ID").equals(sqlComponentId)) continue;
                metaExists = true;
                break;
            }
            if (!metaExists) {
                return new ArrayList<SQLRowValues>(0);
            }
            SQLRowValues graph = new SQLRowValues(this.table);
            graph.put("ELEMENT_ID", null);
            graph.put("COMPONENT_ID", null);
            graph.put("GROUP_ID", null);
            graph.put("ITEM_ID", null);
            graph.put("LABEL", null);
            graph.put("COLUMN_TITLE", null);
            graph.put("DOCUMENTATION", null);
            SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
            result = fetcher.fetch();
            this.metas.put(sqlComponentId, result);
        }
        return result;
    }

    public void setLabel(String sqlElementId, String sqlComponentId, String groupId, String itemId, String value) {
        this.setField(sqlElementId, sqlComponentId, groupId, itemId, "LABEL", value);
    }

    public void setColumnTitle(String sqlElementId, String sqlComponentId, String groupId, String itemId, String value) {
        this.setField(sqlElementId, sqlComponentId, groupId, itemId, "COLUMN_TITLE", value);
    }

    public void setDocumentation(String sqlElementId, String sqlComponentId, String groupId, String itemId, String value) {
        this.setField(sqlElementId, sqlComponentId, groupId, itemId, "DOCUMENTATION", value);
    }

    public void setField(String sqlElementId, String sqlComponentId, String groupId, String itemId, String field, String value) {
        try {
            List<SQLRowValues> metas = this.getMetaForComponent(sqlComponentId);
            for (SQLRowValues sqlRowValues : metas) {
                if (!sqlRowValues.getString("ELEMENT_ID").equals(sqlElementId) || !sqlRowValues.getString("GROUP_ID").equals(groupId) || !sqlRowValues.getString("ITEM_ID").equals(itemId)) continue;
                sqlRowValues.put(field, value);
                sqlRowValues.commit();
                return;
            }
            SQLRowValues newRow = new SQLRowValues(this.table);
            newRow.put("ELEMENT_ID", sqlElementId);
            newRow.put("COMPONENT_ID", sqlComponentId);
            newRow.put("GROUP_ID", groupId);
            newRow.put("ITEM_ID", itemId);
            newRow.put(field, value);
            newRow.commit();
            this.groups.add(newRow);
        }
        catch (SQLException e) {
            ExceptionHandler.handle("No metadata for itemId " + itemId + " of group " + groupId, e);
        }
    }
}

