/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.DocumentationEditorFrame;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.LayoutHints;

public class GroupSQLComponent
extends BaseSQLComponent {
    private final Group group;
    private final int columns = 2;
    private final boolean forceViewOnly = true;
    private final Map<String, JComponent> labels = new HashMap<String, JComponent>();
    private final Map<String, JComponent> editors = new HashMap<String, JComponent>();
    private final Map<String, String> docs = new HashMap<String, String>();

    public GroupSQLComponent(SQLElement element, Group group) {
        super(element);
        this.group = group;
    }

    @Override
    protected void addViews() {
        this.group.dumpOneColumn();
        this.setLayout(new GridBagLayout());
        this.group.sort();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.layout(this.group, 0, LayoutHints.DEFAULT_GROUP_HINTS, 0, 0, c);
    }

    public int layout(Group currentGroup, Integer order, LayoutHints size, int x, int level, GridBagConstraints c) {
        if (currentGroup.isEmpty()) {
            System.out.print(" (" + x + ")");
            String id = currentGroup.getId();
            System.out.print(order + " " + id + "[" + size + "]");
            c.gridwidth = 1;
            if (size.showLabel()) {
                c.weightx = 0.0;
                if (size.isSeparated()) {
                    c.gridx = 0;
                    c.gridwidth = 4;
                    c.fill = 0;
                } else {
                    c.fill = 2;
                }
                this.add((Component)this.getLabel(id), c);
                if (size.isSeparated()) {
                    ++c.gridy;
                } else {
                    ++c.gridx;
                }
            }
            JComponent editor = this.getEditor(id);
            if (size.maximizeWidth() && size.maximizeHeight()) {
                c.fill = 1;
            } else if (size.maximizeWidth()) {
                c.fill = 2;
            } else if (size.maximizeHeight()) {
                c.fill = 3;
            } else {
                c.fill = 0;
                DefaultGridBagConstraints.lockMinimumSize(editor);
            }
            if (size.fill()) {
                c.weighty = 1.0;
                c.gridwidth = 2 * 2;
            }
            if (c.gridx % 2 == 1) {
                c.weightx = 1.0;
            }
            this.add((Component)editor, c);
            try {
                this.addView(editor, id);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            c.weighty = 0.0;
            ++c.gridx;
            if (x % 2 != 0) {
                c.gridx = 0;
                ++c.gridy;
            }
        }
        if (size.isSeparated()) {
            x = 0;
            c.gridx = 0;
            ++c.gridy;
        }
        int stop = currentGroup.getSize();
        int i = 0;
        while (i < stop) {
            Group subGroup = currentGroup.getGroup(i);
            Integer subGroupOrder = currentGroup.getOrder(i);
            LayoutHints subGroupSize = currentGroup.getLayoutHints(i);
            x = this.layout(subGroup, subGroupOrder, subGroupSize, x, level + 1, c);
            ++i;
        }
        if (currentGroup.isEmpty()) {
            ++x;
        } else if (size.maximizeWidth()) {
            c.gridx = 0;
            ++c.gridy;
        }
        return x;
    }

    public JComponent createEditor(String id) {
        JComponent comp;
        SQLField field;
        if (id.startsWith("(") && id.endsWith(")*")) {
            try {
                String table = id.substring(1, id.length() - 2).trim();
                String idEditor = String.valueOf(GlobalMapper.getInstance().getIds(table).get(0)) + ".editor";
                System.out.println("Editor: " + idEditor);
                Class cl = (Class)GlobalMapper.getInstance().get(idEditor);
                return (JComponent)cl.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((field = this.getTable().getFieldRaw(id)) == null) {
            JLabelBold jLabel = new JLabelBold("No field " + id);
            jLabel.setForeground(Color.RED.darker());
            String t = "<html>";
            Set<SQLField> fields = this.getTable().getFields();
            for (SQLField sqlField : fields) {
                t = String.valueOf(t) + sqlField.getFullName() + "<br>";
            }
            t = String.valueOf(t) + "</html>";
            jLabel.setToolTipText(t);
            return jLabel;
        }
        SQLType type = field.getType();
        if (this.getElement().getPrivateElement(field.getName()) != null) {
            SQLComponent sqlcomp = this.getElement().getPrivateElement(field.getName()).createDefaultComponent();
            DefaultElementSQLObject dobj = new DefaultElementSQLObject(this, sqlcomp);
            dobj.setDecorated(false);
            dobj.showSeparator(false);
            DefaultGridBagConstraints.lockMinimumSize(sqlcomp);
            comp = dobj;
        } else if (field.isKey()) {
            comp = new ElementComboBox();
            comp.setOpaque(false);
        } else if (Boolean.class.isAssignableFrom(type.getJavaType())) {
            comp = new JCheckBox(" ");
            comp.setOpaque(false);
        } else if (Date.class.isAssignableFrom(type.getJavaType())) {
            comp = new JDate();
            comp.setOpaque(false);
        } else {
            comp = new JTextField(Math.min(30, type.getSize()));
        }
        return comp;
    }

    public JComponent createLabel(String id) {
        JLabel jLabel;
        String fieldLabel = super.getLabelFor(id);
        if (fieldLabel == null) {
            jLabel = new JLabel(id);
            jLabel.setForeground(Color.RED.darker());
        } else {
            jLabel = new JLabel(fieldLabel);
        }
        jLabel.setHorizontalAlignment(4);
        this.registerPopupMenu(jLabel, id);
        String doc = ((PropsConfiguration)Configuration.getInstance()).getMetadata().getDocumentation(this.getCode(), this.group.getId(), id);
        this.setDocumentation(jLabel, id, doc);
        jLabel.setToolTipText(doc);
        return jLabel;
    }

    private void registerPopupMenu(final JComponent label, final String id) {
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3 && e.getModifiersEx() == 128) {
                    JPopupMenu popMenu = new JPopupMenu();
                    JMenu menuItemInfo = new JMenu("Information");
                    menuItemInfo.add(new JMenuItem("id: " + id));
                    menuItemInfo.add(new JMenuItem("label: " + GroupSQLComponent.this.getLabel(id).getClass().getName()));
                    menuItemInfo.add(new JMenuItem("editor: " + GroupSQLComponent.this.getEditor(id).getClass().getName()));
                    popMenu.add(menuItemInfo);
                    JMenuItem menuItemDoc = new JMenuItem("Modifier la documentation");
                    menuItemDoc.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new DocumentationEditorFrame(GroupSQLComponent.this, id, GroupSQLComponent.this.getDocumentation(id)).setVisible(true);
                        }
                    });
                    popMenu.add(menuItemDoc);
                    popMenu.show(label, e.getX(), e.getY());
                }
            }
        });
    }

    public void setDocumentation(JComponent jLabel, String id, String text) {
        this.docs.put(id, text);
        if (text != null) {
            jLabel.setToolTipText(text);
        }
    }

    public void setDocumentation(String id, String text) {
        this.setDocumentation(this.getLabel(id), id, text);
    }

    public void saveDocumentation(String id, String text) {
        this.setDocumentation(id, text);
        ((PropsConfiguration)Configuration.getInstance()).getMetadata().setDocumentation(this.getElement().getCode(), this.getCode(), this.group.getId(), id, text);
    }

    public String getDocumentation(String id) {
        return this.docs.get(id);
    }

    public JComponent getLabel(String id) {
        JComponent label = this.labels.get(id);
        if (label == null) {
            label = this.createLabel(id);
            this.labels.put(id, label);
        }
        return label;
    }

    public JComponent getEditor(String id) {
        JComponent editor = this.editors.get(id);
        if (editor == null) {
            editor = this.createEditor(id);
            this.editors.put(id, editor);
        }
        return editor;
    }
}

