/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.correct;

import java.sql.SQLException;
import java.util.Collections;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.changer.convert.OrderToDecimal;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.ReOrder;

public class CorrectOrder
extends Changer<SQLTable> {
    private boolean force = false;

    public CorrectOrder(DBSystemRoot b) {
        super(b);
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.setForce(Boolean.getBoolean("org.openconcerto.sql.changer.force"));
    }

    public final boolean isForce() {
        return this.force;
    }

    public final void setForce(boolean force) {
        this.force = force;
    }

    @Override
    protected void changeImpl(SQLTable table) throws SQLException {
        this.getStream().print(String.valueOf(table.getName()) + "... ");
        if (table.isOrdered()) {
            OrderToDecimal orderToDecimal = new OrderToDecimal(this.getSystemRoot());
            orderToDecimal.setQuiet(true);
            orderToDecimal.change(table);
            boolean isUnique = CorrectOrder.isOrderUnique(table);
            if (!this.isForce() && isUnique && this.noNulls(table)) {
                this.getStream().println("correctly ordered");
            } else {
                ReOrder.create(table).exec();
                this.getStream().print("order fixed, ");
                if (isUnique) {
                    this.getStream().println("already unique");
                } else {
                    String order = table.getOrderField().getName();
                    AlterTable alter = (AlterTable)new AlterTable(table).addUniqueConstraint(String.valueOf(table.getName()) + "_order", Collections.singletonList(order));
                    this.getDS().execute(alter.asString());
                    this.getStream().println("unique on " + order + " added");
                }
            }
        } else {
            this.getStream().println("not ordered");
        }
    }

    private boolean noNulls(SQLTable table) {
        SQLSelect sel = new SQLSelect(table.getBase());
        sel.addSelectFunctionStar("count");
        sel.setWhere(new Where((FieldRef)table.getOrderField(), "is", (Object)null));
        return ((Number)this.getDS().executeScalar(sel.asString())).intValue() == 0;
    }

    private static final boolean isOrderUnique(SQLTable table) throws SQLException {
        return table.getConstraint(SQLSyntax.ConstraintType.UNIQUE, Collections.singletonList(table.getOrderField().getName())) != null;
    }
}

