/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.utils.StringUtils;

public abstract class Change {
    public static final Properties props = new Properties();
    protected final DBStructureItem<?> root;

    static {
        props.put("jdbc.connection.allowMultiQueries", "true");
    }

    protected Change(DBStructureItem<?> root) {
        this.root = root;
    }

    public Change() throws IOException {
        this(new PropsConfiguration(new File("changeBase.properties"), props).getRoot());
    }

    protected final void exec(String ... nameNparams) throws SQLException {
        if (nameNparams.length == 0) {
            throw new IllegalArgumentException("usage: " + this.getClass().getName() + " changer params...");
        }
        String[] params = new String[nameNparams.length - 1];
        System.arraycopy(nameNparams, 1, params, 0, params.length);
        this.exec(nameNparams[0], params);
    }

    protected final void exec(String changerName, String ... params) throws SQLException {
        Class<? extends Changer> changer = this.findClass(changerName);
        if (changer == null) {
            throw new IllegalArgumentException(String.valueOf(changerName) + " not found.");
        }
        this.exec(changer, params);
    }

    public void exec(Class<? extends Changer> changer, String ... params) throws SQLException {
        if (params.length == 0) {
            Changer.change(this.root, changer);
        } else {
            DBSystemRoot dBSystemRoot;
            ArrayList<SQLName> names = new ArrayList<SQLName>(params.length);
            HashSet<String> children = new HashSet<String>();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                SQLName n3 = SQLName.parse(string);
                names.add(n3);
                children.add(n3.getFirst());
                ++n2;
            }
            if (this.root instanceof DBSystemRoot && !(dBSystemRoot = (DBSystemRoot)this.root).getRootsToMap().containsAll(children)) {
                dBSystemRoot.addRoots(new ArrayList<String>(children));
            }
            for (SQLName sQLName : names) {
                Changer.change(this.root.getDescendant(sQLName), changer);
            }
        }
    }

    public final Class<? extends Changer> findClass(String converter) {
        String normalized = StringUtils.firstUp(converter);
        Class<? extends Changer> res = null;
        for (String pkg : this.getPackages()) {
            res = this.findClass(pkg, normalized);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected List<String> getPackages() {
        ArrayList<String> res = new ArrayList<String>();
        Class<?> c = this.getClass();
        while (c != Change.class) {
            res.add(String.valueOf(c.getPackage().getName()) + "." + c.getSimpleName().toLowerCase());
            c = c.getSuperclass();
        }
        return res;
    }

    protected final Class<? extends Changer> findClass(String pkgName, String converter) {
        try {
            Class<?> c = Class.forName(String.valueOf(pkgName) + '.' + converter);
            return c.asSubclass(Changer.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }
}

