/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.io.File;
import java.io.IOException;
import org.openconcerto.sql.ShowAs;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.utils.FileUtils;

public abstract class Configuration {
    private static Configuration instance;

    public static File getDefaultConfDir() {
        return new File(System.getProperty("user.home"), ".java/ilm/sql-config/");
    }

    public static SQLFieldTranslator getTranslator(SQLTable t) {
        return Configuration.getInstance().getTranslator();
    }

    public static Configuration getInstance() {
        return instance;
    }

    public static final void setInstance(Configuration instance) {
        Configuration.instance = instance;
    }

    public abstract ShowAs getShowAs();

    public abstract SQLBase getBase();

    public abstract DBRoot getRoot();

    public abstract DBSystemRoot getSystemRoot();

    public abstract SQLFilter getFilter();

    public abstract SQLFieldTranslator getTranslator();

    public abstract SQLElementDirectory getDirectory();

    public abstract File getWD();

    public String getAppName() {
        return "unnamed application";
    }

    public final String getAppID() {
        return String.valueOf(this.getAppName()) + this.getAppIDSuffix();
    }

    protected String getAppIDSuffix() {
        return "";
    }

    public File getConfDir() {
        return new File(Configuration.getDefaultConfDir(), this.getAppID());
    }

    public final File getConfDirForRoot() {
        return this.getConfDir(this.getRoot());
    }

    public final File migrateToConfDirForRoot(String name) {
        File oldFile = new File(this.getConfDir(), name);
        File newFile = new File(this.getConfDirForRoot(), name);
        if (oldFile.exists() && !newFile.exists()) {
            try {
                FileUtils.mkdir_p(newFile.getParentFile());
                oldFile.renameTo(newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                FileUtils.rmR(oldFile);
            }
        }
        return newFile;
    }

    public final File getConfDir(DBStructureItem<?> db) {
        return DBItemFileCache.getDescendant(new File(this.getConfDir(), "dataDepedent"), DBFileCache.getJDBCAncestorNames(db, true));
    }

    public Configuration add(Configuration o) {
        this.getShowAs().putAll(o.getShowAs());
        this.getTranslator().putAll(o.getTranslator());
        this.getDirectory().putAll(o.getDirectory());
        return this;
    }

    public abstract void destroy();
}

