/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ql;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.openconcerto.ql.LabelImage;
import org.openconcerto.ql.LabelLine;
import org.openconcerto.ql.QLPrinter;

public class LabelCreator {
    private final List<LabelLine> lines = new ArrayList<LabelLine>();
    private final List<LabelImage> images = new ArrayList<LabelImage>();
    private Font defaultFont = new Font("Serif", 0, 50);
    private int width;
    private int leftMargin;
    private int topMargin;

    public LabelCreator() {
        this(720);
    }

    public LabelCreator(int width) {
        this.width = width;
    }

    public void addLineNormal(String text) {
        this.lines.add(new LabelLine(text, this.defaultFont));
    }

    public void addLineBold(String text) {
        this.lines.add(new LabelLine(text, this.defaultFont.deriveFont(1)));
    }

    public void addLine(LabelLine line) {
        this.lines.add(line);
    }

    public void addImage(BufferedImage img, int x, int y) {
        this.images.add(new LabelImage(img, x, y));
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        if (leftMargin > this.width) {
            throw new IllegalArgumentException("Left margin too big");
        }
    }

    public BufferedImage getImage() {
        int currentY;
        BufferedImage im = new BufferedImage(this.width, this.width, 2);
        Graphics2D g2 = im.createGraphics();
        int currentX = this.leftMargin;
        int maxHeight = currentY = this.topMargin;
        int i = 0;
        while (i < this.images.size()) {
            LabelImage labelImage = this.images.get(i);
            maxHeight = Math.max(maxHeight, labelImage.y + labelImage.img.getHeight());
            ++i;
        }
        i = 0;
        while (i < this.lines.size()) {
            LabelLine line = this.lines.get(i);
            g2.setFont(line.font);
            Rectangle2D rect = g2.getFontMetrics().getStringBounds(line.txt, g2);
            int h = (int)rect.getHeight();
            int w = (int)rect.getWidth();
            while (currentX + w > this.width) {
                float fSize = line.font.getSize2D() - 1.0f;
                if (fSize < 3.0f) break;
                line.font = line.font.deriveFont(fSize);
                g2.setFont(line.font);
                rect = g2.getFontMetrics().getStringBounds(line.txt, g2);
                h = (int)rect.getHeight();
                w = (int)rect.getWidth();
            }
            line.x = currentX;
            line.y = currentY + g2.getFontMetrics().getAscent();
            currentY += h;
            ++i;
        }
        g2.dispose();
        int finalHeight = currentY + this.topMargin;
        im = new BufferedImage(this.width, finalHeight, 2);
        g2 = im.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.width, finalHeight);
        g2.setColor(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i2 = 0;
        while (i2 < this.images.size()) {
            LabelImage labelImage = this.images.get(i2);
            g2.drawImage((Image)labelImage.img, labelImage.x, labelImage.y, null);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.lines.size()) {
            LabelLine line = this.lines.get(i2);
            g2.setFont(line.font);
            g2.drawString(line.txt, line.x, line.y);
            ++i2;
        }
        g2.dispose();
        return im;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public static void main(String[] args) {
        LabelCreator c = new LabelCreator(720);
        c.setLeftMargin(10);
        c.setTopMargin(10);
        c.setDefaultFont(new Font("Verdana", 0, 50));
        c.addLineBold("ILM Informatique");
        c.addLineNormal("22 place de la lib\u00e9ration");
        c.addLineNormal("80100 ABBEVILLE");
        try {
            ImageIO.write((RenderedImage)c.getImage(), "PNG", new File("out.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        QLPrinter prt = new QLPrinter("192.168.1.103");
        try {
            prt.print(c.getImage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

