/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.text;

import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.openoffice.ODDocument;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.XMLFormatVersion;
import org.openconcerto.openoffice.text.Paragraph;
import org.openconcerto.openoffice.text.TextNode;

public class TextDocument
extends ODDocument {
    public static TextDocument createFromFile(File f) throws IOException {
        return new ODPackage(f).getTextDocument();
    }

    public static TextDocument get(ODPackage fd) {
        return fd.hasODDocument() ? fd.getTextDocument() : new TextDocument(fd);
    }

    public static TextDocument createEmpty(String s) throws IOException {
        return TextDocument.createEmpty(s, XMLFormatVersion.getDefault());
    }

    public static TextDocument createEmpty(String s, XMLFormatVersion ns) throws IOException {
        ContentTypeVersioned ct = ContentType.TEXT.getVersioned(ns.getXMLVersion());
        TextDocument res = ct.createPackage(ns).getTextDocument();
        Element textP = Paragraph.createEmpty(ns.getXMLVersion());
        textP.addContent(s);
        res.getBody().addContent(textP);
        return res;
    }

    private TextDocument(ODPackage orig) {
        super(orig);
    }

    public final Paragraph getParagraph(int i) {
        Element proto = Paragraph.createEmpty(this.getVersion());
        Element child = (Element)this.getBody().getChildren(proto.getName(), proto.getNamespace()).get(i);
        return new Paragraph(child, this);
    }

    public synchronized void add(TextNode<?> p) {
        this.add(p, null, -1);
    }

    public synchronized void add(TextNode<?> p, Element where, int index) {
        Element addToElem;
        Element element = addToElem = where == null ? this.getBody() : where;
        if (index < 0) {
            addToElem.addContent(p.getElement());
        } else {
            addToElem.addContent(index, p.getElement());
        }
        try {
            p.setDocument(this);
        }
        catch (RuntimeException e) {
            p.getElement().detach();
            throw e;
        }
    }
}

