/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.Duration;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODEpoch;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.spreadsheet.MutableCell;
import org.openconcerto.openoffice.style.data.DataStyle;

public class NumberStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<NumberStyle> DESC = new DataStyle.DataStyleDesc<NumberStyle>(NumberStyle.class, XMLVersion.OD, "number-style", "N"){

        @Override
        public NumberStyle create(ODPackage pkg, Element e) {
            return new NumberStyle(pkg, e);
        }
    };

    public static final Number toNumber(Object value, ODEpoch epoch) {
        Number res;
        if (value instanceof Number) {
            res = (Number)value;
        } else if (value instanceof Boolean) {
            res = (Boolean)value != false ? 1 : 0;
        } else if (value instanceof Duration || value instanceof Date || value instanceof Calendar) {
            if (value instanceof Duration) {
                res = epoch.getDays((Duration)value);
            } else {
                Calendar cal;
                if (value instanceof Calendar) {
                    cal = (Calendar)value;
                } else {
                    cal = Calendar.getInstance();
                    cal.setTime((Date)value);
                }
                res = epoch.getDays(cal);
            }
        } else {
            res = null;
        }
        return res;
    }

    public NumberStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.FLOAT);
    }

    @Override
    protected Number convertNonNull(Object value) {
        return NumberStyle.toNumber(value, this.getEpoch());
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Number n = (Number)o;
        Namespace numberNS = this.getElement().getNamespace();
        StringBuilder sb = new StringBuilder();
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            if (elem.getName().equals("text")) {
                sb.append(elem.getText());
                continue;
            }
            if (elem.getName().equals("number") || elem.getName().equals("scientific-number")) {
                sb.append(this.formatNumberOrScientificNumber(elem, n, defaultStyle));
                continue;
            }
            if (!elem.getName().equals("fraction")) continue;
            this.reportError("Fractions not supported", lenient);
            sb.append(MutableCell.formatNumber(n, defaultStyle));
        }
        return sb.toString();
    }
}

