/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.Log;
import org.openconcerto.openoffice.ODEpoch;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.Style;
import org.openconcerto.openoffice.StyleDesc;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.BooleanStyle;
import org.openconcerto.openoffice.style.data.CurrencyStyle;
import org.openconcerto.openoffice.style.data.DateStyle;
import org.openconcerto.openoffice.style.data.NumberStyle;
import org.openconcerto.openoffice.style.data.PercentStyle;
import org.openconcerto.openoffice.style.data.TextStyle;
import org.openconcerto.openoffice.style.data.TimeStyle;
import org.openconcerto.openoffice.text.TextStyle;
import org.openconcerto.utils.NumberUtils;

public abstract class DataStyle
extends Style {
    private static final int DEFAULT_GROUPING_SIZE = new DecimalFormat().getGroupingSize();
    private static final int DEFAULT_DECIMAL_PLACES = 2;
    private static final Pattern QUOTE_PATRN = Pattern.compile("'", 16);
    private static final Pattern EXP_PATTERN = Pattern.compile("E(\\d+)$");
    public static final DataStyleDesc<?>[] DATA_STYLES_DESCS = new DataStyleDesc[]{NumberStyle.DESC, PercentStyle.DESC, TextStyle.DESC, CurrencyStyle.DESC, DateStyle.DESC, TimeStyle.DESC, BooleanStyle.DESC};
    private final ODValueType type;
    private TextStyle.StyleTextProperties textProps;

    public static int getDecimalPlaces(CellStyle defaultStyle) {
        int res = defaultStyle != null && defaultStyle.getTableCellProperties().getDecimalPlaces() != null ? defaultStyle.getTableCellProperties().getDecimalPlaces() : 2;
        return res;
    }

    public static void addStringLiteral(StringBuilder formatSB, String s) {
        formatSB.append('\'');
        formatSB.append(QUOTE_PATRN.matcher(s).replaceAll("''"));
        formatSB.append('\'');
    }

    protected DataStyle(ODPackage pkg, Element elem, ODValueType type) {
        super(pkg, elem);
        this.type = type;
    }

    public final ODValueType getDataType() {
        return this.type;
    }

    public final ODEpoch getEpoch() {
        return this.getPackage().getODDocument().getEpoch();
    }

    public final Object convert(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException();
        }
        Object res = this.canFormat(o.getClass()) ? o : this.convertNonNull(o);
        assert (res == null || this.canFormat(res.getClass()));
        return res;
    }

    protected abstract Object convertNonNull(Object var1);

    public final boolean canFormat(Class<?> toFormat) {
        return this.getDataType().canFormat(toFormat);
    }

    public final String getTitle() {
        return this.getElement().getAttributeValue("title", this.getElement().getNamespace());
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public abstract String format(Object var1, CellStyle var2, boolean var3) throws UnsupportedOperationException;

    protected final void reportError(String msg, boolean lenient) throws UnsupportedOperationException {
        if (!lenient) {
            throw new UnsupportedOperationException(msg);
        }
        Log.get().warning(msg);
    }

    protected final String formatNumberOrScientificNumber(Element elem, Number n, CellStyle defaultStyle) {
        return this.formatNumberOrScientificNumber(elem, n, 1, defaultStyle);
    }

    protected final String formatNumberOrScientificNumber(Element elem, Number n, int multiplier, CellStyle defaultStyle) {
        Matcher m;
        boolean decSeparatorAlwaysShown;
        int minIntDig;
        Namespace numberNS = this.getElement().getNamespace();
        StringBuilder numberSB = new StringBuilder();
        List embeddedTexts = elem.getChildren("embedded-text", numberNS);
        TreeMap embeddedTextByPosition = new TreeMap(Collections.reverseOrder());
        for (Object o : embeddedTexts) {
            Element embeddedText = (Element)o;
            embeddedTextByPosition.put(Integer.valueOf(embeddedText.getAttributeValue("position", numberNS)), embeddedText.getText());
        }
        Attribute factorAttr = elem.getAttribute("display-factor", numberNS);
        double factor = (factorAttr != null ? Double.valueOf(factorAttr.getValue()) : 1.0) / (double)multiplier;
        boolean grouping = StyleProperties.parseBoolean(elem.getAttributeValue("grouping", numberNS), false);
        String minIntDigitsAttr = elem.getAttributeValue("min-integer-digits", numberNS);
        int n2 = minIntDig = minIntDigitsAttr == null ? 0 : Integer.parseInt(minIntDigitsAttr);
        if (minIntDig == 0) {
            numberSB.append('#');
        } else {
            int i = 0;
            while (i < minIntDig) {
                numberSB.append('0');
                ++i;
            }
        }
        String decReplacement = elem.getAttributeValue("decimal-replacement", numberNS);
        if (decReplacement != null && !NumberUtils.hasFractionalPart(n)) {
            decSeparatorAlwaysShown = true;
            numberSB.append('.');
            DataStyle.addStringLiteral(numberSB, decReplacement);
        } else {
            decSeparatorAlwaysShown = false;
            Attribute decPlacesAttr = elem.getAttribute("decimal-places", numberNS);
            int decPlaces = decPlacesAttr != null ? Integer.parseInt(decPlacesAttr.getValue()) : DataStyle.getDecimalPlaces(defaultStyle);
            if (decPlaces > 0) {
                numberSB.append('.');
                int i = 0;
                while (i < decPlaces) {
                    numberSB.append('0');
                    ++i;
                }
            }
        }
        Attribute minExpAttr = elem.getAttribute("min-exponent-digits", numberNS);
        if (minExpAttr != null) {
            numberSB.append('E');
            int i = 0;
            while (i < Integer.parseInt(minExpAttr.getValue())) {
                numberSB.append('0');
                ++i;
            }
        }
        DecimalFormat decFormat = new DecimalFormat(numberSB.toString());
        decFormat.setRoundingMode(RoundingMode.HALF_UP);
        decFormat.setGroupingUsed(grouping);
        decFormat.setGroupingSize(DEFAULT_GROUPING_SIZE);
        decFormat.setDecimalSeparatorAlwaysShown(decSeparatorAlwaysShown);
        String res = decFormat.format(NumberUtils.divide(n, factor));
        if (minExpAttr != null && (m = EXP_PATTERN.matcher(res)).find()) {
            res = String.valueOf(res.substring(0, m.start())) + "E+" + m.group(1);
        }
        if (embeddedTextByPosition.size() > 0) {
            int intDigits = Math.max(minIntDig, NumberUtils.intDigits(n));
            int offset = 0;
            for (Map.Entry e : embeddedTextByPosition.entrySet()) {
                String embeddedText = (String)e.getValue();
                int index = Math.max(0, offset + intDigits - (Integer)e.getKey());
                res = String.valueOf(res.substring(0, index)) + embeddedText + res.substring(index);
                offset += embeddedText.length();
            }
        }
        return res;
    }

    public static abstract class DataStyleDesc<S extends DataStyle>
    extends StyleDesc<S> {
        protected DataStyleDesc(Class<S> clazz, XMLVersion version, String elemName, String baseName) {
            super(clazz, version, elemName, baseName);
            this.setElementNS(this.getVersion().getNS("number"));
            this.getRefElementsMap().putAll((Object)"style:data-style-name", Arrays.asList("presentation:date-time-decl", "style:style", "text:creation-date", "text:creation-time", "text:database-display", "text:date", "text:editing-duration", "text:expression", "text:meta-field", "text:modification-date", "text:modification-time", "text:print-date", "text:print-time", "text:table-formula", "text:time", "text:user-defined", "text:user-field-get", "text:user-field-input", "text:variable-get", "text:variable-input", "text:variable-set"));
            this.getRefElementsMap().put((Object)"style:apply-style-name", (Object)"style:map");
        }
    }
}

