/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.style.data;

import java.text.DecimalFormatSymbols;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.ODValueType;
import org.openconcerto.openoffice.XMLVersion;
import org.openconcerto.openoffice.spreadsheet.CellStyle;
import org.openconcerto.openoffice.style.data.DataStyle;
import org.openconcerto.openoffice.style.data.DateStyle;
import org.openconcerto.openoffice.style.data.NumberStyle;

public class CurrencyStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<CurrencyStyle> DESC = new DataStyle.DataStyleDesc<CurrencyStyle>(CurrencyStyle.class, XMLVersion.OD, "currency-style", "N"){

        @Override
        public CurrencyStyle create(ODPackage pkg, Element e) {
            return new CurrencyStyle(pkg, e);
        }
    };

    public CurrencyStyle(ODPackage pkg, Element elem) {
        super(pkg, elem, ODValueType.CURRENCY);
    }

    @Override
    protected Object convertNonNull(Object o) {
        return NumberStyle.toNumber(o, this.getEpoch());
    }

    @Override
    public String format(Object o, CellStyle defaultStyle, boolean lenient) {
        Number n = (Number)o;
        Namespace numberNS = this.getElement().getNamespace();
        StringBuilder sb = new StringBuilder();
        List children = this.getElement().getChildren();
        for (Element elem : children) {
            if (!elem.getNamespace().equals(numberNS)) continue;
            if (elem.getName().equals("text")) {
                sb.append(elem.getText());
                continue;
            }
            if (elem.getName().equals("number")) {
                int multiplier = n.doubleValue() > 0.0 ? 1 : -1;
                sb.append(this.formatNumberOrScientificNumber(elem, n, multiplier, defaultStyle));
                continue;
            }
            if (!elem.getName().equals("currency-symbol")) continue;
            if (elem.getTextTrim().length() > 0) {
                sb.append(elem.getText());
                continue;
            }
            sb.append(new DecimalFormatSymbols(DateStyle.getLocale(elem)).getCurrencySymbol());
        }
        return sb.toString();
    }
}

