/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.openoffice.spreadsheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.openoffice.ODNode;
import org.openconcerto.openoffice.StyleProperties;
import org.openconcerto.openoffice.spreadsheet.Axis;
import org.openconcerto.openoffice.spreadsheet.Table;
import org.openconcerto.utils.Tuple2;

public class TableGroup
extends ODNode {
    private final Table<?> table;
    private final Axis axis;
    private final TableGroup parent;
    private final List<TableGroup> children;
    private int headerCount;
    private int first;
    private int size;

    static Tuple2<TableGroup, List<Element>> createRoot(Table<?> table, Axis col) {
        TableGroup group = new TableGroup(table, col);
        return Tuple2.create(group, group.flatten());
    }

    private TableGroup(Table<?> table, Axis col) {
        this(table, col, null, table.getElement(), 0);
    }

    private TableGroup(Table<?> table, TableGroup parent, Element elem, int first) {
        this(table, parent.axis, parent, elem, first);
    }

    private TableGroup(Table<?> table, Axis col, TableGroup parent, Element elem, int first) {
        super(elem);
        if (table == null) {
            throw new NullPointerException("null table");
        }
        this.table = table;
        this.axis = col;
        this.parent = parent;
        this.first = first;
        this.children = new ArrayList<TableGroup>();
    }

    private List<Element> flatten() {
        ArrayList<Element> res = new ArrayList<Element>(Math.max(128, this.getElement().getContentSize()));
        String fullName = this.axis.getElemName();
        String groupName = this.axis.getGroupName();
        String pluralName = this.axis.getPluralName();
        Element header = this.getElement().getChild(this.axis.getHeaderName(), this.getElement().getNamespace());
        this.headerCount = header != null ? Table.flattenChildren(res, header, this.axis) : 0;
        int size = this.headerCount;
        this.children.clear();
        ArrayList content = new ArrayList(this.getElement().getChildren());
        for (Element child : content) {
            if (child.getName().equals(fullName)) {
                size += Table.flatten1(res, child, this.axis);
                continue;
            }
            if (child.getName().equals(pluralName)) {
                size += Table.flattenChildren(res, child, this.axis);
                continue;
            }
            if (!child.getName().equals(groupName)) continue;
            TableGroup g = new TableGroup(this.getTable(), this, child, this.first + size);
            this.children.add(g);
            res.addAll(g.flatten());
            size += g.getSize();
        }
        this.size = size;
        return res;
    }

    public final Table<?> getTable() {
        return this.table;
    }

    public final TableGroup getParent() {
        return this.parent;
    }

    public final List<TableGroup> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    final TableGroup getDescendentOrSelfContaining(int y) {
        if (!this.contains(y)) {
            return null;
        }
        for (TableGroup g : this.getChildren()) {
            TableGroup res = g.getDescendentOrSelfContaining(y);
            if (res == null) continue;
            return res;
        }
        return this;
    }

    public final boolean isDisplayed() {
        if (this.getParent() == null) {
            return true;
        }
        return StyleProperties.parseBoolean(this.getElement().getAttributeValue("display", this.getElement().getNamespace()), true);
    }

    public final int getFirst() {
        return this.first;
    }

    public final int getHeaderCount() {
        return this.headerCount;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean contains(int i) {
        return i >= this.getFirst() && i < this.getFirst() + this.getSize();
    }

    final int getFollowingHeaderCount() {
        int res = this.getHeaderCount();
        for (TableGroup g : this.getChildren()) {
            if (g.getFirst() != this.getFirst() + res) break;
            res += g.getFollowingHeaderCount();
        }
        return res;
    }
}

